package jp.co.ogis_ri.citk.policytool.view.common;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * JTable の コンボボックスセルの, TableCellRenderer.
 */
public class ComboBoxTableCellRenderer extends JComboBox implements
        TableCellRenderer {
	/**
	 * シリアルバージョンID.
	 */
    private static final long serialVersionUID = 1L;

    /**
     * 新しい ComboBoxTableCellRenderer を構築します.
     * 
     * @param items コンボボックスの項目の配列.
     */
    public ComboBoxTableCellRenderer(Object[] items) {
        super();
        for (Object item : items) {
            addItem(item);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            setForeground(table.getForeground());
            setBackground(table.getBackground());
        }

        this.setSelectedItem(value);

        return this;
    }
}
