package jp.co.ogis_ri.citk.policytool.view.common;

import javax.swing.JTable;

/**
 * JTable 関連の機能を集めたユーティリティクラス.
 */
public class JTableUtil {
    /**
     * 新しい ViewTableDataJTableUtil を構築します.
     */
    private JTableUtil() {
    }

    /**
     * 行の高さを自動計算し, 設定します.<br>
     * toString()で取得される値の表示, および文字列配列で, 1行に1個ずつ表示する場合に対応します.<br>
     * 文字列の自動折り返しには対応しません.
     * 
     * @param table
     * 
     */
    public static void refreshTableRowHeight(JTable table) {
    	table.setVisible(false);
    	// テーブルの 1 行あたり高さを取得しておく
        int lineHeight = table.getFontMetrics(table.getFont()).getHeight();

        for (int rowIndex = 0; rowIndex < table.getRowCount(); rowIndex++) {

            int maxRowInRowCount = 1;
            for (int columnIndex = 0; columnIndex < table.getColumnCount(); columnIndex++) {
                Object value = table.getValueAt(rowIndex, columnIndex);
                int rowInRowCount = 1;
                if (value instanceof String[]) {
                    rowInRowCount = ((String[]) value).length;
                }

                maxRowInRowCount = Math.max(maxRowInRowCount, rowInRowCount);
            }

            // ポリシーリストテーブル 行高設定
            table.setRowHeight(rowIndex, lineHeight * maxRowInRowCount + 1);
        }
        
    	table.setVisible(true);
    }
}
