package jp.co.ogis_ri.citk.policytool.view.common;

import java.awt.Component;
import java.awt.Rectangle;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

/**
 * 文字列配列の, TableCellRenderer.<br>
 * 文字列配列を JTable のセルに表示する機能を提供します.
 */
public class StringArrayTableCellRenderer extends JPanel implements
        TableCellRenderer {
    /**
     * シリアルバージョンID.
     */
    private static final long serialVersionUID = 1L;

    /** フォーカスを持っていない場合のボーダー. */
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    /**
     * 新しい StringArrayTableCellRenderer を構築します.
     */
    public StringArrayTableCellRenderer() {
        setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }

        this.removeAll();

        // フォントの高さ取得
        int lineHeight = this.getFontMetrics(table.getFont()).getHeight();

        // Absolute レイアウトを設定.
        this.setLayout(null);

        // この JPanel のサイズを、セルの幅、高さと同じに設定
        Rectangle cellRect = table.getCellRect(row, column, false);
        this.setBounds(0, 0, cellRect.width, cellRect.height);

        String[] stringArrayValue = (String[]) value;
        for (int i = 0; i < stringArrayValue.length; i++) {
            JLabel label = new JLabel();

            label.setFont(table.getFont());
            label.setText(stringArrayValue[i]);
            label.setBounds(0, i * lineHeight + 1, this.getWidth(), lineHeight);
            label.setHorizontalAlignment(JLabel.LEFT);

            this.add(label);
        }

        return this;
    }
}
