package jp.co.ogis_ri.citk.policytool.view.importpolicy;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

import jp.co.ogis_ri.citk.policytool.common.exception.ExcelPolicyImportException;
import jp.co.ogis_ri.citk.policytool.common.exception.ExcelPolicyReadException;
import jp.co.ogis_ri.citk.policytool.common.exception.OpenAMAccessException;
import jp.co.ogis_ri.citk.policytool.service.importpolicy.ImportPolicyService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.MessageSourceAccessor;

/**
 * インポート画面の View.
 */
public class ImportPolicyView extends JDialog {
    /**
     * シリアルバージョンID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * インポートのサービス.
     */
    @Autowired
    private ImportPolicyService service;

    /**
     * メッセージリソース アクセスクラス.
     */
    private MessageSourceAccessor messages = null;

    /** ファイル名表示部パネル. */
    private JPanel fileNamePanel;
    
    /** ファイル名タイトルラベル. */
    private JLabel fileNameTitleLabel;
    
    /** ファイル名テキストフィールド */
    private JTextField fileNameTextField;
    
    /** 参照ボタン. */
    private JButton fileReferenceButton;
    
    /** ボタン表示部パネル. */
    private JPanel buttonPanel;
    
    /** OKボタン. */
    private JButton okButton;
    
    /** キャンセルボタン. */
    private JButton cancelButton;

    /** 処理結果 (データベースが変更されたか否か) */
    private boolean result;

    /**
     * 画面の初期化を行う.
     */
    public void init() {
        setTitle(messages.getMessage("view.importView.title"));
        setSize(400, 170);
        setMinimumSize(new Dimension(400, 140));
        setResizable(false);
        setLocationRelativeTo(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[] { 0, 0 };
        gridBagLayout.rowHeights = new int[] { 0, 0, 0 };
        gridBagLayout.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
        gridBagLayout.rowWeights = new double[] { 0.0, 0.0, Double.MIN_VALUE };
        getContentPane().setLayout(gridBagLayout);

        fileNamePanel = new JPanel();
        GridBagConstraints gbc_fileNamePanel = new GridBagConstraints();
        gbc_fileNamePanel.weighty = 1.0;
        gbc_fileNamePanel.weightx = 1.0;
        gbc_fileNamePanel.insets = new Insets(10, 10, 5, 10);
        gbc_fileNamePanel.fill = GridBagConstraints.BOTH;
        gbc_fileNamePanel.gridx = 0;
        gbc_fileNamePanel.gridy = 0;
        getContentPane().add(fileNamePanel, gbc_fileNamePanel);
        GridBagLayout gbl_fileNamePanel = new GridBagLayout();
        gbl_fileNamePanel.columnWidths = new int[] { 0, 0, 0, 0 };
        gbl_fileNamePanel.rowHeights = new int[] { 21, 0 };
        gbl_fileNamePanel.columnWeights = new double[] { 0.0, 0.0, 0.0,
                Double.MIN_VALUE };
        gbl_fileNamePanel.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
        fileNamePanel.setLayout(gbl_fileNamePanel);

        fileNameTitleLabel = new JLabel(messages.getMessage("view.importView.fileNamePanelLabel"));
        GridBagConstraints gbc_fileNameTitleLabel = new GridBagConstraints();
        gbc_fileNameTitleLabel.insets = new Insets(0, 0, 0, 5);
        gbc_fileNameTitleLabel.gridx = 0;
        gbc_fileNameTitleLabel.gridy = 0;
        fileNamePanel.add(fileNameTitleLabel, gbc_fileNameTitleLabel);

        fileNameTextField = new JTextField();
        GridBagConstraints gbc_fileNameTextField = new GridBagConstraints();
        gbc_fileNameTextField.weightx = 1.0;
        gbc_fileNameTextField.fill = GridBagConstraints.HORIZONTAL;
        gbc_fileNameTextField.insets = new Insets(0, 0, 0, 5);
        gbc_fileNameTextField.gridx = 1;
        gbc_fileNameTextField.gridy = 0;
        fileNamePanel.add(fileNameTextField, gbc_fileNameTextField);

        fileReferenceButton = new JButton(
                messages.getMessage("view.importView.fileReferenceButton"));
        fileReferenceButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                referenceFile();
            }
        });
        GridBagConstraints gbc_fileReferenceButton = new GridBagConstraints();
        gbc_fileReferenceButton.anchor = GridBagConstraints.NORTHWEST;
        gbc_fileReferenceButton.gridx = 2;
        gbc_fileReferenceButton.gridy = 0;
        fileNamePanel.add(fileReferenceButton, gbc_fileReferenceButton);

        buttonPanel = new JPanel();
        GridBagConstraints gbc_buttonPanel = new GridBagConstraints();
        gbc_buttonPanel.insets = new Insets(0, 10, 10, 10);
        gbc_buttonPanel.fill = GridBagConstraints.BOTH;
        gbc_buttonPanel.gridy = 1;
        gbc_buttonPanel.gridx = 0;
        getContentPane().add(buttonPanel, gbc_buttonPanel);

        okButton = new JButton(messages.getMessage("view.importView.okButton"));
        okButton.setPreferredSize(new Dimension(120, 32));
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ok();
            }
        });
        buttonPanel.add(okButton);

        cancelButton = new JButton(messages.getMessage("view.importView.cancelButton"));
        cancelButton.setPreferredSize(new Dimension(120, 32));
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                cancel();
            }
        });
        buttonPanel.add(cancelButton);

    }

    /**
     * コンストラクタ.
     * @param mes メッセージリソース アクセスクラス.
     */
    private ImportPolicyView(MessageSourceAccessor mes) {
        messages = mes;
        init();
    }

    /**
     * 参照ボタン押下時の処理.
     */
    private void referenceFile() {
        String fileName = fileNameTextField.getText();
        File file = new File(fileName);
    	
    	JFileChooser fileChooser = new JFileChooser();
    	fileChooser.setSelectedFile(file);
    	fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
    	FileFilter filter = new FileNameExtensionFilter( "Excel ファイル (*.xls)", "xls");
    	fileChooser.setFileFilter(filter);
    	fileChooser.setAcceptAllFileFilterUsed(false);
    	int selected = fileChooser.showOpenDialog(this);
    	if (selected == JFileChooser.APPROVE_OPTION) {
    		File selectedFile = fileChooser.getSelectedFile();
    		fileNameTextField.setText(selectedFile.getAbsolutePath());
    	}
    }

    /**
     * OKボタン押下時の処理.
     */
    private void ok() {
        // ファイル名
        String fileName = fileNameTextField.getText();
        try {
        	service.importPolicy(fileName);
        	result = true;
        	setVisible(false);
        }
        catch (ExcelPolicyReadException e) {
        	JOptionPane.showMessageDialog(this, e.getMessage());
        }
        catch (ExcelPolicyImportException e) {
        	JOptionPane.showMessageDialog(this, e.getMessage());
        }
        catch (OpenAMAccessException e) {
        	JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    /**
     * キャンセルボタン押下時の処理.
     */
    private void cancel() {
    	result = false;
        setVisible(false);
    }
    
    /**
     * 処理結果が更新されたか否かを返す.
     *
     * @return 処理結果が更新された場合 true, そうでない場合 false.
     */
    public boolean isRefresh() {
    	return result;
    }
}
