package jp.co.ogis_ri.citk.policytool.view.policyset;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.validation.ConstraintViolation;

import jp.co.ogis_ri.citk.policytool.common.exception.OpenAMAccessException;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import jp.co.ogis_ri.citk.policytool.service.policyset.PolicySetMode;
import jp.co.ogis_ri.citk.policytool.service.policyset.PolicySetService;
import jp.co.ogis_ri.citk.policytool.view.common.AutoCompleteDocumentListener;
import jp.co.ogis_ri.citk.policytool.view.common.ComboBoxTableCellEditor;
import jp.co.ogis_ri.citk.policytool.view.common.ComboBoxTableCellRenderer;
import jp.co.ogis_ri.citk.policytool.view.common.JTableColumnWidthCalculator;
import jp.co.ogis_ri.citk.policytool.view.common.RealmComboBoxItem;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.MessageSourceAccessor;

/**
 * ポリシー設定画面の View です.<br>
 * (★注) ルール/修正 テーブルの内容を変更すると, ルール/一覧 テーブルも自動的に変更される実装となっています.
 */
public class PolicySetView extends JDialog {
	/** ウィンドウの初期サイズ 幅. */
	private static final int INITIAL_WIDTH = 800;
	
	/** ウィンドウの初期サイズ 高さ. */
	private static final int INITIAL_HEIGHT = 600;
	
	/** テーブルのチェックボックス列の幅 */
	private static final int CHECK_BOX_TABLE_COLUMN_WIDTH = 21;

	/** シリアルバージョン番号. */
	private static final long serialVersionUID = 1L;

	/** ポリシー設定画面のサービス. */
	@Autowired
	private PolicySetService service = null;

	/** MessageSourceAccessor. */
	private MessageSourceAccessor messages = null;

	/** 閉じる前に追加/更新が行われた場合は true, そうでない場合は false. */
	private boolean result;

	/** メインパネル. */
	private JPanel mainPanel;

	/** タイトル部 パネル. */
	private JPanel titlePanel;

	/** タイトル部 レルム タイトルラベル. */
	private JLabel titleRealmTitleLabel;

	/** タイトル部 レルム コンボボックス. */
	private JComboBox titleRealmComboBox;

	/** タイトル部 レルム名 ラベル. */
	private JLabel titleRealmNameLabel;

	/** タイトル部 ダミー ラベル. */
	private JLabel titleRealmDummyLabel;

	/** タイトル部 ポリシー タイトル ラベル. */
	private JLabel titlePolicyTitleLabel;

	/** タイトル部 ポリシー テキストフィールド. */
	private JTextField titlePolicyTextField;

	/** タイトル部 ポリシー名 ラベル. */
	private JLabel titlePolicyNameLabel;

	/** ルールの TabbedPane. */
	private JTabbedPane ruleTabbedPane;

	/** ルール一覧 パネル. */
	private JPanel ruleListPanel;

	/** ルール一覧 タイトル部 パネル. */
	private JPanel ruleListTitlePanel;

	/** ルール追加 パネル */
	private JPanel ruleAddPanel;

	/** ルール削除 ボタン */
	private JButton ruleRemoveButton;

	/** リソース タイトル ラベル. */
	private JLabel resourceTitleLabel;

	/** リクエスト パネル. */
	private JPanel requestPanel;

	/** リクエスト タイトル ラベル. */
	private JLabel requestTitleLabel;

	/** GET リクエスト タイトル ラベル. */
	private JLabel getRequestTitleLabel;

	/** GET リクエスト コンボボックス. */
	private JComboBox getRequestComboBox;

	/** POST リクエスト タイトル ラベル. */
	private JLabel postRequestTitleLabel;

	/** POST リクエスト コンボボックス. */
	private JComboBox postRequestComboBox;

	/** リソース コンボボックス. */
	private JComboBox resourceComboBox;

	/** ルール追加ボタン. */
	private JButton ruleAddButton;

	/** ルール一覧テーブル パネル. */
	private JPanel ruleListTablePanel;

	/** ルール一覧テーブル タイトルラベル. */
	private JLabel ruleListTableTitleLabel;

	/** ルール一覧テーブル JScrollPane. */
	private JScrollPane ruleListTableScrollPane;

	/** ルール一覧テーブル. */
	private JTable ruleListTable;

	/** ルール修正 パネル. */
	private JPanel ruleModifyPanel;

	/** ルール修正テーブル パネル. */
	private JPanel ruleModifyTablePanel;

	/** ルール修正テーブル タイトルラベル. */
	private JLabel ruleModifyTableTitleLabel;

	/** ルール修正テーブル JScrollPane. */
	private JScrollPane ruleModifyTableScrollPane;

	/** ルール修正テーブル. */
	private JTable ruleModifyTable;

	/** グループパネル. */
	private JPanel groupPanel;

	/** グループタイトル ラベル. */
	private JLabel groupTitleLabel;

	/** グループ JScrollPane. */
	private JScrollPane groupScrollPane;

	/** グループテーブル. */
	private JTable groupTable;

	/** 動作ボタンのパネル. */
	private JPanel actionButtonsPanel;

	/** OK ボタン. */
	private JButton okButton;

	/** キャンセルボタン. */
	private JButton cancelButton;

	/** グループテーブルの Group を持つ列. ユーザーに対しては表示されていない. */
	private TableColumn groupModelColumn;
	
	/** ポリシーの追加/更新のいずれを行うかを示す値. */
	private PolicySetMode mode;
	
	/** 追加/更新対象のポリシー. */
	private Policy targetPolicy;

	/**
	 * コンテンツの初期化を行います.
	 */
	public void init() {
		setTitle(messages.getMessage("view.policySet.title"));
		setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
		setMinimumSize(new Dimension(800, 600));
		setLocationRelativeTo(null);
		GridBagLayout gridBagLayout = new GridBagLayout();
		gridBagLayout.columnWidths = new int[] { 792, 0 };
		gridBagLayout.rowHeights = new int[] { 0, 0 };
		gridBagLayout.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
		gridBagLayout.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
		getContentPane().setLayout(gridBagLayout);

		mainPanel = new JPanel();
		GridBagConstraints gbc_PolicySetRule = new GridBagConstraints();
		gbc_PolicySetRule.insets = new Insets(5, 5, 5, 5);
		gbc_PolicySetRule.weighty = 1.0;
		gbc_PolicySetRule.weightx = 1.0;
		gbc_PolicySetRule.fill = GridBagConstraints.BOTH;
		gbc_PolicySetRule.gridx = 0;
		gbc_PolicySetRule.gridy = 0;
		getContentPane().add(mainPanel, gbc_PolicySetRule);
		GridBagLayout gbl_PolicySetRule = new GridBagLayout();
		gbl_PolicySetRule.columnWidths = new int[] { 800, 0 };
		gbl_PolicySetRule.rowHeights = new int[] { 0, 0, 0 };
		gbl_PolicySetRule.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
		gbl_PolicySetRule.rowWeights = new double[] { 0.0, 0.0, 0.0 };
		mainPanel.setLayout(gbl_PolicySetRule);

		titlePanel = new JPanel();
		GridBagConstraints gbc_PolicySetTitle = new GridBagConstraints();
		gbc_PolicySetTitle.insets = new Insets(0, 0, 5, 0);
		gbc_PolicySetTitle.weightx = 1.0;
		gbc_PolicySetTitle.fill = GridBagConstraints.BOTH;
		gbc_PolicySetTitle.gridx = 0;
		gbc_PolicySetTitle.gridy = 0;
		mainPanel.add(titlePanel, gbc_PolicySetTitle);

		titleRealmTitleLabel = new JLabel(
				messages.getMessage("view.policySet.realmTitle"));
		titlePanel.add(titleRealmTitleLabel);

		titleRealmComboBox = new JComboBox();
		titleRealmComboBox.setModel(new DefaultComboBoxModel(new Object[] {}));
		titleRealmComboBox.addItemListener(new ItemListener() {
			@Override
			public void itemStateChanged(ItemEvent e) {
				RealmComboBoxItem selectedItem = (RealmComboBoxItem) e
						.getItem();
				wrapSetGroupTable(selectedItem);
				wrapSetResourceComboBox(selectedItem);
				clearRule();
			}
		});
		titlePanel.add(titleRealmComboBox);

		titleRealmNameLabel = new JLabel();
		titleRealmNameLabel.setVisible(false);
		titlePanel.add(titleRealmNameLabel);

		titleRealmDummyLabel = new JLabel();
		titleRealmDummyLabel.setVisible(false);
		titleRealmDummyLabel.setPreferredSize(new Dimension(9, 10));
		titlePanel.add(titleRealmDummyLabel);

		titlePolicyTitleLabel = new JLabel(
				messages.getMessage("view.policySet.policyTitle"));
		titlePanel.add(titlePolicyTitleLabel);

		titlePolicyTextField = new JTextField();
		titlePolicyTextField.setText("");
		titlePolicyTextField.setColumns(10);
		titlePanel.add(titlePolicyTextField);

		titlePolicyNameLabel = new JLabel();
		titlePolicyNameLabel.setVisible(false);
		titlePanel.add(titlePolicyNameLabel);

		ruleTabbedPane = new JTabbedPane(JTabbedPane.TOP);
		ruleTabbedPane.setToolTipText("");
		ruleTabbedPane
				.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
		ruleTabbedPane.setBorder(null);
		GridBagConstraints gbc_RuleTab = new GridBagConstraints();
		gbc_RuleTab.insets = new Insets(0, 0, 5, 0);
		gbc_RuleTab.weightx = 1.0;
		gbc_RuleTab.weighty = 1.0;
		gbc_RuleTab.fill = GridBagConstraints.BOTH;
		gbc_RuleTab.gridx = 0;
		gbc_RuleTab.gridy = 1;
		mainPanel.add(ruleTabbedPane, gbc_RuleTab);

		ruleListPanel = new JPanel();
		ruleTabbedPane.addTab(
				messages.getMessage("view.policySet.policyListTab.title"),
				null, ruleListPanel, null);
		GridBagLayout gbl_RuleListTab = new GridBagLayout();
		gbl_RuleListTab.columnWidths = new int[] { 0, 0 };
		gbl_RuleListTab.rowHeights = new int[] { 0, 0, 0 };
		gbl_RuleListTab.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
		gbl_RuleListTab.rowWeights = new double[] { 0.0, 0.0, Double.MIN_VALUE };
		ruleListPanel.setLayout(gbl_RuleListTab);

		ruleListTitlePanel = new JPanel();
		GridBagConstraints gbc_RuleListTitlePanel = new GridBagConstraints();
		gbc_RuleListTitlePanel.ipadx = 90;
		gbc_RuleListTitlePanel.insets = new Insets(5, 0, 0, 0);
		gbc_RuleListTitlePanel.weightx = 1.0;
		gbc_RuleListTitlePanel.fill = GridBagConstraints.HORIZONTAL;
		gbc_RuleListTitlePanel.gridx = 0;
		gbc_RuleListTitlePanel.gridy = 0;
		ruleListPanel.add(ruleListTitlePanel, gbc_RuleListTitlePanel);
		GridBagLayout gbl_ruleListTitlePanel = new GridBagLayout();
		gbl_ruleListTitlePanel.columnWidths = new int[] { 598, 0, 0 };
		gbl_ruleListTitlePanel.rowHeights = new int[] { 47, 0 };
		gbl_ruleListTitlePanel.columnWeights = new double[] { 0.0, 0.0,
				Double.MIN_VALUE };
		gbl_ruleListTitlePanel.rowWeights = new double[] { 0.0,
				Double.MIN_VALUE };
		ruleListTitlePanel.setLayout(gbl_ruleListTitlePanel);

		ruleAddPanel = new JPanel();
		ruleAddPanel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null,
				null));
		GridBagConstraints gbc_ruleAddPanel = new GridBagConstraints();
		gbc_ruleAddPanel.fill = GridBagConstraints.HORIZONTAL;
		gbc_ruleAddPanel.weightx = 1.0;
		gbc_ruleAddPanel.insets = new Insets(0, 0, 0, 5);
		gbc_ruleAddPanel.gridx = 0;
		gbc_ruleAddPanel.gridy = 0;
		ruleListTitlePanel.add(ruleAddPanel, gbc_ruleAddPanel);

		ruleRemoveButton = new JButton(
				messages.getMessage("view.policySet.policyListTab.removeButton"));
		ruleRemoveButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				removeRule();
			}
		});
		GridBagConstraints gbc_ruleRemoveButton = new GridBagConstraints();
		gbc_ruleRemoveButton.insets = new Insets(0, 0, 0, 5);
		gbc_ruleRemoveButton.gridx = 1;
		gbc_ruleRemoveButton.gridy = 0;
		ruleListTitlePanel.add(ruleRemoveButton, gbc_ruleRemoveButton);
		GridBagLayout gbl_ruleAddPanel = new GridBagLayout();
		gbl_ruleAddPanel.columnWidths = new int[] { 36, 0, 0, 0, 0 };
		gbl_ruleAddPanel.rowHeights = new int[] { 33, 0 };
		gbl_ruleAddPanel.columnWeights = new double[] { 0.0, 0.0, 0.0, 0.0,
				Double.MIN_VALUE };
		gbl_ruleAddPanel.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
		ruleAddPanel.setLayout(gbl_ruleAddPanel);

		resourceTitleLabel = new JLabel(
				messages.getMessage("view.policySet.resourceTitle"));
		GridBagConstraints gbc_resourceTitleLabel = new GridBagConstraints();
		gbc_resourceTitleLabel.anchor = GridBagConstraints.WEST;
		gbc_resourceTitleLabel.insets = new Insets(0, 0, 0, 5);
		gbc_resourceTitleLabel.gridx = 0;
		gbc_resourceTitleLabel.gridy = 0;
		ruleAddPanel.add(resourceTitleLabel, gbc_resourceTitleLabel);

		resourceComboBox = new JComboBox();
		resourceComboBox.setPreferredSize(new Dimension(200, 30));
		resourceComboBox.setModel(new DefaultComboBoxModel(new Object[] {}));

		resourceComboBox.setEditable(true);

		JTextField resourceComboBoxTextEditor = (JTextField) resourceComboBox
				.getEditor().getEditorComponent();
		Document document = resourceComboBoxTextEditor.getDocument();
		document.addDocumentListener(new AutoCompleteDocumentListener(
				resourceComboBox));

		GridBagConstraints gbc_resourceComboBox = new GridBagConstraints();
		gbc_resourceComboBox.weightx = 1.0;
		gbc_resourceComboBox.fill = GridBagConstraints.HORIZONTAL;
		gbc_resourceComboBox.insets = new Insets(0, 0, 0, 5);
		gbc_resourceComboBox.gridx = 1;
		gbc_resourceComboBox.gridy = 0;
		ruleAddPanel.add(resourceComboBox, gbc_resourceComboBox);

		requestPanel = new JPanel();
		requestPanel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null,
				null));
		GridBagConstraints gbc_requestPanel = new GridBagConstraints();
		gbc_requestPanel.insets = new Insets(0, 0, 0, 5);
		gbc_requestPanel.gridx = 2;
		gbc_requestPanel.gridy = 0;
		ruleAddPanel.add(requestPanel, gbc_requestPanel);

		requestTitleLabel = new JLabel();
		requestTitleLabel.setText(messages
				.getMessage("view.policySet.policyListTab.methodTitle"));
		requestPanel.add(requestTitleLabel);

		getRequestTitleLabel = new JLabel();
		getRequestTitleLabel.setText(messages
				.getMessage("view.policySet.policyListTab.getTitle"));
		requestPanel.add(getRequestTitleLabel);

		getRequestComboBox = new JComboBox();
		getRequestComboBox
				.setModel(new DefaultComboBoxModel(
						new PermitComboBoxItem[] {
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.NONE,
										messages.getMessage("view.policySet.permitComboBox.none")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.ALLOW,
										messages.getMessage("view.policySet.permitComboBox.allow")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.DENY,
										messages.getMessage("view.policySet.permitComboBox.deny")) }));
		requestPanel.add(getRequestComboBox);

		postRequestTitleLabel = new JLabel();
		postRequestTitleLabel.setText(messages
				.getMessage("view.policySet.policyListTab.postTitle"));
		requestPanel.add(postRequestTitleLabel);

		postRequestComboBox = new JComboBox();
		postRequestComboBox
				.setModel(new DefaultComboBoxModel(
						new PermitComboBoxItem[] {
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.NONE,
										messages.getMessage("view.policySet.permitComboBox.none")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.ALLOW,
										messages.getMessage("view.policySet.permitComboBox.allow")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.DENY,
										messages.getMessage("view.policySet.permitComboBox.deny")) }));
		requestPanel.add(postRequestComboBox);

		ruleAddButton = new JButton(
				messages.getMessage("view.policySet.policyListTab.addButton"));
		ruleAddButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				addRule();
			}
		});
		GridBagConstraints gbc_ruleAddButton = new GridBagConstraints();
		gbc_ruleAddButton.insets = new Insets(0, 0, 0, 5);
		gbc_ruleAddButton.gridx = 3;
		gbc_ruleAddButton.gridy = 0;
		ruleAddPanel.add(ruleAddButton, gbc_ruleAddButton);

		ruleListTablePanel = new JPanel();
		GridBagConstraints gbc_RuleSelect = new GridBagConstraints();
		gbc_RuleSelect.weightx = 1.0;
		gbc_RuleSelect.weighty = 1.0;
		gbc_RuleSelect.fill = GridBagConstraints.BOTH;
		gbc_RuleSelect.gridx = 0;
		gbc_RuleSelect.gridy = 1;
		ruleListPanel.add(ruleListTablePanel, gbc_RuleSelect);
		GridBagLayout gbl_RuleSelect = new GridBagLayout();
		gbl_RuleSelect.columnWidths = new int[] { 771, 0 };
		gbl_RuleSelect.rowHeights = new int[] { 0, 0, 0 };
		gbl_RuleSelect.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
		gbl_RuleSelect.rowWeights = new double[] { 0.0, 0.0, Double.MIN_VALUE };
		ruleListTablePanel.setLayout(gbl_RuleSelect);

		ruleListTableTitleLabel = new JLabel(
				messages.getMessage("view.policySet.policyListTab.tableTitle"));
		ruleListTableTitleLabel.setHorizontalAlignment(SwingConstants.CENTER);
		GridBagConstraints gbc_label_1 = new GridBagConstraints();
		gbc_label_1.fill = GridBagConstraints.VERTICAL;
		gbc_label_1.gridx = 0;
		gbc_label_1.gridy = 0;
		ruleListTablePanel.add(ruleListTableTitleLabel, gbc_label_1);

		ruleListTableScrollPane = new JScrollPane();
		GridBagConstraints gbc_RuleSelList = new GridBagConstraints();
		gbc_RuleSelList.weightx = 1.0;
		gbc_RuleSelList.weighty = 1.0;
		gbc_RuleSelList.fill = GridBagConstraints.BOTH;
		gbc_RuleSelList.gridx = 0;
		gbc_RuleSelList.gridy = 1;
		ruleListTablePanel.add(ruleListTableScrollPane, gbc_RuleSelList);
		ruleListTableScrollPane.setAutoscrolls(true);

		ruleListTable = new JTable();
		ruleListTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		ruleListTable.setBorder(new LineBorder(new Color(0, 0, 0)));
		ruleListTable
				.setModel(new DefaultTableModel(
						new Object[][] {},
						new String[] {
								messages.getMessage("view.policySet.policyTab.listTitle.resource"),
								messages.getMessage("view.policySet.policyTab.listTitle.get"),
								messages.getMessage("view.policySet.policyTab.listTitle.post"), }) {
					/** シリアルバージョン番号. */
					private static final long serialVersionUID = 1L;

					@Override
					public boolean isCellEditable(int row, int column) {
						return false;
					}
				});

		ruleListTable.getTableHeader().setReorderingAllowed(false);
		ruleListTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

		ruleListTableScrollPane.setViewportView(ruleListTable);

		ruleModifyPanel = new JPanel();
		ruleTabbedPane.addTab(
				messages.getMessage("view.policySet.policyModTab.title"), null,
				ruleModifyPanel, null);
		GridBagLayout gbl_RuleModTab = new GridBagLayout();
		gbl_RuleModTab.columnWidths = new int[] { 771, 0 };
		gbl_RuleModTab.rowHeights = new int[] { 0, 0 };
		gbl_RuleModTab.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
		gbl_RuleModTab.rowWeights = new double[] { 0.0, Double.MIN_VALUE };
		ruleModifyPanel.setLayout(gbl_RuleModTab);

		ruleModifyTablePanel = new JPanel();
		GridBagConstraints gbc_RuleMod = new GridBagConstraints();
		gbc_RuleMod.weighty = 1.0;
		gbc_RuleMod.weightx = 1.0;
		gbc_RuleMod.fill = GridBagConstraints.BOTH;
		gbc_RuleMod.gridx = 0;
		gbc_RuleMod.gridy = 0;
		ruleModifyPanel.add(ruleModifyTablePanel, gbc_RuleMod);
		GridBagLayout gbl_RuleMod = new GridBagLayout();
		gbl_RuleMod.columnWidths = new int[] { 777, 0 };
		gbl_RuleMod.rowHeights = new int[] { 0, 0, 0 };
		gbl_RuleMod.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
		gbl_RuleMod.rowWeights = new double[] { 0.0, 0.0, Double.MIN_VALUE };
		ruleModifyTablePanel.setLayout(gbl_RuleMod);

		ruleModifyTableTitleLabel = new JLabel();
		ruleModifyTableTitleLabel.setText(messages
				.getMessage("view.policySet.policyModTab.tableTitle"));
		GridBagConstraints gbc_ruleModLabel = new GridBagConstraints();
		gbc_ruleModLabel.weightx = 1.0;
		gbc_ruleModLabel.fill = GridBagConstraints.VERTICAL;
		gbc_ruleModLabel.insets = new Insets(0, 0, 5, 0);
		gbc_ruleModLabel.gridx = 0;
		gbc_ruleModLabel.gridy = 0;
		ruleModifyTablePanel.add(ruleModifyTableTitleLabel, gbc_ruleModLabel);

		ruleModifyTableScrollPane = new JScrollPane();
		GridBagConstraints gbc_RuleModList = new GridBagConstraints();
		gbc_RuleModList.weighty = 1.0;
		gbc_RuleModList.weightx = 1.0;
		gbc_RuleModList.insets = new Insets(0, 0, 5, 0);
		gbc_RuleModList.fill = GridBagConstraints.BOTH;
		gbc_RuleModList.gridx = 0;
		gbc_RuleModList.gridy = 1;
		ruleModifyTablePanel.add(ruleModifyTableScrollPane, gbc_RuleModList);

		ruleModifyTable = new JTable();
		ruleModifyTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		ruleModifyTable.setBorder(new LineBorder(new Color(0, 0, 0)));
		ruleModifyTable
				.setModel(new DefaultTableModel(
						new Object[][] {},
						new String[] {
								messages.getMessage("view.policySet.policyTab.listTitle.resource"),
								messages.getMessage("view.policySet.policyTab.listTitle.get"),
								messages.getMessage("view.policySet.policyTab.listTitle.post") }));
		ruleModifyTable.putClientProperty("terminateEditOnFocusLost", true);
		
		TableColumnModel ruleModTableColumnModel = ruleModifyTable
				.getColumnModel();
		ruleModifyTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		ruleModifyTable.setRowHeight(20);
		ruleModifyTable.getTableHeader().setReorderingAllowed(false);

		ruleModifyTableScrollPane.setViewportView(ruleModifyTable);
		TableColumn ruleModTableGetColumn = ruleModTableColumnModel
				.getColumn(1);
		ruleModTableGetColumn
				.setCellRenderer(new ComboBoxTableCellRenderer(
						new Object[] {
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.NONE,
										messages.getMessage("view.policySet.permitComboBox.none")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.ALLOW,
										messages.getMessage("view.policySet.permitComboBox.allow")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.DENY,
										messages.getMessage("view.policySet.permitComboBox.deny")), }));
		ruleModTableGetColumn
				.setCellEditor(new ComboBoxTableCellEditor(
						new Object[] {
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.NONE,
										messages.getMessage("view.policySet.permitComboBox.none")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.ALLOW,
										messages.getMessage("view.policySet.permitComboBox.allow")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.DENY,
										messages.getMessage("view.policySet.permitComboBox.deny")), }));
		int ruleModTableGetColumnWidth = ((ComboBoxTableCellEditor) ruleModTableGetColumn
				.getCellEditor()).getAutoCellWidth();
		ruleModTableGetColumn.setPreferredWidth(ruleModTableGetColumnWidth);

		TableColumn ruleModTablePostColumn = ruleModTableColumnModel
				.getColumn(2);
		ruleModTablePostColumn
				.setCellRenderer(new ComboBoxTableCellRenderer(
						new Object[] {
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.NONE,
										messages.getMessage("view.policySet.permitComboBox.none")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.ALLOW,
										messages.getMessage("view.policySet.permitComboBox.allow")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.DENY,
										messages.getMessage("view.policySet.permitComboBox.deny")), }));
		ruleModTablePostColumn
				.setCellEditor(new ComboBoxTableCellEditor(
						new Object[] {
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.NONE,
										messages.getMessage("view.policySet.permitComboBox.none")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.ALLOW,
										messages.getMessage("view.policySet.permitComboBox.allow")),
								new PermitComboBoxItem(
										PermitComboBoxItem.Type.DENY,
										messages.getMessage("view.policySet.permitComboBox.deny")), }));
		int ruleModTablePostColumnWidth = ((ComboBoxTableCellEditor) ruleModTablePostColumn
				.getCellEditor()).getAutoCellWidth();
		ruleModTablePostColumn.setPreferredWidth(ruleModTablePostColumnWidth);

		// 変更時の動作設定
		ruleModifyTable.getModel().addTableModelListener(
				new TableModelListener() {
					@Override
					public void tableChanged(TableModelEvent e) {
						onEdited();
					}
				});

		groupPanel = new JPanel();
		GridBagConstraints gbc_PolicySetGroup = new GridBagConstraints();
		gbc_PolicySetGroup.weightx = 1.0;
		gbc_PolicySetGroup.fill = GridBagConstraints.BOTH;
		gbc_PolicySetGroup.gridx = 0;
		gbc_PolicySetGroup.gridy = 2;
		mainPanel.add(groupPanel, gbc_PolicySetGroup);
		GridBagLayout gbl_PolicySetGroup = new GridBagLayout();
		gbl_PolicySetGroup.columnWidths = new int[] { 0, 0 };
		gbl_PolicySetGroup.rowHeights = new int[] { 0, 0, 0, 0 };
		gbl_PolicySetGroup.columnWeights = new double[] { 0.0, Double.MIN_VALUE };
		gbl_PolicySetGroup.rowWeights = new double[] { 0.0, 0.0, 0.0,
				Double.MIN_VALUE };
		groupPanel.setLayout(gbl_PolicySetGroup);

		groupTitleLabel = new JLabel(
				messages.getMessage("view.policySet.groupTableTitle"));
		GridBagConstraints gbc_label = new GridBagConstraints();
		gbc_label.insets = new Insets(0, 0, 5, 0);
		gbc_label.anchor = GridBagConstraints.CENTER;
		gbc_label.weightx = 1.0;
		gbc_label.fill = GridBagConstraints.BOTH;
		gbc_label.gridx = 0;
		gbc_label.gridy = 0;
		groupPanel.add(groupTitleLabel, gbc_label);
		groupTitleLabel.setHorizontalAlignment(SwingConstants.CENTER);

		groupScrollPane = new JScrollPane();
		groupScrollPane.setMinimumSize(new Dimension(2, 150));
		groupScrollPane.setBorder(new BevelBorder(BevelBorder.LOWERED, null,
				null, null, null));
		groupScrollPane.setAutoscrolls(true);
		GridBagConstraints gbc_GroupList = new GridBagConstraints();
		gbc_GroupList.insets = new Insets(0, 0, 5, 0);
		gbc_GroupList.weighty = 1.0;
		gbc_GroupList.weightx = 1.0;
		gbc_GroupList.fill = GridBagConstraints.BOTH;
		gbc_GroupList.gridx = 0;
		gbc_GroupList.gridy = 1;
		groupPanel.add(groupScrollPane, gbc_GroupList);

		groupTable = new JTable();
		groupTable.setRowHeight(18);
		groupTable
				.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		groupTable
				.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		groupTable.setPreferredScrollableViewportSize(new Dimension(450, 100));
		groupTable
				.setModel(new DefaultTableModel(
						new Object[][] {},
						new String[] {
								"",
								messages.getMessage("view.policySet.groupTab.groupTitle"),
								"" }) {
					/** シリアルバージョン番号. */
					private static final long serialVersionUID = 1L;

					@Override
					public Class<?> getColumnClass(int column) {
						Object value = getValueAt(0, column);
						if (value == null) {
							return String.class;
						} else {
							return value.getClass();
						}
					}

					@Override
					public boolean isCellEditable(int row, int col) {
						switch (col) {
						case 0:
							return true;
						default:
							return false;
						}
					}
				});
		groupTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		groupTable.getTableHeader().setReorderingAllowed(false);

		TableColumnModel groupTableColumnModel = groupTable.getColumnModel();
		groupModelColumn = groupTableColumnModel.getColumn(2);
		groupTable.removeColumn(groupModelColumn);

		groupScrollPane.setViewportView(groupTable);

		actionButtonsPanel = new JPanel();
		GridBagConstraints gbc_PolicyAction = new GridBagConstraints();
		gbc_PolicyAction.weighty = 1.0;
		gbc_PolicyAction.fill = GridBagConstraints.HORIZONTAL;
		gbc_PolicyAction.gridx = 0;
		gbc_PolicyAction.gridy = 2;
		groupPanel.add(actionButtonsPanel, gbc_PolicyAction);

		okButton = new JButton(
				messages.getMessage("view.policySet.groupTab.okButton"));
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ok();
			}
		});
		okButton.setPreferredSize(new Dimension(120, 32));

		actionButtonsPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
		// okButton.setActionCommand("");
		actionButtonsPanel.add(okButton);

		cancelButton = new JButton(
				messages.getMessage("view.policySet.groupTab.cancelButton"));
		cancelButton.setPreferredSize(new Dimension(120, 32));
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancel();
			}
		});
		actionButtonsPanel.add(cancelButton);
	}

	/**
	 * 新しい PolicySetView を構築します.
	 * 
	 * @param mes
	 *            MessageSourceAccessor.
	 */
	private PolicySetView(MessageSourceAccessor mes) {
		messages = mes;
		init();
	}

	private void setVisibles() {
		boolean b;
		if (mode == PolicySetMode.ADD) {
			b = true;
		} else {
			b = false;
		}

		titleRealmComboBox.setVisible(b);
		titleRealmNameLabel.setVisible(!b);
		titleRealmDummyLabel.setVisible(!b);

		titlePolicyTextField.setVisible(b);
		titlePolicyNameLabel.setVisible(!b);
	}

	private void initViews() {
		setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
		
		titlePolicyTextField.setText("");

		((DefaultTableModel) ruleListTable.getModel()).setRowCount(0);
		((DefaultTableModel) ruleModifyTable.getModel()).setRowCount(0);
		((DefaultTableModel) groupTable.getModel()).setRowCount(0);
		
		ruleTabbedPane.setSelectedIndex(0);
	}

	/**
	 * この画面に指定されたデータを使用して, 各コンポーネントの表示項目を更新します.
	 */
	public void initData(Policy policy) {

		result = false;
		mode = PolicySetMode.MODIFY;
		Realm realm = service.findRealmByName(policy.getRealmName());
		this.targetPolicy = policy;
		initViews();

		titleRealmNameLabel.setText(realm.getRealmName());
		titlePolicyNameLabel.setText(policy.getPolicyName());

		setResourceComboBox(realm);
		setResourceTable(policy);

		List<Subject> subjects = policy.getSubjects();
		Set<String> groups = new HashSet<String>();
		for (Subject subject : subjects) {
			groups.add(subject.getSubjectName());
		}
		setGroupTable(realm, groups);

		setVisibles();
	}

	/**
	 * この画面に指定されたデータを使用して, 各コンポーネントの表示項目を更新します.
	 */
	public void initData() {

		result = false;
		mode = PolicySetMode.ADD;
		this.targetPolicy = null;
		initViews();

		setRealmComboBox();
		setVisibles();
	}

	/**
	 * 画面の結果を取得します.<br>
	 * 具体的には, 閉じる前に追加/更新が行われたかを示す値を取得します.
	 * 
	 * @return 閉じる前に追加/更新が行われた場合は true, そうでない場合は false.
	 * 
	 */
	public boolean getResult() {
		return result;
	}

	/**
	 * OKボタンを押したときの処理です.
	 * 
	 */
	private void ok() {

		Policy policy;

		if (mode == PolicySetMode.ADD) {
			Realm realm = ((RealmComboBoxItem) titleRealmComboBox
					.getSelectedItem()).getRealmModel();
			if (realm == null) {
				JOptionPane.showMessageDialog(this,
						messages.getMessage("view.policySet.noRealmSelected"));
				return;
			}

			String policyName = titlePolicyTextField.getText().trim();
			if (policyName.isEmpty()) {
				JOptionPane.showMessageDialog(this,
						messages.getMessage("view.policySet.noPolicyName"));
				return;
			}
			policy = new Policy(realm.getRealmName(), policyName);
		} else {
			policy = this.targetPolicy;
			policy.getResources().clear();
			policy.getSubjects().clear();
		}

		if (ruleListTable.getRowCount() == 0) {
			JOptionPane.showMessageDialog(this,
					messages.getMessage("view.policySet.noRule"));
			return;
		}

		for (int i = 0; i < ruleModifyTable.getRowCount(); i++) {
			Resource resource = new Resource(
					(String) ruleListTable.getValueAt(i, 0),
					PolicySetViewPermitUtil
							.getPermitByPermitComboBoxItem((PermitComboBoxItem) ruleModifyTable
									.getValueAt(i, 1)),
					PolicySetViewPermitUtil
							.getPermitByPermitComboBoxItem((PermitComboBoxItem) ruleModifyTable
									.getValueAt(i, 2)));
			resource.setPolicy(policy);
			policy.addResource(resource);
		}

		groupTable.addColumn(groupModelColumn);

		for (int i = 0; i < groupTable.getRowCount(); i++) {
			if ((Boolean) groupTable.getValueAt(i, 0)) {
				Group group = (Group) groupTable.getValueAt(i, 2);
				Subject subject = new Subject(group.getGroupName(),
						group.getGroupCode());
				subject.setPolicy(policy);
				policy.addSubject(subject);
			}
		}

		groupTable.removeColumn(groupModelColumn);

		if (policy.getSubjects().size() == 0) {
			JOptionPane.showMessageDialog(this,
					messages.getMessage("view.policySet.noGroupSelected"));
			return;
		}

		ConstraintViolation<?> violation;
		try {
			if (mode == PolicySetMode.ADD) {
				violation = service.addPolicy(policy);
			} else {
				violation = service.modifyPolicy(policy);
			}
		} catch (OpenAMAccessException e) {
			JOptionPane.showMessageDialog(this, e.getMessage());
			return;
		}

		if (violation != null) {
			JOptionPane.showMessageDialog(this, violation.getMessage());
			return;
		}

		result = true;
		setVisible(false);
	}

	/**
	 * キャンセルボタンを押したときの処理です.
	 * 
	 */
	private void cancel() {
		result = false;
		setVisible(false);
	}

	/**
	 * 一覧タブで追加ボタンを押したときの処理です.
	 * 
	 */
	private void addRule() {

		// 入力リソース名が空の場合, 打ち切り.
		String inputResourceUrl = ((String) resourceComboBox.getSelectedItem())
				.trim();
		if (inputResourceUrl.isEmpty()) {
			JOptionPane.showMessageDialog(this,
					messages.getMessage("view.policySet.noResourceUrl"));
			return;
		}

		// GET, POST が選択されていない場合, 打ち切り.
		if (getRequestComboBox.getSelectedIndex() == -1
				|| postRequestComboBox.getSelectedIndex() == -1) {
			JOptionPane.showMessageDialog(this,
					messages.getMessage("view.policySet.noSelectPermit"));
			return;
		}

		// リソース名が既に存在しているものの場合, 打ち切り.
		for (int i = 0; i < ruleListTable.getRowCount(); i++) {
			String registeredResourceUrl = (String) ruleListTable.getValueAt(i,
					0);
			if (inputResourceUrl.equals(registeredResourceUrl)) {
				JOptionPane.showMessageDialog(this, messages.getMessage(
						"view.policySet.alreadyRegisterdUrl",
						new Object[] { inputResourceUrl }));
				return;
			}
		}

		// ルール修正テーブルに追加
		DefaultTableModel ruleModTableModel = (DefaultTableModel) ruleModifyTable
				.getModel();
		PermitComboBoxItem getItem = (PermitComboBoxItem) getRequestComboBox
				.getSelectedItem();
		PermitComboBoxItem postItem = (PermitComboBoxItem) postRequestComboBox
				.getSelectedItem();
		Object[] ruleModRowData = new Object[] { inputResourceUrl, getItem,
				postItem };
		ruleModTableModel.addRow(ruleModRowData);
	}

	/**
	 * 一覧タブで削除ボタンを押したときの処理です.
	 * 
	 */
	private void removeRule() {
		// ルールが選択されていない場合は, 打ち切り.
		int selectedRow = ruleListTable.getSelectedRow();
		if (selectedRow == -1) {
			JOptionPane.showMessageDialog(this,
					messages.getMessage("view.policySet.noSelectRule"));
			return;
		}

		// ルール修正テーブルから削除
		DefaultTableModel ruleModTableModel = (DefaultTableModel) ruleModifyTable
				.getModel();
		ruleModTableModel.removeRow(selectedRow);
	}

	/**
	 * ルールをすべてクリアする.
	 */
	private void clearRule() {
		// ルール修正テーブルをクリア.
		DefaultTableModel ruleModTableModel = (DefaultTableModel) ruleModifyTable
				.getModel();
		ruleModTableModel.setRowCount(0);
	}
	
	/**
	 * 修正タブで編集を行ったときの処理です.
	 * 
	 */
	private void onEdited() {

		// 一覧, 修正のテーブルの行数が異なる場合, 行数変更
		ruleListTable.setVisible(false);
		if (ruleListTable.getRowCount() != ruleModifyTable.getRowCount()) {
			DefaultTableModel ruleSelTableModel = (DefaultTableModel) ruleListTable
					.getModel();
			ruleSelTableModel.setRowCount(ruleModifyTable.getRowCount());
		}

		List<String> resourceList = new ArrayList<String>();

		// 修正テーブルの表示データを, 一覧テーブルに設定
		for (int rowIndex = 0; rowIndex < ruleModifyTable.getRowCount(); rowIndex++) {
			String resourceUrl = (String) ruleModifyTable.getValueAt(rowIndex,
					0);
			PermitComboBoxItem getModItem = (PermitComboBoxItem) ruleModifyTable
					.getValueAt(rowIndex, 1);
			PermitComboBoxItem postModItem = (PermitComboBoxItem) ruleModifyTable
					.getValueAt(rowIndex, 2);

			ruleListTable.setValueAt(resourceUrl, rowIndex, 0);
			ruleListTable.setValueAt(getModItem.toString(), rowIndex, 1);
			ruleListTable.setValueAt(postModItem.toString(), rowIndex, 2);
			resourceList.add(resourceUrl);
		}

		// 修正テーブルの列幅自動計算
		JTableColumnWidthCalculator ruleModifyTableCalculator = new JTableColumnWidthCalculator(
				ruleModifyTable);
		ruleModifyTableCalculator.setAutomatically(0, resourceList);
		for (int columnIndex = 1; columnIndex < ruleModifyTable
				.getColumnCount(); columnIndex++) {
			ruleModifyTableCalculator.setAutomatically(columnIndex);
		}
		
		// 一覧テーブルの列幅自動計算
		JTableColumnWidthCalculator ruleListTableCalculator = new JTableColumnWidthCalculator(
				ruleListTable);
		ruleListTableCalculator.setAutomatically(0, resourceList);
		for (int columnIndex = 1; columnIndex < ruleListTable.getColumnCount(); columnIndex++) {
			ruleListTableCalculator.setAutomatically(columnIndex);
		}
		ruleListTable.setVisible(true);
	}

	private void setRealmComboBox() {

		titleRealmComboBox.setVisible(false);
		titleRealmComboBox.removeAllItems();

		titleRealmComboBox.addItem(RealmComboBoxItem.ALL_REALM);
		for (Realm realm : service.findRealms()) {
			titleRealmComboBox.addItem(new RealmComboBoxItem(realm
					.getRealmName(), realm));
		}
		titleRealmComboBox.setSelectedItem(RealmComboBoxItem.ALL_REALM);
		titleRealmComboBox.setVisible(true);
	}

	private void wrapSetResourceComboBox(RealmComboBoxItem realmItem) {
		setResourceComboBox(realmItem.getRealmModel());
	}

	private void setResourceComboBox(Realm realm) {

		resourceComboBox.setVisible(false);

		resourceComboBox.removeAllItems();
		resourceComboBox.addItem("");

		getRequestComboBox.setSelectedIndex(0);
		postRequestComboBox.setSelectedIndex(0);

		if (realm == null) {
			resourceComboBox.setVisible(true);
			return;
		}

		List<Referral> referrals = service.findReferrals(realm);
		for (Referral referral : referrals) {
			resourceComboBox.addItem(referral.getRefpolicy());
		}
		resourceComboBox.setVisible(true);
	}

	private void setResourceTable(Policy policy) {
		ruleModifyTable.setVisible(false);

		DefaultTableModel ruleModifyTableModel = (DefaultTableModel) ruleModifyTable
				.getModel();
		ruleModifyTableModel.setRowCount(0);
		List<String> resourceList = new ArrayList<String>();

		List<Resource> resources = policy.getResources();
		for (Resource resource : resources) {
			PermitComboBoxItem getPermitItem = PolicySetViewPermitUtil
					.getComboBoxItemByPermit(resource.getGetPermit());
			PermitComboBoxItem postPermitItem = PolicySetViewPermitUtil
					.getComboBoxItemByPermit(resource.getPostPermit());
			ruleModifyTableModel.addRow(new Object[] {
					resource.getResourceUrl(), getPermitItem, postPermitItem });
			resourceList.add(resource.getResourceUrl());
		}

		ruleModifyTable.setVisible(true);
	}

	private void wrapSetGroupTable(RealmComboBoxItem realmItem) {
		setGroupTable(realmItem.getRealmModel(), new HashSet<String>());
	}

	private void setGroupTable(Realm realm, Set<String> groupNames) {

		groupTable.setVisible(false);
		DefaultTableModel groupTableModel = (DefaultTableModel) groupTable
				.getModel();
		groupTableModel.setRowCount(0);

		if (realm == null) {
			groupTable.setVisible(true);
			return;
		}

		groupTable.addColumn(groupModelColumn);

		List<Group> groups = service.findGroupByRealm(realm);
		List<String> groupStrings = new ArrayList<String>();
		for (Group group : groups) {
			boolean b = groupNames.contains(group.getGroupName());
			String groupString = group.getGroupName() + " ("
					+ group.getGroupCode() + ")";
			groupTableModel.addRow(new Object[] { b, groupString, group });
			groupStrings.add(groupString);
		}

		groupTable.removeColumn(groupModelColumn);

		JTableColumnWidthCalculator groupTableCalculator = new JTableColumnWidthCalculator(
				groupTable);
		groupTable.getColumnModel().getColumn(0)
				.setPreferredWidth(CHECK_BOX_TABLE_COLUMN_WIDTH);
		for (int columnIndex = 1; columnIndex < groupTable.getColumnCount(); columnIndex++) {
			groupTableCalculator.setAutomatically(columnIndex);
		}
		groupTable.setVisible(true);
	}
}
