package jp.co.ogis_ri.citk.policytool.view.policyset;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Permit;

/**
 * ポリシー設定画面の, Permit 関連のユーティリティクラス.
 */
class PolicySetViewPermitUtil {
	/** コンボボックス表示項目文字列 許可 */
	private static final String ALLOW_STRING = "許可";
	
	/** コンボボックス表示項目文字列 拒否 */
	private static final String DENY_STRING = "拒否";
	
	/** コンボボックス表示項目文字列 未定義の場合 */
	private static final String INDETERMINATE_STRING = "";
	
    /**
     * 新しい PolicySetViewPermitUtil を構築します.
     */
    private PolicySetViewPermitUtil() {
    }

    /**
     * Permit から, それに対応する PermitComboBoxItem を取得します.
     * 
     * @param permit Permit.
     * @return Permit に対応する PermitComboBoxItem.
     * 
     */
    static PermitComboBoxItem getComboBoxItemByPermit(Permit permit) {
        switch (permit) {
            case ALLOW:
                return new PermitComboBoxItem(PermitComboBoxItem.Type.ALLOW,
                		ALLOW_STRING);
            case DENY:
                return new PermitComboBoxItem(PermitComboBoxItem.Type.DENY,
                		DENY_STRING);
            case INDETERMINATE:
                return new PermitComboBoxItem(PermitComboBoxItem.Type.NONE,
                		INDETERMINATE_STRING);
            default:
                throw new IllegalArgumentException("指定された permit には対応していません.");
        }
    }

    /**
     * PermitComboBoxItem から, それに対応する Permit を取得します.
     * 
     * @param item PermitComboBoxItem.
     * @return PermitComboBoxItem に対応する Permit.
     * 
     */
    static Permit getPermitByPermitComboBoxItem(PermitComboBoxItem item) {
        switch (item.getType()) {
            case ALLOW:
                return Permit.ALLOW;
            case DENY:
                return Permit.DENY;
            case NONE:
                return Permit.INDETERMINATE;
            default:
                throw new IllegalArgumentException("指定された item には対応していません.");
        }
    }
}
