package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.fail;

import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Permit;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;

import org.junit.Test;

public class ExcelPolicyFactoryTest {
	@Test
	public void testCreateListOfQ() {
		List<String> values = new ArrayList<String>();
		values.add("realm");
		values.add("policy");
		values.add("resourceUrl");
		values.add("get");
		values.add("post");
		values.add("subject");
		
		ExcelPolicy excelPolicy = ExcelPolicyFactory.create(values);
		
		assertThat(excelPolicy.getRealmName(), is("realm"));
		assertThat(excelPolicy.getPolicyName(), is("policy"));
		assertThat(excelPolicy.getResourceUrl(), is("resourceUrl"));
		assertThat(excelPolicy.getGetPermitValue(), is("get"));
		assertThat(excelPolicy.getPostPermitValue(), is("post"));
		assertThat(excelPolicy.getSubject(), is("subject"));
	}

	@Test
	public void testCreateListOfQ_SystemException() {
		List<String> values = new ArrayList<String>();
		values.add("realm");
		values.add("policy");
		values.add("resourceUrl");
		values.add("get");
		values.add("post");
		
		try {
			ExcelPolicyFactory.create(values);
			fail();
		} catch (SystemException e) {
			assertThat(e.getMessage(), is("size error: 5"));
		}
	}
	
	@Test
	public void testCreatePolicy() {
		Policy policy1 = new Policy();
		policy1.setPolicyName("policy");
		policy1.setRealmName("realm");
		
		Resource resource11 = new Resource();
		resource11.setResourceURL("url1");
		resource11.setGetPermit(Permit.ALLOW);
		resource11.setPostPermit(Permit.DENY);
		policy1.getResources().add(resource11);
		Resource resource12 = new Resource();
		resource12.setResourceURL("url2");
		resource12.setGetPermit(Permit.INDETERMINATE);
		resource12.setPostPermit(Permit.ALLOW);
		policy1.getResources().add(resource12);
		
		Subject subject11 = new Subject();
		subject11.setSubjectName("g1");
		subject11.setSubjectCode("o=g1,a=12");
		policy1.getSubjects().add(subject11);
		
		List<ExcelPolicy> excelPolicyList = ExcelPolicyFactory.create(policy1);
		
		assertThat(excelPolicyList.size(), is(3));
		ExcelPolicy excelPolicy1 = excelPolicyList.get(0);
		assertThat(excelPolicy1.getRealmName(), is("realm"));
		assertThat(excelPolicy1.getPolicyName(), is("policy"));
		assertThat(excelPolicy1.getResourceUrl(), is("url1"));
		assertThat(excelPolicy1.getGetPermitValue(), is("ALLOW"));
		assertThat(excelPolicy1.getPostPermitValue(), is("DENY"));
		assertThat(excelPolicy1.getSubject(), is(nullValue()));
		
		ExcelPolicy excelPolicy2 = excelPolicyList.get(1);
		assertThat(excelPolicy2.getRealmName(), is("realm"));
		assertThat(excelPolicy2.getPolicyName(), is("policy"));
		assertThat(excelPolicy2.getResourceUrl(), is("url2"));
		assertThat(excelPolicy2.getGetPermitValue(), is("INDETERMINATE"));
		assertThat(excelPolicy2.getPostPermitValue(), is("ALLOW"));
		assertThat(excelPolicy2.getSubject(), is(nullValue()));
		
		ExcelPolicy excelPolicy3 = excelPolicyList.get(2);
		assertThat(excelPolicy3.getRealmName(), is("realm"));
		assertThat(excelPolicy3.getPolicyName(), is("policy"));
		assertThat(excelPolicy3.getResourceUrl(), is(nullValue()));
		assertThat(excelPolicy3.getGetPermitValue(), is(nullValue()));
		assertThat(excelPolicy3.getPostPermitValue(), is(nullValue()));
		assertThat(excelPolicy3.getSubject(), is("o=g1,a=12"));
	}

	@Test
	public void testCreatePolicy_Zero() {
		Policy policy1 = new Policy();
		policy1.setPolicyName("policy");
		policy1.setRealmName("realm");
		
		List<ExcelPolicy> excelPolicyList = ExcelPolicyFactory.create(policy1);
		
		assertThat(excelPolicyList.size(), is(0));
	}
}
