package jp.co.ogis_ri.citk.policytool.common.exception;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;

import mockit.Deencapsulation;

import org.junit.Before;
import org.junit.Test;

public class ApplicationExceptionTest {
    @Before
    public void setUp() {
        Deencapsulation.setField(ApplicationContextUtil.class, "context", null);
        Deencapsulation.setField(
                ApplicationContextUtil.class,
                "FILE_APPLICATION_CONTEXT",
                "jp/co/ogis_ri/citk/policytool/common/exception/ApplicationExceptionTest-context.xml");
    }
	
	@Test
	public void testApplicationExceptionMessageInfo() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		ApplicationException e = new ApplicationException(messageInfo);
		
		assertThat(e.getMessageInfo(), is(messageInfo));
		assertThat(e.getMessage(), is(messageInfo.toString()));
	}

	@Test
	public void testApplicationExceptionMessageInfoThrowable() {
		Exception cause = new Exception();
		
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		ApplicationException e = new ApplicationException(messageInfo, cause);
		
		assertThat(e.getMessageInfo(), is(messageInfo));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getCause(), is((Throwable)cause));
	}

	@Test
	public void testApplicationExceptionStringObjectArray() {
		ApplicationException e = new ApplicationException("I-0001", "arg");
		ApplicationException e2 = new ApplicationException(new MessageInfo("I-0001", "arg"));
		
		assertThat(e.getMessageInfo().getCode(), is(e2.getMessageInfo().getCode()));
		assertThat(e.getMessageInfo().getMessage(), is(e2.getMessageInfo().getMessage()));
	}

	@Test
	public void testApplicationExceptionThrowableStringObjectArray() {
		Exception cause = new Exception();
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		
		ApplicationException e = new ApplicationException(cause, "I-0001", "arg");
		ApplicationException e2 = new ApplicationException(messageInfo, cause);
		
		assertThat(e.getMessage(), is(e2.getMessageInfo().toString()));
		assertThat(e.getCause(), is((Throwable)cause));
	}
}
