package jp.co.ogis_ri.citk.policytool.common.exception;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.assertThat;
import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;

import mockit.Deencapsulation;

import org.junit.Before;
import org.junit.Test;

public class ApplicationSettingExceptionTest {
    @Before
    public void before() {
        Deencapsulation.setField(ApplicationContextUtil.class, "context", null);
        Deencapsulation.setField(
                ApplicationContextUtil.class,
                "FILE_APPLICATION_CONTEXT",
                "jp/co/ogis_ri/citk/policytool/common/exception/ApplicationSettingExceptionTest-context.xml");
    }
	
	@Test
	public void testApplicationSettingExceptionMessageInfoThrowable() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		Exception cause = new Exception();
		ApplicationSettingException e = new ApplicationSettingException(messageInfo, cause);
		
		assertThat(e.getCause(), is((Throwable)cause));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

	@Test
	public void testApplicationSettingExceptionMessageInfo() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		ApplicationSettingException e = new ApplicationSettingException(messageInfo);
		
		assertThat(e.getCause(), is(nullValue()));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

	@Test
	public void testApplicationSettingExceptionStringObjectArray() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		ApplicationSettingException e = new ApplicationSettingException("I-0001", "arg");
		
		assertThat(e.getCause(), is(nullValue()));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

	@Test
	public void testApplicationSettingExceptionThrowableStringObjectArray() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		Exception cause = new Exception();
		ApplicationSettingException e = new ApplicationSettingException(cause, "I-0001", "arg");
		
		assertThat(e.getCause(), is((Throwable)cause));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

}
