package jp.co.ogis_ri.citk.policytool.common.exception;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.assertThat;
import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import mockit.Deencapsulation;

import org.junit.Before;
import org.junit.Test;

public class ExcelPolicyReadExceptionTest {
    @Before
    public void before() {
        Deencapsulation.setField(ApplicationContextUtil.class, "context", null);
        Deencapsulation.setField(
                ApplicationContextUtil.class,
                "FILE_APPLICATION_CONTEXT",
                "jp/co/ogis_ri/citk/policytool/common/exception/ExcelPolicyReadExceptionTest-context.xml");
    }
	
	@Test
	public void testExcelPolicyReadExceptionMessageInfoThrowable() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		Exception cause = new Exception();
		ExcelPolicyReadException e = new ExcelPolicyReadException(messageInfo, cause);
		
		assertThat(e.getCause(), is((Throwable)cause));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

	@Test
	public void testExcelPolicyReadExceptionMessageInfo() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		ExcelPolicyReadException e = new ExcelPolicyReadException(messageInfo);
		
		assertThat(e.getCause(), is(nullValue()));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

	@Test
	public void testExcelPolicyReadExceptionStringStringObjectArray() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		ExcelPolicyReadException e = new ExcelPolicyReadException("fileName", "I-0001", "arg");
		
		assertThat(e.getCause(), is(nullValue()));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
		assertThat(e.getFileName(), is("fileName"));
	}

	@Test
	public void testExcelPolicyReadExceptionStringThrowableStringObjectArray() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		Exception cause = new Exception();
		ExcelPolicyReadException e = new ExcelPolicyReadException("fileName", cause, "I-0001", "arg");
		
		assertThat(e.getCause(), is((Throwable)cause));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
		assertThat(e.getFileName(), is("fileName"));
	}
}
