package jp.co.ogis_ri.citk.policytool.common.exception;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.assertThat;
import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import mockit.Deencapsulation;

import org.junit.Before;
import org.junit.Test;

public class ExcelPolicyWriteExceptionTest {
    @Before
    public void before() {
        Deencapsulation.setField(ApplicationContextUtil.class, "context", null);
        Deencapsulation.setField(
                ApplicationContextUtil.class,
                "FILE_APPLICATION_CONTEXT",
                "jp/co/ogis_ri/citk/policytool/common/exception/ExcelPolicyWriteExceptionTest-context.xml");
    }
	
	@Test
	public void testExcelPolicyWriteExceptionMessageInfoThrowable() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		Exception cause = new Exception();
		ExcelPolicyWriteException e = new ExcelPolicyWriteException(messageInfo, cause);
		
		assertThat(e.getCause(), is((Throwable)cause));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

	@Test
	public void testExcelPolicyWriteExceptionMessageInfo() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		ExcelPolicyWriteException e = new ExcelPolicyWriteException(messageInfo);
		
		assertThat(e.getCause(), is(nullValue()));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

	@Test
	public void testExcelPolicyWriteExceptionStringStringObjectArray() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		ExcelPolicyWriteException e = new ExcelPolicyWriteException("fileName", "I-0001", "arg");
		
		assertThat(e.getCause(), is(nullValue()));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
		assertThat(e.getFileName(), is("fileName"));
	}

	@Test
	public void testExcelPolicyWriteExceptionStringThrowableStringObjectArray() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		Exception cause = new Exception();
		ExcelPolicyWriteException e = new ExcelPolicyWriteException("fileName", cause, "I-0001", "arg");
		
		assertThat(e.getCause(), is((Throwable)cause));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
		assertThat(e.getFileName(), is("fileName"));
	}
}
