package jp.co.ogis_ri.citk.policytool.common.exception;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.*;
import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;

import mockit.Deencapsulation;

import org.junit.Before;
import org.junit.Test;

public class OpenAMAccessExceptionTest {
    @Before
    public void before() {
        Deencapsulation.setField(ApplicationContextUtil.class, "context", null);
        Deencapsulation.setField(
                ApplicationContextUtil.class,
                "FILE_APPLICATION_CONTEXT",
                "jp/co/ogis_ri/citk/policytool/common/exception/OpenAMAccessExceptionTest-context.xml");
    }
	
	@Test
	public void testOpenAMAccessExceptionMessageInfoThrowable() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		Exception cause = new Exception();
		OpenAMAccessException e = new OpenAMAccessException(messageInfo, cause);
		
		assertThat(e.getCause(), is((Throwable)cause));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

	@Test
	public void testOpenAMAccessExceptionMessageInfo() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		OpenAMAccessException e = new OpenAMAccessException(messageInfo);
		
		assertThat(e.getCause(), is(nullValue()));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
	}

	@Test
	public void testOpenAMAccessExceptionIntStringObjectArray() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		OpenAMAccessException e = new OpenAMAccessException(127, "I-0001", "arg");
		
		assertThat(e.getCause(), is(nullValue()));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
		assertThat(e.getExitCode(), is(127));
	}

	@Test
	public void testOpenAMAccessExceptionIntThrowableStringObjectArray() {
		MessageInfo messageInfo = new MessageInfo("I-0001", "arg");
		Exception cause = new Exception();
		OpenAMAccessException e = new OpenAMAccessException(127, cause, "I-0001", "arg");
		
		assertThat(e.getCause(), is((Throwable)cause));
		assertThat(e.getMessage(), is(messageInfo.toString()));
		assertThat(e.getMessageInfo().toString(), is("[I-0001]:" + messageInfo.getMessage()));
		assertThat(e.getExitCode(), is(127));
	}

}
