package jp.co.ogis_ri.citk.policytool.common.exception;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.assertThat;

import org.junit.Test;

public class SystemExceptionTest {

	@Test
	public void testSystemException() {
		SystemException e = new SystemException();
		
		assertThat(e.getMessage(), is(nullValue()));
		assertThat(e.getCause(), is(nullValue()));
	}

	@Test
	public void testSystemExceptionString() {
		SystemException e = new SystemException("msg");
		
		assertThat(e.getMessage(), is("msg"));
		assertThat(e.getCause(), is(nullValue()));
	}

	@Test
	public void testSystemExceptionThrowable() {
		Exception cause = new Exception("abcd");
		SystemException e = new SystemException(cause);
		
		assertThat(e.getMessage(), is(cause.toString()));
		assertThat(e.getCause(), is((Throwable)cause));
	}

	@Test
	public void testSystemExceptionStringThrowable() {
		Exception cause = new Exception();
		SystemException e = new SystemException("msg", cause);
		
		assertThat(e.getMessage(), is("msg"));
		assertThat(e.getCause(), is((Throwable)cause));
	}

}
