package jp.co.ogis_ri.citk.policytool.common.logging;

import mockit.Expectations;
import mockit.Mocked;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;

public class LogProxyFactoryTest {
	private static final Class<?> CLASS = LogProxyFactoryTest.class;
	private static final Exception EXCEPTION = new Exception();
	private static final String MESSAGE = "message";
	private Log log = null;
	
	@SuppressWarnings("unused")
	@Mocked(capture=1)
	private LogFactory logFactory = null;
	
	@Test
	public void testFatal() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS); result = log;
			log.isFatalEnabled(); result = false;
			log.isFatalEnabled(); result = true;
			log.fatal(MESSAGE);
			log.isFatalEnabled(); result = true;
			log.fatal(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS);
		log.fatal(MESSAGE);
		log.fatal(MESSAGE);
		log.fatal(MESSAGE, EXCEPTION);

		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isFatalEnabled(); result = false;
			log.isFatalEnabled(); result = true;
			log.fatal(MESSAGE);
			log.isFatalEnabled(); result = true;
			log.fatal(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.fatal(MESSAGE);
		log.fatal(MESSAGE);
		log.fatal(MESSAGE, EXCEPTION);
	}

	@Test
	public void testError() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS); result = log;
			log.isErrorEnabled(); result = false;
			log.isErrorEnabled(); result = true;
			log.error(MESSAGE);
			log.isErrorEnabled(); result = true;
			log.error(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS);
		log.error(MESSAGE);
		log.error(MESSAGE);
		log.error(MESSAGE, EXCEPTION);

		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isErrorEnabled(); result = false;
			log.isErrorEnabled(); result = true;
			log.error(MESSAGE);
			log.isErrorEnabled(); result = true;
			log.error(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.error(MESSAGE);
		log.error(MESSAGE);
		log.error(MESSAGE, EXCEPTION);
	}

	@Test
	public void testWarn() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS); result = log;
			log.isWarnEnabled(); result = false;
			log.isWarnEnabled(); result = true;
			log.warn(MESSAGE);
			log.isWarnEnabled(); result = true;
			log.warn(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS);
		log.warn(MESSAGE);
		log.warn(MESSAGE);
		log.warn(MESSAGE, EXCEPTION);

		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isWarnEnabled(); result = false;
			log.isWarnEnabled(); result = true;
			log.warn(MESSAGE);
			log.isWarnEnabled(); result = true;
			log.warn(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.warn(MESSAGE);
		log.warn(MESSAGE);
		log.warn(MESSAGE, EXCEPTION);
	}

	@Test
	public void testInfo() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS); result = log;
			log.isInfoEnabled(); result = false;
			log.isInfoEnabled(); result = true;
			log.info(MESSAGE);
			log.isInfoEnabled(); result = true;
			log.info(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS);
		log.info(MESSAGE);
		log.info(MESSAGE);
		log.info(MESSAGE, EXCEPTION);

		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isInfoEnabled(); result = false;
			log.isInfoEnabled(); result = true;
			log.info(MESSAGE);
			log.isInfoEnabled(); result = true;
			log.info(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.info(MESSAGE);
		log.info(MESSAGE);
		log.info(MESSAGE, EXCEPTION);
	}

	@Test
	public void testDebug() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS); result = log;
			log.isDebugEnabled(); result = false;
			log.isDebugEnabled(); result = true;
			log.debug(MESSAGE);
			log.isDebugEnabled(); result = true;
			log.debug(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS);
		log.debug(MESSAGE);
		log.debug(MESSAGE);
		log.debug(MESSAGE, EXCEPTION);

		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isDebugEnabled(); result = false;
			log.isDebugEnabled(); result = true;
			log.debug(MESSAGE);
			log.isDebugEnabled(); result = true;
			log.debug(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.debug(MESSAGE);
		log.debug(MESSAGE);
		log.debug(MESSAGE, EXCEPTION);
	}

	@Test
	public void testTrace() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS); result = log;
			log.isTraceEnabled(); result = false;
			log.isTraceEnabled(); result = true;
			log.trace(MESSAGE);
			log.isTraceEnabled(); result = true;
			log.trace(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS);
		log.trace(MESSAGE);
		log.trace(MESSAGE);
		log.trace(MESSAGE, EXCEPTION);

		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isTraceEnabled(); result = false;
			log.isTraceEnabled(); result = true;
			log.trace(MESSAGE);
			log.isTraceEnabled(); result = true;
			log.trace(MESSAGE, EXCEPTION);
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.trace(MESSAGE);
		log.trace(MESSAGE);
		log.trace(MESSAGE, EXCEPTION);
	}

	@Test
	public void testIsFatal() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isFatalEnabled();
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.isFatalEnabled();
	}

	@Test
	public void testIsError() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isErrorEnabled();
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.isErrorEnabled();
	}

	@Test
	public void testIsWarn() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isWarnEnabled();
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.isWarnEnabled();
	}

	@Test
	public void testIsInfo() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isInfoEnabled();
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.isInfoEnabled();
	}

	@Test
	public void testIsDebug() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isDebugEnabled();
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.isDebugEnabled();
	}

	@Test
	public void testIsTrace() {
		new Expectations() { Log log; {
			LogFactory.getLog(CLASS.getClass().getName()); result = log;
			log.isTraceEnabled();
		}};
		log = LogWrapperFactory.getLog(CLASS.getClass().getName());
		log.isTraceEnabled();
	}
}
