package jp.co.ogis_ri.citk.policytool.domain.policy.model;

import static org.junit.Assert.*;
import static org.hamcrest.core.Is.*;
import org.junit.Test;

public class PermitTest {
	private Permit allow = Permit.ALLOW;
	private Permit deny = Permit.DENY;
	private Permit indeterminate = Permit.INDETERMINATE;

	@Test
	public void testAllowSuccess() {
		final String value = "ALLOW";
		final String internalValue = "allow";
		
		assertThat(allow.toString(), is(value));
		assertThat(allow.getInternalValue(), is(internalValue));
		assertThat(Permit.internalValueOf(internalValue), is(allow));
		assertThat(Permit.valueOf(value), is(allow));
	}

	@Test
	public void testDenySuccess() {
		final String value = "DENY";
		final String internalValue = "deny";

		assertThat(deny.toString(), is(value));
		assertThat(deny.getInternalValue(), is(internalValue));
		assertThat(Permit.internalValueOf(internalValue), is(deny));
		assertThat(Permit.valueOf(value), is(deny));
	}

	@Test
	public void testIndeterminateSuccess() {
		final String value = "INDETERMINATE";
		final String internalValue = "";

		assertThat(indeterminate.toString(), is(value));
		assertThat(indeterminate.getInternalValue(), is(internalValue));
		assertThat(Permit.internalValueOf(internalValue), is(indeterminate));
		assertThat(Permit.valueOf(value), is(indeterminate));
	}

	@Test(expected=IllegalArgumentException.class)
	public void testValueOfFail() {
		Permit.valueOf("fail");
	}

	@Test(expected=IllegalArgumentException.class)
	public void testInternalValueOfFail() {
		Permit.internalValueOf("fail");
	}
}
