package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import mockit.Expectations;
import mockit.Mocked;

import org.junit.Test;

public class RuleUniquePolicyNameTest {
	@Mocked
	private TestConstraintValidatorContext context;
	
	@Mocked
	private TestConstraintViolationBuilder builder;

	@Mocked
	private TestNodeBuilderDefinedContext definedContext;
	
	@Mocked
	private TestNodeBuilderCustomizableContext customizableContext;
	
	@Mocked
	private TestNodeContextBuilder nodeContextBuilder;
	
	@Test
	public void testIsValid_OK() {
		Policy policy = new Policy();
		policy.setPolicyName("policy2");
		
		PolicyValidModel model = new PolicyValidModel();
		model.setTarget(policy);
		model.getPolicyNames().add("policy1");
		model.getPolicyNames().add("policy3");
		model.getPolicyNames().add("policy4");
		
		RuleUniquePolicyName.Validator validator = new RuleUniquePolicyName.Validator();
		
		boolean actual = validator.isValid(model, null);
		assertThat(actual, is(true));
	}
	
	@Test
	public void testIsValid_OK_PolicyNamesZERO() {
		Policy policy = new Policy();
		policy.setPolicyName("policy2");
		
		PolicyValidModel model = new PolicyValidModel();
		model.setTarget(policy);
		
		RuleUniquePolicyName.Validator validator = new RuleUniquePolicyName.Validator();
		
		boolean actual = validator.isValid(model, null);
		assertThat(actual, is(true));
	}
	
	@Test
	public void testIsValid_NG() {
		Policy policy = new Policy();
		policy.setPolicyName("policy2");
		
		PolicyValidModel model = new PolicyValidModel();
		model.setTarget(policy);
		model.getPolicyNames().add("policy1");
		model.getPolicyNames().add("policy2");
		model.getPolicyNames().add("policy3");

		new Expectations() {
			{
				new TestConstraintValidatorContext();
				new TestConstraintViolationBuilder();
				new TestNodeBuilderDefinedContext();
				new TestNodeBuilderCustomizableContext();
				new TestNodeContextBuilder();
				context.disableDefaultConstraintViolation();
				context.getDefaultConstraintMessageTemplate();
				result = "template2";
				context.buildConstraintViolationWithTemplate("template2、値=policy2");
				result = builder;
				builder.addNode("policy");
				result = definedContext;
				definedContext.addNode("policyName");
				result = customizableContext;
				customizableContext.inIterable();
				result = nodeContextBuilder;
				nodeContextBuilder.atIndex(1);
				result = definedContext;
				definedContext.addConstraintViolation();
			}
		};

		TestConstraintValidatorContext context = new TestConstraintValidatorContext();
		new TestConstraintViolationBuilder();
		new TestNodeBuilderDefinedContext();
		new TestNodeBuilderCustomizableContext();
		new TestNodeContextBuilder();
		
		RuleUniquePolicyName.Validator validator = new RuleUniquePolicyName.Validator();
		boolean actual = validator.isValid(model, context);
		assertThat(actual, is(false));
	}
	
	private static class TestConstraintValidatorContext implements ConstraintValidatorContext {
		@Override
		public void disableDefaultConstraintViolation() {
		}

		@Override
		public String getDefaultConstraintMessageTemplate() {
			return null;
		}

		@Override
		public ConstraintViolationBuilder buildConstraintViolationWithTemplate(
				String messageTemplate) {
			return null;
		}
	}
	
	private static class TestConstraintViolationBuilder implements ConstraintViolationBuilder {
		@Override
		public NodeBuilderDefinedContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
	
	private static class TestNodeBuilderDefinedContext implements NodeBuilderDefinedContext {
		@Override
		public NodeBuilderCustomizableContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
	
	private static class TestNodeBuilderCustomizableContext implements NodeBuilderCustomizableContext {
		@Override
		public NodeContextBuilder inIterable() {
			return null;
		}

		@Override
		public NodeBuilderCustomizableContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
	
	private static class TestNodeContextBuilder implements NodeContextBuilder {
		@Override
		public NodeBuilderDefinedContext atKey(Object key) {
			return null;
		}

		@Override
		public NodeBuilderDefinedContext atIndex(Integer index) {
			return null;
		}

		@Override
		public NodeBuilderCustomizableContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
}
