package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import mockit.Expectations;
import mockit.Mocked;

import org.junit.Test;

public class RuleValidRealmNameTest {
	@Mocked
	private TestConstraintValidatorContext context;
	
	@Mocked
	private TestConstraintViolationBuilder builder;

	@Mocked
	private TestNodeBuilderDefinedContext definedContext;
	
	@Mocked
	private TestNodeBuilderCustomizableContext customizableContext;
	
	@Test
	public void testIsValid_OK() {
		Policy policy = new Policy();
		policy.setRealmName("realm1");
		
		PolicyValidModel model = new PolicyValidModel();
		model.setTarget(policy);
		model.setIsExistRealm(true);
		
		RuleValidRealmName.Validator validator = new RuleValidRealmName.Validator();
		
		boolean actual = validator.isValid(model, null);
		assertThat(actual, is(true));
	}
	
	@Test
	public void testIsValid_NG() {
		Policy policy = new Policy();
		policy.setRealmName("realm1");
		
		PolicyValidModel model = new PolicyValidModel();
		model.setTarget(policy);
		model.setIsExistRealm(false);

		new Expectations() {
			{
				new TestConstraintValidatorContext();
				new TestConstraintViolationBuilder();
				new TestNodeBuilderDefinedContext();
				new TestNodeBuilderCustomizableContext();
				context.disableDefaultConstraintViolation();
				context.getDefaultConstraintMessageTemplate();
				result = "template2";
				context.buildConstraintViolationWithTemplate("template2、値=realm1");
				result = builder;
				builder.addNode("policy");
				result = definedContext;
				definedContext.addNode("realmName");
				result = customizableContext;
				customizableContext.addConstraintViolation();
			}
		};

		TestConstraintValidatorContext context = new TestConstraintValidatorContext();
		new TestConstraintViolationBuilder();
		new TestNodeBuilderDefinedContext();
		new TestNodeBuilderCustomizableContext();
		
		RuleValidRealmName.Validator validator = new RuleValidRealmName.Validator();
		boolean actual = validator.isValid(model, context);
		assertThat(actual, is(false));
	}
	
	private static class TestConstraintValidatorContext implements ConstraintValidatorContext {
		@Override
		public void disableDefaultConstraintViolation() {
		}

		@Override
		public String getDefaultConstraintMessageTemplate() {
			return null;
		}

		@Override
		public ConstraintViolationBuilder buildConstraintViolationWithTemplate(
				String messageTemplate) {
			return null;
		}
	}
	
	private static class TestConstraintViolationBuilder implements ConstraintViolationBuilder {
		@Override
		public NodeBuilderDefinedContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
	
	private static class TestNodeBuilderDefinedContext implements NodeBuilderDefinedContext {
		@Override
		public NodeBuilderCustomizableContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
	
	private static class TestNodeBuilderCustomizableContext implements NodeBuilderCustomizableContext {
		@Override
		public NodeContextBuilder inIterable() {
			return null;
		}

		@Override
		public NodeBuilderCustomizableContext addNode(String name) {
			return null;
		}

		@Override
		public ConstraintValidatorContext addConstraintViolation() {
			return null;
		}
	}
}
