package jp.co.ogis_ri.citk.policytool.domain.util;

import java.io.InputStream;
import java.sql.Connection;

import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;

/**
 * ユニットテスト時のデータローダー.
 * 
 */
public class DbUnitDataLoader
{
    private InputStream testData;
    private Connection connection;

    public DbUnitDataLoader(InputStream testData, Connection connection)
    {
        this.testData = testData;
        this.connection = connection;
    }

    /**
     * Replace existing data with test data
     * 
     * @throws Exception
     */
    public void populateTestData() throws Exception
    {
    	IDataSet dataSet = new FlatXmlDataSetBuilder().build(testData);
        IDatabaseConnection con = new DatabaseConnection(connection);
        DatabaseOperation.CLEAN_INSERT.execute(con, dataSet);
        con.close();
    }
}
