package jp.co.ogis_ri.citk.policytool.service.common.validation;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.impl.JpaPolicyRepositoryImpl;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import jp.co.ogis_ri.citk.policytool.domain.realm.impl.JpaRealmRepositoryImpl;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import mockit.Deencapsulation;
import mockit.Expectations;
import mockit.Mocked;

import org.junit.Before;
import org.junit.Test;

public class PolicyValidModelFactoryTest {
	@Mocked
	private JpaPolicyRepositoryImpl policyRepository;
	
	@Mocked
	private JpaRealmRepositoryImpl realmRepository;
	
	@Before
	public void setUp() {
        Deencapsulation.setField(ApplicationContextUtil.class, "context", null);
        Deencapsulation.setField(
                ApplicationContextUtil.class,
                "FILE_APPLICATION_CONTEXT",
                "jp/co/ogis_ri/citk/policytool/service/common/validation/PolicyValidModelFactoryTest-context.xml");
	}
	
	@Test
	public void testCreate() {
		Policy policy = new Policy();
		
		policy.setPolicyName("policy1");
		policy.setRealmName("realm1");
		
		final List<Realm> realmList = new ArrayList<Realm>();
		Realm realm0 = new Realm("realm0");
		realmList.add(realm0);
		Realm realm1 = new Realm("realm1");
		Referral referral = new Referral();
		referral.setRefpolicy("refpol");
		realm1.addReferral(referral);
		Group group = new Group();
		group.setGroupName("gname");
		group.setGroupCode("o=1,p=2");
		realm1.addGroup(group);
		realmList.add(realm1);
		Realm realm2 = new Realm("realm2");
		realmList.add(realm2);
		
		final List<Policy> policyList = new ArrayList<Policy>();
		Policy policy1 = new Policy();
		policy1.setPolicyName("a1");
		policyList.add(policy1);
		Policy policy2 = new Policy();
		policy2.setPolicyName("a2");
		policyList.add(policy2);
		
		new Expectations() {
			{
				new JpaPolicyRepositoryImpl();
				new JpaRealmRepositoryImpl();
				realmRepository.findAll(); result = realmList;
				policyRepository.findAll(); result = policyList;
			}
		};
		
		PolicyValidModel model = PolicyValidModelFactory.create(policy);
		assertThat(model.getIsExistRealm(), is(true));
		assertThat(model.getRefpolicies().size(), is(1));
		assertThat(model.getRefpolicies().get(0), is("refpol"));
		assertThat(model.getGroups().size(), is(1));
		assertThat(model.getGroups().get(0), is("gname(o=1,p=2)"));
		assertThat(model.getPolicyNames().size(), is(2));
		assertThat(model.getPolicyNames().get(1), is("a2"));
		assertThat(model.getTarget(), is(policy));
	}
	
	@Test
	public void testCreate_RefpolicyZero_GroupZero_PolicyZero() {
		Policy policy = new Policy();
		
		policy.setPolicyName("policy1");
		policy.setRealmName("realm1");
		
		final List<Realm> realmList = new ArrayList<Realm>();
		Realm realm0 = new Realm("realm0");
		realmList.add(realm0);
		Realm realm1 = new Realm("realm1");
		realmList.add(realm1);
		Realm realm2 = new Realm("realm2");
		realmList.add(realm2);
		
		final List<Policy> policyList = new ArrayList<Policy>();
		
		new Expectations() {
			{
				new JpaPolicyRepositoryImpl();
				new JpaRealmRepositoryImpl();
				realmRepository.findAll(); result = realmList;
				policyRepository.findAll(); result = policyList;
			}
		};
		
		PolicyValidModel model = PolicyValidModelFactory.create(policy);
		
		assertThat(model.getIsExistRealm(), is(true));
		assertThat(model.getRefpolicies().size(), is(0));
		assertThat(model.getGroups().size(), is(0));
		assertThat(model.getPolicyNames().size(), is(0));
		assertThat(model.getTarget(), is(policy));
	}

	@Test
	public void testCreate_RealmNotExist() {
		Policy policy = new Policy();
		
		policy.setPolicyName("policy1");
		policy.setRealmName("realm1");
		
		final List<Realm> realmList = new ArrayList<Realm>();
		Realm realm0 = new Realm("realm0");
		realmList.add(realm0);
		Realm realm1 = new Realm("realm_KKK");
		realmList.add(realm1);
		Realm realm2 = new Realm("realm2");
		realmList.add(realm2);
		
		final List<Policy> policyList = new ArrayList<Policy>();
		
		new Expectations() {
			{
				new JpaPolicyRepositoryImpl();
				new JpaRealmRepositoryImpl();
				realmRepository.findAll(); result = realmList;
				policyRepository.findAll(); result = policyList;
			}
		};
		
		PolicyValidModel model = PolicyValidModelFactory.create(policy);
		
		assertThat(model.getIsExistRealm(), is(false));
		assertThat(model.getRefpolicies().size(), is(0));
		assertThat(model.getGroups().size(), is(0));
		assertThat(model.getPolicyNames().size(), is(0));
		assertThat(model.getTarget(), is(policy));
	}

	@Test
	public void testCreate_RealmZero() {
		Policy policy = new Policy();
		
		policy.setPolicyName("policy1");
		policy.setRealmName("realm1");
		
		final List<Realm> realmList = new ArrayList<Realm>();
		
		final List<Policy> policyList = new ArrayList<Policy>();
		
		new Expectations() {
			{
				new JpaPolicyRepositoryImpl();
				new JpaRealmRepositoryImpl();
				realmRepository.findAll(); result = realmList;
				policyRepository.findAll(); result = policyList;
			}
		};
		
		PolicyValidModel model = PolicyValidModelFactory.create(policy);
		
		assertThat(model.getIsExistRealm(), is(false));
		assertThat(model.getRefpolicies().size(), is(0));
		assertThat(model.getGroups().size(), is(0));
		assertThat(model.getPolicyNames().size(), is(0));
		assertThat(model.getTarget(), is(policy));
	}
}
