package jp.co.ogis_ri.citk.policytool.service.exportpolicy.impl;

import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.excel.impl.ExcelPolicyWriterImpl;
import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import mockit.Expectations;
import mockit.Mocked;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration({"ExportPolicyServiceImplTest-context.xml"})
public class ExportPolicyServiceImplTest {

    @Autowired
    @Qualifier(value = "exportPolicyServiceImpl")
    private ExportPolicyServiceImpl service = null;

    @Mocked
    private TestPolicyRepository policyRepository;
    
    @Mocked
    private ExcelPolicyWriterImpl excelPolicyWriter;
    
	@Test
	public void testExportPolicy() {
		final List<Policy> policies = new ArrayList<Policy>();
		new Expectations() {
			{
				policyRepository.findPolicies("realm", "group", "url");
				result = policies;
				excelPolicyWriter.write("file", policies);
			}
		};
		
		service.exportPolicy("realm", "group", "url", "file");
	}

	public static class TestPolicyRepository implements PolicyRepository {

		public TestPolicyRepository() {
		}
		
		@Override
		public Policy findById(Long id) {
			return null;
		}

		@Override
		public List<Policy> findAll() {
			return null;
		}

		@Override
		public void persist(Policy entity) {
		}

		@Override
		public Policy merge(Policy entity) {
			return null;
		}

		@Override
		public void remove(Policy entity) {
		}

		@Override
		public void removeAll() {
		}

		@Override
		public void reflesh(Policy entity) {
		}

		@Override
		public void sync(String realmName) {
		}

		@Override
		public List<Policy> findPoliciesByRealmName(String realmName) {
			return null;
		}

		@Override
		public List<Policy> findPolicies(String realmName, String subjectName,
				String url) {
			return null;
		}

		@Override
		public void importPolicies(List<Policy> policies) {
		}
	}
}
