package jp.co.ogis_ri.citk.policytool.service.policylist.impl;

import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.realm.RealmRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;

import mockit.Expectations;
import mockit.Mocked;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration({"PolicyListServiceImplTest-context.xml"})
public class PolicyListServiceImplTest {

    @Autowired
    @Qualifier(value = "policyListService")
    private PolicyListServiceImpl service = null;

    @Mocked
    private TestRealmRepository realmRepository;
    
    @Mocked
    private TestPolicyRepository policyRepository;

	@Test
	public void testRefresh() {
		final List<Realm> realmList = new ArrayList<Realm>();
		Realm realm1 = new Realm("name1");
		realmList.add(realm1);
		Realm realm2 = new Realm("name2");
		realmList.add(realm2);
		new Expectations() {
			{
				realmRepository.sync();
				policyRepository.removeAll();
				realmRepository.findAll(); result = realmList;
				policyRepository.sync("name1");
				policyRepository.sync("name2");
			}
		};

		service.refresh();
	}

	@Test
	public void testRefresh_RealmZero() {
		final List<Realm> realmList = new ArrayList<Realm>();
		new Expectations() {
			{
				realmRepository.sync();
				policyRepository.removeAll();
				realmRepository.findAll(); result = realmList;
			}
		};

		service.refresh();
	}

	/**
	 * PolicyRepository をモックに置換するためのダミークラス
	 *
	 */
	public static class TestPolicyRepository implements PolicyRepository{

		public TestPolicyRepository() {
		}
		
		@Override
		public Policy findById(Long id) {
			return null;
		}

		@Override
		public List<Policy> findAll() {
			return null;
		}

		@Override
		public void persist(Policy entity) {
		}

		@Override
		public Policy merge(Policy entity) {
			return null;
		}

		@Override
		public void remove(Policy entity) {
		}

		@Override
		public void removeAll() {
		}

		@Override
		public void reflesh(Policy entity) {
		}

		@Override
		public void sync(String realmName) {
		}

		@Override
		public List<Policy> findPoliciesByRealmName(String realmName) {
			return null;
		}

		@Override
		public List<Policy> findPolicies(String realmName, String subjectName,
				String url) {
			return null;
		}

		@Override
		public void importPolicies(List<Policy> policies) {
		}
		
	}
	
	/**
	 * RealmRepository をモックに置換するためのダミークラス
	 *
	 */
	public static class TestRealmRepository implements RealmRepository {

		public TestRealmRepository() {
		}
		
		@Override
		public Realm findById(Long id) {
			return null;
		}

		@Override
		public List<Realm> findAll() {
			return null;
		}

		@Override
		public void persist(Realm entity) {
		}

		@Override
		public Realm merge(Realm entity) {
			return null;
		}

		@Override
		public void remove(Realm entity) {
		}

		@Override
		public void removeAll() {
		}

		@Override
		public void reflesh(Realm entity) {
		}

		@Override
		public void sync() {
		}
		
		@Override
		public List<String> findGroupNames(Realm realm) {
			return null;
		}

		@Override
		public List<Referral> findReferrals(Realm realm) {
			return null;
		}

		@Override
		public Realm findRealmByName(String realmName) {
			return null;
		}

		@Override
		public List<Group> findGroupByRealm(Realm realm) {
			return null;
		}

		@Override
		public Group findGroupByName(Realm realm, String groupName) {
			return null;
		}
		
	}
}
