using System;
using System.Windows.Forms;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Diagnostics;

namespace ClassifyVCF
{
    public partial class Form1 : Form
    {
        public Form1() {
            InitializeComponent();
        }

        private void buttonClose_Click(object sender, EventArgs e) {
            this.Close();
        }

        private void button1_Click(object sender, EventArgs e) {
            if (openFileDialog.ShowDialog(this) == DialogResult.OK) {
                textBox1.Text = openFileDialog.FileName;
            }
        }

        private void button2_Click(object sender, EventArgs e) {
            if (folderBrowserDialog.ShowDialog(this) == DialogResult.OK) {
                textBox2.Text = folderBrowserDialog.SelectedPath;
            }
        }

        private void button3_Click(object sender, EventArgs e) {
            if (!File.Exists(textBox1.Text)) {
                MessageBox.Show(this, "w肳ꂽ vCard t@C ܂B", "ǂݍ݃G[", MessageBoxButtons.OK, MessageBoxIcon.Error);
                button1.Focus();
                return;
            }

            if (!Directory.Exists(textBox2.Text)) {
                MessageBox.Show(this, "w肳ꂽo͐tH_܂B", "ǂݍ݃G[", MessageBoxButtons.OK, MessageBoxIcon.Error);
                button2.Focus();
                return;
            }

            string vcf = "";
            try {
                vcf = File.ReadAllText(textBox1.Text, Encoding.GetEncoding("shift_jis"));
            } catch {
                MessageBox.Show(this, "t@C̓ǂݍ݂Ɏs܂B𒆒f܂B", "G[", MessageBoxButtons.OK, MessageBoxIcon.Error);
                button3.Focus();
                return;
            }
            vcf = vcf.Replace("@;;;;", ";;;;");

            Hashtable vcfs = new Hashtable();
            Regex r_vcard = new Regex(@"BEGIN:VCARD(.*?)END:VCARD\r?\n", RegexOptions.IgnoreCase | RegexOptions.Singleline | RegexOptions.Multiline);
            Match m_vcard = r_vcard.Match(vcf);

            while (m_vcard.Success) {
                string vcard = m_vcard.Value;

                Regex r_group = new Regex(@"X-GN(?:;CHARSET=SHIFT_JIS)?:(.+?)\r?\n", RegexOptions.IgnoreCase);
                Match m_group = r_group.Match(vcard);
                if (m_group.Success) {
                    vcfs[m_group.Groups[1].Value] += vcard;
                }
                else {
                    vcfs["undef"] += vcard;
                }

                m_vcard = m_vcard.NextMatch();
            }

            int i = 1;
            foreach (string key in vcfs.Keys) {
                string file = textBox2.Text + '\\' + "vcard_" + i.ToString("00") + ".vcf";
                if (checkBox1.Checked && File.Exists(file)) {
                    DialogResult result = MessageBox.Show(this, "ɑ݂鉺L̃t@C㏑Ă낵łH\r\n" + file, "㏑mF"
                        , MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
                    if (result == DialogResult.No) {
                        continue;
                    }
                }
                try {
                    File.WriteAllText(file, (string)vcfs[key], Encoding.GetEncoding("shift_jis"));
                } catch {
                    MessageBox.Show(this, "t@C݂̏Ɏs܂B𒆒f܂B", "G[", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    button3.Focus();
                    return;
                }
                i++;
            }

            MessageBox.Show(this, "܂B", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e) {
            Process.Start("http://www.yuuan.net/blog/");
        }

    }
}