%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Creating the /etc/fstab File</title>
@y
  <title>/etc/fstab ファイルの生成</title>
@z

@x
    <secondary>boot</secondary>
@y
    <secondary>ブート</secondary>
@z

@x
  <para os="a">The <filename>/etc/fstab</filename> file is used by some
  programs to determine where file systems are to be mounted by default,
  which must be checked, and in which order. Create a new file systems
  table like this:</para>
@y
  <para os="a">
  <filename>/etc/fstab</filename> ファイルは種々のプログラムがファイルシステムのマウント状況を確認するために利用するファイルです。
  ファイルシステムがデフォルトでどこにマウントされ、それがどういう順序であるか、マウント前に (整合性エラーなどの) チェックを行うかどうかという設定が行われます。
  新しいファイルシステムに対する設定は以下のようにして生成します。
  </para>
@z

@x
  <para os="c">The <filename class="directory">/dev/shm</filename> mount point
  for <systemitem class="filesystem">tmpfs</systemitem> is included to
  allow enabling POSIX-shared memory. The kernel must have the required
  support built into it for this to work (more about this is in the next
  section). Please note that very little software currently uses
  POSIX-shared memory.  Therefore, consider the <filename
  class="directory">/dev/shm</filename> mount point optional. For more
  information, see <filename>Documentation/filesystems/tmpfs.txt</filename>
  in the kernel source tree.</para>
@y
  <para os="c">
  <systemitem class="filesystem">tmpfs</systemitem> に対してはマウントポイント <filename
  class="directory">/dev/shm</filename> を設けています。
  これは POSIX 共有メモリ (POSIX-shared memory) を有効にするためです。
  カーネルのビルドにあたっては所定のサポートを有効にしなければなりません。
  (詳しくは次節にて示します。)
  ただし最近はこの共有メモリを利用しているソフトウェアはさほど多くありません。
  ですからマウントポイント <filename
  class="directory">/dev/shm</filename> を設けるかどうかは任意です。
  詳しくはカーネルソースツリー内の <filename>Documentation/filesystems/tmpfs.txt</filename> を参照してください。
  </para>
@z