%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <title>Installation of Glibc</title>
@y
    <title>&InstallationOf1;Glibc&InstallationOf2;</title>
@z

@x
    <para os="l3">Modify the <command>ldd</command> rewrite script to prevent
    it from adding <filename class="directory">lib64</filename> and
    <filename class="directory">libx32</filename> to its list of linker
    search locations:</para>
@y
    <!--
    日本語訳註: matsuand
    rewrite は訳出しなかった。ldd にそういう機能性があるらしきであるが、
    訳出することで変にくどくなってしまうことを避けることに。
    -->
    <para os="l3">
    スクリプト <command>ldd</command> を修正して、リンカーの検索場所の一覧に <filename
    class="directory">lib64</filename> ディレクトリや <filename
    class="directory">libx32</filename> ディレクトリを加えないようにします。
    </para>
@z

@x
    <para os="l5">Configure Glibc to install its libraries into
    <filename class="directory">/lib</filename>:</para>
@y
    <para os="l5">
    Glibc においてライブラリのインストール先を <filename class="directory">/lib</filename> にします。
    </para>
@z

%@x
%      <title>The meaning of the new configure option:</title>
%@y
%      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
%@z
%
%@x --libexecdir=/usr/lib/glibc
%          <para>This changes the location of the <command>getconf</command>
%          utility from its default of <filename
%          class="directory">/usr/libexec</filename> to <filename
%          class="directory">/usr/lib/glibc</filename>.</para>
%@y
%          <para>
%          <command>getconf</command> ユーティリティーのインストールディレクトリを、デフォルトの <filename
%          class="directory">/usr/libexec</filename> でなく <filename
%          class="directory">/usr/lib/glibc</filename> に変更します。
%          </para>
%@z
%
%@x
%    <para>The install will finish by checking that everything is correctly installed.
%    Unfortunately, it will test for a multilib installation. On x86_64 Pure64 this means
%    it will try to test the non-existent 32-bit loader which has a different name
%    from the 64-bit loader (unlike on other 64-bit architectures).  We fool it by
%    creating a symlink to the real loader.</para>
%@y
%    <!--
%    日本語訳註: matsuand, 2017/04/21
%    unlike のカッコ書き部分の訳はいかがなものか..
%    -->
%    <para>
%    インストールの最後にはすべてが正しくインストールできたかのチェックが行われます。
%    ただそこで行われるテストはマルチライブラリ用のものです。
%    x86_64 Pure64 のインストールの場合、存在しない32ビットローダーのテストを実行することになってしまいます。
%    その32ビットローダーは64ビットローダーの名称とは異なります。
%    (64ビットアークテクチャーシステムの場合も異なります。)
%    シンボリックリンクを生成してローダーが存在しているように仕向けます。
%    </para>
%@z
%
%@x
%    <para>Now we can remove this symlink.  We also need to correct the <command>
%    /usr/bin/ldd</command> script - if you look at this, you will see it references
%    not only the 32-bit linker, but also /lib64 where it thinks the 64-bit linker
%    is. The following <command>sed</command> will correct this:</para>
%@y
%    <para>
%    上で作ったシンボリックリンクを削除します。
%    また <command>/usr/bin/ldd</command> スクリプトを修正する必要があります。
%    以下を見れば分かると思いますが、そのスクリプトは32ビットリンカーだけでなく /lib64 ディレクトリも参照しています。
%    <command>/usr/bin/ldd</command> は 64ビットリンカーが /lib64 にあるものとして動作する状況にあるわけです。
%    以下の <command>sed</command> によりこの状況を修正します。
%    </para>
%@z
%
%@x
%    <para>Check the script to make sure the sed worked correctly, then delete
%    the backup.</para>
%@y
%    <para>
%    <command>ldd</command> スクリプトに対して sed コマンドが正しく適用できたことを確認してください。
%    そしてバックアップファイルは削除します。
%    </para>
%@z

@x
    <title>Configuring The Dynamic Loader</title>
@y
    <title>&Configuring1;ダイナミックローダー&Configuring2;</title>
@z

@x
    <para>By default, the dynamic loader (<filename
    class="libraryfile">/lib/ld-linux-x86-64.so.2</filename>) searches through
    <filename class="directory">/lib</filename> and <filename
    class="directory">/usr/lib</filename> for dynamic libraries that are
    needed by programs as they are run. However, if there are libraries in
    directories other than <filename class="directory">/lib</filename> and
    <filename class="directory">/usr/lib</filename>, these need to be
    added to the <filename>/etc/ld.so.conf</filename> file in order
    for the dynamic loader to find them. Two directories that are commonly
    known to contain additional libraries are <filename
    class="directory">/usr/local/lib</filename> and <filename
    class="directory">/opt/lib</filename>, so add those directories to the
    dynamic loader's search path.</para>
@y
    <para>
    ダイナミックリンカー (<filename
    class="libraryfile">/lib/ld-linux-x86-64.so.2</filename>) がダイナミックライブラリを検索するデフォルトのディレクトリが <filename
    class="directory">/lib</filename> ディレクトリと <filename
    class="directory">/usr/lib</filename> ディレクトリです。
    各種プログラムが実行される際にはここから検索されたダイナミックライブラリがリンクされます。
    もし <filename class="directory">/lib</filename> や <filename
    class="directory">/usr/lib</filename> 以外のディレクトリにライブラリファイルがあるなら <filename>/etc/ld.so.conf</filename> ファイルに記述を追加して、ダイナミックローダーがそれらを探し出せるようにしておくことが必要です。
    追加のライブラリが配置されるディレクトリとしては <filename
    class="directory">/usr/local/lib</filename> ディレクトリと <filename
    class="directory">/opt/lib</filename> ディレクトリという二つがよく利用されます。
    ダイナミックローダーの検索パスとしてこのようなディレクトリを追加します。
    </para>
@z