%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
<appendix id="appendixb" xreflabel="Appendix B">
@y
<appendix id="appendixb" xreflabel="付録B">
@z

@x
  <title>Dependencies</title>
@y
  <title>パッケージ依存関係</title>
@z

@x
  <para>Every package built in CLFS relies on one or more other packages
  in order to build and install properly. Some packages even participate
  in circular dependencies, that is, the first package depends on the second
  which in turn depends on the first. Because of these dependencies, the
  order in which packages are built in CLFS is very important. The purpose
  of this page is to document the dependencies of each package built in CLFS.</para>
@y
  <para>
  CLFS にて構築するパッケージはすべて、他のいくつかのパッケージに依存していて、それらがあって初めて適切にインストールができます。
  パッケージの中には互いに依存し合っているものもあります。
  つまり一つめのパッケージが二つめのパッケージに依存しており、二つめが実は一つめのパッケージにも依存しているような例です。
  こういった依存関係があることから CLFS においてパッケージを構築する順番は非常に重要なものとなります。
  本節は CLFS にて構築する各パッケージの依存関係を示すものです。
  </para>
@z

@x
  <para>For each package we build, we have listed three types of dependencies.
  The first lists what other packages need to be available in order to compile
  and install the package in question. The second lists what packages, in
  addition to those on the first list, need to be available in order to run the
  test suites. The last list of dependencies are packages that require this
  package to be built and installed in its final location before they are built
  and installed. In most cases, this is because these packages will hardcode
  paths to binaries within their scripts. If not built in a certain order,
  this could result in paths of /tools/bin/[binary] being placed inside
  scripts installed to the final system. This is obviously not desirable.
  </para>
@y
  <para>
  ビルドするパッケージの個々には三種類の依存関係を示しています。
  1つめは対象パッケージをコンパイルしてビルドするために必要となるパッケージです。
  2つめは一つめのものに加えて、テストスイートを実行するために必要となるパッケージです。
  3つめは対象パッケージをビルドし、最終的にインストールするために必要となるパッケージです。
  たいていの場合、それらのパッケージに含まれているスクリプトが、実行モジュールへのパスを固定的に取り扱っています。
  所定の順番どおりにパッケージのビルドを行わないと、最終的にインストールされるシステムにおいて、スクリプトの中に /tools/bin/[実行モジュール] といったパスが含まれてしまうことになりかねません。
  これは明らかに不適切なことです。
  </para>
@z

@x Automake
          <seg>Bison, Bzip2, DejaGNU, Diffutils, Expect, Findutils,
          Flex, GCC, Gettext, Gzip, Libtool, Tar, XZ Utils. Can also use several
          other packages that are not installed in CLFS.</seg>
@y
          <seg>Bison, Bzip2, DejaGNU, Diffutils, Expect, Findutils,
          Flex, GCC, Gettext, Gzip, Libtool, Tar, XZ Utils
          これ以外に CLFS では取り扱っていないパッケージ類</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Bash
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Bc
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Binutils
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Bzip2
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x CLFS-Boot-scripts
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Check
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin DejaGNU dependency info -->
@y
<!-- Begin DejaGNU dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin DHCPCD dependency info -->
@y
<!-- Begin DHCPCD dependency info -->
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Diffutils dependency info -->
@y
<!-- Begin Diffutils dependency info -->
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Eudev dependency info -->
@y
<!-- Begin Eudev dependency info -->
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z

@x
<!-- Begin Expect dependency info -->
@y
<!-- Begin Expect dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin E2fsprogs dependency info -->
@y
<!-- Begin E2fsprogs dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin File dependency info -->
@y
<!-- Begin File dependency info -->
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Findutils dependency info -->
@y
<!-- Begin Findutils dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Gawk
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Gcc
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin GDBM dependency info -->
@y
<!-- Begin GDBM dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Glibc dependency info -->
@y
<!-- Begin Glibc dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Glib
         <seg>bash, binutils, coreutils, gawk, gcc, gettext, make &amp; M4.</seg>
@y
         <seg>bash, binutils, coreutils, gawk, gcc, gettext, make, M4</seg>
@z
@x
          <seg>Unknown</seg>
@y
          <seg>不明</seg>
@z

@x GMP
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Groff
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z

@x Iana-Etc
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z

@x IProute2
         <seg>Bash, Binutils, Bison, Coreutils, Glibc, Findutils, Flex, GCC,
         Make, Linux Headers, Sed</seg>
@y
         <seg>Bash, Binutils, Bison, Coreutils, Glibc, Findutils, Flex, GCC,
         Make, Linux ヘッダー, Sed</seg>
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x IPutils
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x ISL
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Kbd
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x KMOD
         <seg>Bash, Binutils, Bison, Coreutils, Glibc, Flex, Gawk, GCC,
         Gettext, Gzip, Make, Pkg-config-lite, Sed, XZ Utils, Zlib.
@y
         <seg>Bash, Binutils, Bison, Coreutils, Glibc, Flex, Gawk, GCC,
         Gettext, Gzip, Make, Pkg-config-lite, Sed, XZ Utils, Zlib
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z

@x Less
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin libee dependency info -->
@y
<!-- Begin libee dependency info -->
@z
@x Libee
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z

@x
<!-- Begin libestr dependency info -->
@y
<!-- Begin libestr dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Libtool dependency info -->
@y
<!-- Begin Libtool dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Linux Headers
  <bridgehead renderas="sect2" id="linux-headers-dep">Linux Headers</bridgehead>
@y
  <bridgehead renderas="sect2" id="linux-headers-dep">Linux ヘッダー</bridgehead>
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Linux Kernel
  <bridgehead renderas="sect2" id="linux-dep">Linux Kernel</bridgehead>
@y
  <bridgehead renderas="sect2" id="linux-dep">Linux カーネル</bridgehead>
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Make
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Man-DB
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Man-Pages dependency info -->
@y
<!-- Begin Man-Pages dependency info -->
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x MPC
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x MPFR
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin KMOD dependency info -->
@y
<!-- Begin KMOD dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Ncurses
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z

@x Patch
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Pkg-config-lite
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Procps-ng
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Psmisc
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Readline
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z

@x
<!-- Begin Rsyslog dependency info -->
@y
<!-- Begin Rsyslog dependency info -->
@z
@x
          <seg>No testsuite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x Shadow
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Sysvinit dependency info -->
@y
<!-- Begin Sysvinit dependency info -->
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Tar dependency info -->
@y
<!-- Begin Tar dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Tcl dependency info -->
@y
<!-- Begin Tcl dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Texinfo dependency info -->
@y
<!-- Begin Texinfo dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Eudev dependency info -->
@y
<!-- Begin Eudev dependency info -->
@z
@x
          <seg>No test suite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Util-linux dependency info -->
@y
<!-- Begin Util-linux dependency info -->
@z
@x
          <seg>No testsuite available</seg>
@y
          <seg>テストスイートはありません</seg>
@z

@x
<!-- Begin Vim dependency info -->
@y
<!-- Begin Vim dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin XZ Utils dependency info -->
@y
<!-- Begin XZ Utils dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z

@x
<!-- Begin Zlib dependency info -->
@y
<!-- Begin Zlib dependency info -->
@z
@x
          <seg>None</seg>
@y
          <seg>&None;</seg>
@z