%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Making the CLFS System Bootable</title>
@y
  <title>CLFS システムのブート設定</title>
@z

@x
  <secondary>configuring</secondary></indexterm>
@y
  <secondary>設定</secondary></indexterm>
@z

@x
  <para os="a">Your shiny new CLFS system is almost complete. One of the last
  things to do is to ensure that the system can be properly booted. The
  instructions below apply only to NewWorld Macintoshes.</para>
@y
  <para os="a">
  輝かしいあなたの CLFS システムはあと少しで完成です。
  ここですべきことはまず、システムを適切に起動できるようにすることです。
  これ以降に示す手順は NewWorld Macintosh コンピューター向けのものです。
  </para>
@z

@x
  <para os="b">Boot loading can be a complex area, so a few cautionary words
  are in order. Be familiar with the current boot loader and any other
  operating systems present on the hard drive(s) that need to be bootable.
  Make sure that an emergency CD is ready to <quote>rescue</quote> the
  computer if it becomes un-bootable.  It is also a good idea to enable booting
  from Open Firmware in case things go really wrong.</para>
@y
  <para os="b">
  ブートローディングというものは複雑に入り組んでいます。
  そこで注意すべき点を順に説明していきます。
  ご自身が現時点で利用しているブートローダーが何であるのか、あるいはブートを必要とする他のオペレーティングシステムがハードドライブに存在しているかどうかについては、よく確認しておいてください。
  またコンピューターが利用不能に (ブート不能に)
  なってしまうことに備えて、コンピューターを<quote>復旧 (resucue)</quote>するブートディスクの生成も忘れないでください。
  さらに最悪の場合であっても Open Firmware により起動可能な状態としておくことが必要でしょう。
  </para>
@z

@x
  <para os="c">Earlier, we compiled and installed the yaboot boot loader software
  in preparation for this step. The procedure involves writing the bootloader
  to a bootstrap partition and blessing it so that Open Firmware will boot from
  it.  This is all handled by <command>ybin</command>, the yaboot installer.</para>
@y
  <para os="c">
  ここまでに yaboot ブートローダーをビルドしてインストールしました。
  ここでこれを利用します。
  ブートストラップパーティションにブートローダーを書き込み初期化を行い、これによって Open Firmware によるブートを可能にします。
  これはすべて yaboot インストーラーである <command>ybin</command> が行います。
  </para>
@z

@x
  <para os="d">Ybin writes an optional 'OS selector' menu into Open Firmware,
  then writes yaboot and <filename>yaboot.conf</filename> to the bootstrap
  partition, blesses this, and updates the boot device recorded in nvram. When
  booted, the OF provides the initial menu to choose between linux, boot from
  CD, and e.g. OSX (depending on what was in <filename>yaboot.conf</filename>).
  If you boot to 'linux', yaboot is executed and lets you select which kernel
  to use.</para>
@y
  <para os="d">
  Ybin は Open Firmware に 'OS selector' メニューを追加し、yaboot と <filename>yaboot.conf</filename> をブートストラップパーティションに書き込んで初期化します。
  また NVRAM に保存されているブートデバイスを更新します。
  再起動すると起動メニューとして Linux、CDブート、そして OSX が (<filename>yaboot.conf</filename> に設定していれば) 表示されます。
  そこで Linux を選択すれば、yaboot が実行され Linux カーネルが実行されます。
  </para>
@z

@x
  <para os="e">Images (kernels) are specified, together with any necessary path,
  in <filename>yaboot.conf</filename> - the details are incorporated into the
  bootloader, but no attempt is made to access or validate the paths until
  they are selected. There are many possible options that can be specified in
  <filename>yaboot.conf</filename>, see the man page for the details. Most
  people will be able to specify device=hd: (for a single hard disk), but if
  you have multiple disks, or if you wish to be pedantic, you can specify the
  full OF path to the device, obtained by running <command>ofpath /dev/hdX</command>
  .</para>
@y
  <para os="e">
  カーネルイメージや種々のパスについての情報が <filename>yaboot.conf</filename> に指定され、それらはブートローダーに組み込まれます。
  ただ実際に稼動してみるまでは種々のパスへのアクセスやその検証ができていないわけです。
  <filename>yaboot.conf</filename> に指定できるオプションは実に多くあります。
  詳細は man ページを参照してください。
  単一のハードディスクを利用する場合は device=hd: という指定を行ないます。
  複数ハードディスクを利用する場合や詳しく調べようとする場合には、デバイスに対しての Open Firmware フルパスを指定する方法もあります。
  そのパスは <command>ofpath /dev/hdX</command> を実行して得ます。
  </para>
@z

@x
  <para os="h">Using the above information, determine the appropriate designators
  for the bootstrap partition and the root partition. For the following example,
  it is assumed that the bootstrap partition is <filename class="partition">hda2
  </filename> and the root partition is <filename class="partition">hda7</filename>.
  We will also assume that you wish to be able to boot an OSX installation on
  <filename class="partition">hda4</filename>. Change these items as necessary
  for your machine.</para>
@y
  <para os="h">
  上記の情報からブートストラップパーティションおよびルートパーティションの指定子を決定してください。
  以下に示す例はブートストラップパーティションを <filename class="partition">hda2</filename>、ルートパーティションを <filename
  class="partition">hda7</filename> としています。
  また OSX がブートできるパーティションを <filename class="partition">hda4</filename> とします。
  これらの設定は実状にそくして適切に書き換えてください。
  </para>
@z

@x
  <para os="i">If your machine has a SATA disk, specify the partitions using
  <filename class="devicefile">/dev/sda7</filename> and so forth in the usual
  way. At least some of the distros specify a full OF path to the 'device' and
  to the image(s), such as
  <parameter>device=/ht@0,f2000000/pci@3/k2-sata-root@c/k2-sata@0/disk@0:</parameter>
  for the disk, and
  <parameter>image=/ht@0,f2000000/pci@3/k2-sata-root@c/k2-sata@0/disk@0:9,/boot/clfskernel-&linux-version2;</parameter>
  which definitely works.</para>
@y
  <para os="i">
  SATA ディスクを利用している場合は <filename
  class="devicefile">/dev/sda7</filename> といった指定を行うことになります。
  ディストリビューションによってはデバイスやカーネルイメージに対して Open Firmware のフルパスを指定しているものもあります。
  例えばデバイスに対して <parameter>device=/ht@0,f2000000/pci@3/k2-sata-root@c/k2-sata@0/disk@0:</parameter>、カーネルイメージに対して <parameter>image=/ht@0,f2000000/pci@3/k2-sata-root@c/k2-sata@0/disk@0:9,/boot/clfskernel-&linux-version2;</parameter> といった具合です。
  こうすれば確実に動作します。
  </para>
@z

@x
  <para os="k">Create a <quote>yaboot.conf</quote> file defining yaboot's boot
  menu:</para>
@y
  <para os="k">
  yaboot のブートメニューを定義する <filename>yaboot.conf</filename> ファイルを生成します。
  </para>
@z

@x
  <para os="n">Add an entry for the host distribution, if you have one. It might
  look something like this if the kernel and initrd are in the host's '/'
  directory on <filename class="partition">hda6</filename>:</para>
@y
  <para os="n">
  ホストディストリビューションの項目も必要であればそれを追加します。
  カーネルや initrd が <filename class="partition">hda6</filename> ファイルシステム上の '/' ディレクトリにあるとすると、以下のようになります。
  </para>
@z

@x
    <para>The following command will update the bootstrap partition and the
    boot variable in Open Firmware. Do not run the command if this is not
    desired.</para>
@y
    <para>
    以下のコマンドはブートストラップパーティションおよび Open Firmware のブート変数を書き換えます。
    上書きするのが不適当であるならコマンドを実行しないでください。
    </para>
@z

@x
  <para os="t">Alternatively, if the bootstrap partition has not already been
  initialized, perhaps because you are using a Live CD, you will need to use
  a different command to install the bootloader for the first time:</para>
@y
  <para os="t">
  もう一つのやり方があります。
  例えば Live CD を用いている際には、まだブートストラップパーティションを初期化していないかもしれません。
  この場合には以下のコマンドを実行すれば、ブートローダーをインストールすることができます。
  </para>
@z