%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Before Entering the Chroot Environment</title>
@y
  <title>chroot 環境に入る前に</title>
@z

@x
    <title>Determining if steps need to be taken</title>
@y
    <title>この作業が必要かどうか</title>
@z

@x
    <para>Before we can enter the chroot we have to make sure that the system is
    in the proper state. From this point on the <envar>${CLFS_TARGET}</envar>
    environment variable will no longer exist, so it will have no bearing on the
    rest of the book - most packages will rely on
    <command>config.guess</command> provided by
    <xref linkend="ch-system-automake"/>. Packages that do not use autotools
    either do not care about the target triplet, or have their own means
    of determining its value.</para>
@y
    <para>
    chroot 環境に入る前に、システムが適正な状態にあるかを確認する必要があります。
    これ以降において環境変数 <envar>${CLFS_TARGET}</envar> は設定しません。
    つまりこの変数は残りの作業において意味がありません。
    各パッケージは <xref linkend="ch-system-automake"/> が提供する <command>config.guess</command> に頼ることになります。
    autotools を用いていないパッケージはターゲットの三つ組 (target triplet) を考慮しませんし、それを決定する手段も持ちません。
    </para>
@z

@x
    <para>In both cases, the information about the host cpu used to determine
    the target triplet is gathered from the same place,
    <command>uname -m</command>. Executing this command outside of the chroot
    as well as inside the chroot will have the exact same output.</para>
@y
    <para>
    ターゲットの三つ組の決定に用いられるホスト CPU の情報はいずれにせよ <command>uname -m</command> により得られます。
    このコマンドの実行は chroot 環境内でもそうでなくても全く同じ出力となります。
    </para>
@z

@x
   <para>If you're unsure if your host and target have the same target
    triplet, you can use this test to determine what the host's target triplet
    is and if you need to take any steps to ensure that you don't build for the
    wrong architecture. Extract the <xref linkend="ch-system-automake"/> tarball
    and <command>cd</command> into the created directory. Then execute the
    following to see what the detected target triplet is by
    <command>config.guess</command>:</para>
@y
   <!--
   日本語訳註： matsuand
   "誤っているかどうかを確認" 部分は、実は原文はそう語っていない。
   ただ原文の語りをそのまま訳すことは諦め、現状訳とした。
   -->
   <para>
    ホストとターゲットのターゲット三つ組が何であるのか不明な場合には、ここに示す確認方法をとってください。
    これを行えばターゲットの三つ組が確認できますし、誤っているかどうかを確認することができます。
    <xref linkend="ch-system-automake"/> の tarball を伸張 (解凍) して <command>cd</command> により生成されたディレクトリに移動します。
    そして以下のコマンドを実行することで <command>config.guess</command> によって検出されるターゲット三つ組を確認できます。
    </para>
@z

@x
    <para>If the output of that command does not equal what is in
    <envar>${CLFS_TARGET}</envar> then you need to read on. If it does then you
    can safely continue onto <xref linkend="ch-chroot-chroot"/>.</para>
@y
    <para>
    上のコマンドの出力が <envar>${CLFS_TARGET}</envar> の内容と一致しなかった場合は、以降の説明に進んでください。
    逆に一致した場合、問題がないため <xref linkend="ch-chroot-chroot"/> に進んでください。
    </para>
@z

@x
    <title>Using Setarch</title>
@y
    <title>Setarch の利用</title>
@z

@x
    <para>If your host has a tool called <command>setarch</command>, this may
    solve your problems, at least if you're building for i686. On an
    architecture such as x86_64, using
    <command>setarch linux32 uname -m</command> will only
    ever output i686. It is not possible to get an output of i486 or i586.</para>
@y
    <para>
    ホストシステムに <command>setarch</command> があると、少なくとも i686 向けのビルド時には問題が解消されます。
    例えばアーキテクチャーが x86_64 である場合に <command>setarch linux32 uname -m</command> を実行すると、出力結果は i686 です。
    これに従う場合、i486、i586 を得ることはできません。
    </para>
@z

@x
    <para>To test if setarch does everything you need it to, execute the
    following command from inside the <xref linkend="ch-system-automake"/>
    directory:</para>
@y
    <para>
    setarch によって十分に対応できるかどうかは <xref
    linkend="ch-system-automake"/> のディレクトリ内で以下のコマンドを実行して確認することができます。
    </para>
@z

@x
    <para>If the output of the command above equals what is in
    <envar>${CLFS_TARGET}</envar> then you have a viable solution. You can
    wrap the chroot command on the next page with
    <command>setarch linux32</command>. It will look like the following:</para>
@y
    <para>
    上のコマンドの出力が <envar>${CLFS_TARGET}</envar> の内容と一致した場合は、ここで解決です。
    次ページに示す chroot コマンドの先頭に <command>setarch linux32</command> をつけて進んでください。
    それは以下のようにコマンド実行をすることです。
    </para>
@z

@x
    <para>If setarch works for you then you can safely continue onto
    <xref linkend="ch-chroot-chroot"/>. If not, there is one more option
    covered in this book.</para>
@y
    <para>
    setarch がうまく動作したら、これより問題なく <xref linkend="ch-chroot-chroot"/> に進んでください。
    問題があったら次の方法に進んでください。
    </para>
@z

@x
    <title>Using a Uname Hack</title>
@y
    <title>Uname Hack の利用</title>
@z

@x
    <para os="uua">The Uname Hack is a kernel module that modifies the output of
    <command>uname -m</command> by directly changing the value of the
    detected machine type. The kernel module will save the original value
    and restore it when the module is unloaded.</para>
@y
    <para os="uua">
    Uname Hack はカーネルモジュールであり <command>uname -m</command> の出力を修正します。
    これは検出されたマシンタイプの値を直接変更するものです。
    カーネルモジュールは元々の値を保存しているため、モジュールがアンロードされた際には元の値を復元します。
    </para>
@z

@x
        <term>Uname Hack (&uname_hack-version;) - &uname_hack-size;:</term>
@y
        <term>Uname Hack (&uname_hack-version;) - &uname_hack-size;:</term>
@z

@x
          <para>Home page: <ulink url="&uname_hack-home;"/></para>
          <para>Download: <ulink url="&uname_hack-url;"/></para>
@y
          <para>&Homepage;: <ulink url="&uname_hack-home;"/></para>
          <para>&Download;: <ulink url="&uname_hack-url;"/></para>
@z

@x
    <para os="uuc">Extract the tarball and <command>cd</command> into the
    created directory. To build the Uname Hack you must have the kernel sources
    for your currently running kernel available. Build the Uname Hack with the
    following or similar command:</para>
@y
    <para os="uuc">
    tarball を伸張 (解凍) し <command>cd</command> により生成されたディレクトリに移動します。
    Uname Hack をビルドするには、現在稼動しているカーネルのソースが必要になります。
    以下のようなコマンドを実行して Uname Hack をビルドします。
    </para>
@z

@x
      <title>The meaning of the make and install options:</title>
@y
      <title>&MeaningOfOption1;make と install &MeaningOfOption2;</title>
@z

@x uname_hack_fake_machine=i486
          <para>This parameter sets the value that the uts machine type will be
          changed to. Alternatively this could be set to i586 or i686.</para>
@y
          <para>
          このパラメーターは uts マシンタイプとして指定する値を与えます。
          この他に i586、i686 という値もあります。
          </para>
@z

@x
    <para os="uuf">In the top level directory of the Uname Hack package you
    should see a file named <filename>uname_hack.ko</filename>. As soon as
    that module is loaded into the running kernel the output of
    <command>uname -m</command> will be affected immediately system-wide.
    Load the kernel module with the following command:</para>
@y
    <para os="uuf">
    Uname Hack パッケージのトップディレクトリに <filename>uname_hack.ko</filename> が生成されます。
    稼動しているカーネルに対してこのモジュールをロードすれば <command>uname -m</command> の出力結果が即反映されます。
    以下のコマンドを実行してカーネルモジュールをロードします。
    </para>
@z

@x
    <para os="uuh">To test if the Uname Hack is working properly, execute the
    following command from inside the <xref linkend="ch-system-automake"/>
    directory:</para>
@y
    <para os="uuh">
    Uname Hack が正常動作していることをテストする場合は <xref
    linkend="ch-system-automake"/> のディレクトリ内にて以下のコマンドを実行します。
    </para>
@z

@x
    <para os="uuj">The output of the above command should be the same as the
    <envar>${CLFS_TARGET}</envar> environment variable. If this is not the
    case, you can try and get help on the CLFS Support Mailing List or the
    IRC Channel. See <xref linkend="ch-intro-askforhelp"/> for more
    information.</para>
@y
    <para os="uuj">
    上のコマンドの出力は環境変数 <envar>${CLFS_TARGET}</envar> の内容と同じになるはずです。
    もしそうならなかったら、CLFS サポートメーリングリストや IRC チャネルにお問い合わせください。
    詳しくは <xref linkend="ch-intro-askforhelp"/> を参照してください。
    </para>
@z