%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Setting The ${CLFS} Variable</title>
@y
  <title>変数 ${CLFS} の設定</title>
@z

@x
  <para>Throughout this book, the environment variable <envar>CLFS</envar> will
  be used several times. You should ensure that this variable is always defined
  throughout the CLFS build process. It should be set to the name of the
  directory where you will be building your CLFS system - we will use
  <filename class="directory">/mnt/clfs</filename> as an example, but the
  directory choice is up to you. If you are building CLFS on a separate
  partition, this directory will be the mount point for the partition.
  Choose a directory location and set the variable with the
  following command:</para>
@y
  <para>
  本書の中では環境変数 <envar>CLFS</envar> を何度も用います。
  CLFS システムのビルド作業時には常に定義しておくことを忘れないでください。
  この変数は CLFS システムをビルドするディレクトリ名を設定します。
  例えば <filename class="directory">/mnt/clfs</filename> というものを用います。 
  他のものとしても構いません。
  CLFS を別のパーティションにビルドする場合、このマウントポイントはそのパーティションを示すようにしてください。
  ディレクトリを取り決めたら、変数を以下のコマンドにより設定します。
  </para>
@z

@x
  <para>Having this variable set is beneficial in that commands such as
  <command>install -dv ${CLFS}/tools</command> can be typed literally. The shell
  will automatically replace <quote>${CLFS}</quote> with
  <quote>/mnt/clfs</quote> (or whatever the variable was set to) when it
  processes the command line.</para>
@y
  <para>
  上のように変数を定義しておくと、例えば <command>install -dv ${CLFS}/tools</command> といったコマンドを、この通りに入力することで実行できるので便利です。
  これが実行されると、シェルが "${CLFS}" を "/mnt/lfs" に (あるいは変数にセットされている別のディレクトリに) 置換して処理してくれます。
  </para>
@z

@x
  <para>Do not forget to check that <envar>${CLFS}</envar> is set whenever
  you leave and reenter the current working environment (such as when doing a
  <command>su</command> to <systemitem class="username">root</systemitem> or
  another user). Check that the <envar>CLFS</envar> variable is set up
  properly with:</para>
@y
  <para>
  <envar>${CLFS}</envar> が常にセットされていることを忘れずに確認してください。
  特に、別ユーザーでログインし直した場合 (<command>su</command> コマンドによって <systemitem
  class="username">root</systemitem> ユーザーや別のユーザーでログインした場合) には、忘れずに確認してください。
  </para>
@z

@x
  <para>Make sure the output shows the path to your CLFS system's build
  location, which is <filename class="directory">/mnt/clfs</filename> if the
  provided example was followed. If the output is incorrect, use the command
  given earlier on this  page to set <envar>${CLFS}</envar> to the correct
  directory name.</para>
@y
  <para>
  上の出力結果が CLFS システムのビルドディレクトリであることを確認してください。
  本書に示す例に従っている場合は <filename class="directory">/mnt/clfs</filename> が表示されるはずです。
  出力が正しくない場合は、冒頭に示したコマンド実行により <envar>${CLFS}</envar> 変数に正しいディレクトリを設定してください。
  </para>
@z