%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
<appendix id="appendixe" xreflabel="Appendix E">
@y
<appendix id="appendixe" xreflabel="付録E">
@z

@x
  <title>Open Firmware and Mac issues.</title>
@y
  <title>Open Firmware と Mac の問題</title>
@z

@x
    <para>This appendix documents some of the features of ppc macintoshes,
    and in particular the requirements of coexisting with Mac OS's (OSX or
    the old OS9).  It is only relevant to NewWorld hardware.</para>
@y
    <para>
    この付録では PPC Macintosh の機能性に関して記します。
    特に Mac OS (OSX やかつての OS9) に共通する必要事項です。
    中でも NewWorld ハードウェアについてのみ示します。
    </para>
@z

@x
      <term><emphasis role="bold">Open Firmware and blessed partitions</emphasis></term>
@y
      <term><emphasis role="bold">Open Firmware と 起動パーティション</emphasis></term>
@z

@x
        <para>The Open Firmware (OF) is the code in ROM or nvram which controls
        how the machine boots.  If booting automatically, it will boot from the
        first valid blessed partition it finds (this is a simplification,
        but it is adequate for normal purposes).</para>
@y
        <para>
        Open Firmware (OF) は ROM あるいは NVRAM 内にあるコードでありマシン起動を制御するものです。
        自動起動が行われた場合、見出された最初の初期化済み (blessed) パーティションが起動します。
        (これは話を単純化していますが、通常であればこの説明で十分です。)
        </para>
@z

@x
        <para>It can only read apple filesystems (hfs, hfs+, or hfsx depending
        on the version of the firmware).  For disks under linux, the blessing
        is done by ybin when it installs yaboot (the loader) and yaboot.conf.</para>
@y
        <para>
        そこではファームウェアのバージョンにもよりますが、Apple ファイルシステム (hfs, hfs+, hfsx) のみが読み込まれます。
        Linux 上では ybin を使ってディスクの初期化を行います。
        ybin による初期化の際にはブートローダーである yaboot と yaboot.conf がインストールされます。
        </para>
@z

@x
        <para>Mac OS's have a tendency to look at other hfs{,+,x} filesystems
        on the disk, and unbless them if they do not match their expectations.
        Unblessing makes them unbootable. Fortunately, a filesystem of type
        <literal>Apple_Bootstrap</literal> can be read as hfs by the OF, but will
        be ignored by Mac OS.</para>
@y
        <para>
        Mac OS は hfs{,+,x} 以外のファイルシステムも調べにいきます。
        そして非対応のファイルシステムである場合、それを未初期化 (unbless) します。
        未初期化するということは起動できなくなるわけです。
        <literal>Apple_Bootstrap</literal> というタイプのファイルシステムは Open Firmware により hfs ファイルシステムとして読み込みが可能であり、幸いこれは Mac OS からは無視されます。
        </para>
@z

@x
      <term><emphasis role="bold">Partitioning</emphasis></term>
@y
      <term><emphasis role="bold">パーティショニング</emphasis></term>
@z

@x
        <para>Macintoshes use their own partition format - this means that other
        machines are unlikely to be able to read or write to macintosh partitions
        (in particular, fdisk does not understand them). The format allows a large
        number of individual partitions, and the native Mac tools had a tendency
        to insert small "filler" partitions between the real partitions. Under
        linux, using more than 15 partitions can be problematic (shortage of device
        nodes), so the normal approach is to use the Mac tools to create an area
        of freespace at the <emphasis>front</emphasis> of the disk, then put the
        Mac OS partition(s) after it and (re-)install the Mac OS.  The
        freespace can then be partitioned using <command>parted</command> or the
        older <command>mac-fdisk</command>.  It seems that recent versions of the
        Mac tools may no longer insert the filler partitions, so it may be
        possible to do all the partitioning before installing OSX.</para>
@y
        <para>
        Macintosh では独自のパーティションフォーマットが用いられます。
        これはつまり他のマシンは Macintosh パーティションの読み書きができない可能性が高いということです。
        (特に fdisk は Macintosh パーティションに対応していません。)
        その独自フォーマットでは数多くのパーティションが生成可能です。
        そしてネイティブな Mac ツールは個々の実質的なパーティションの間に "フィラー (filler)" パーティションを挿入します。
        そもそも Linux では (デバイスノードの弱点として) 16パーティション以上を生成することには問題があります。
        そこで普通に取られる方法としては Mac ツールを利用してフリーな領域をディスクの<emphasis>先頭</emphasis> に作ります。
        そして Max OS パーティションはその後ろに置き、Mac OS を(再)インストールします。
        フリーな領域は <command>parted</command> コマンドか古い <command>mac-fdisk</command> コマンドを使ってパーティショニングします。
        Mac ツールの最新バージョンでは "フィラー" パーティションは挿入しなくなったようです。
        したがって OSX インストール前であればパーティショニングは問題なくできると思われます。
        </para>
@z

@x
        <para>The Macintosh resizing and partitioning tools are destructive and may
        delete all data when a partition is resized, even on unaltered partitions.
        </para>
@y
        <para>
        Macintosh のパーティショニングツールは正常動作しませんから注意してください。
        パーティションリサイズ時にデータをすべて失う可能性があり、しかも指定していないパーティションまで消失してしまう可能性があります。
        </para>
@z

@x
        <para>For the Linux partitions, you will need a bootstrap partition - this
        can normally be a mere 800KB in size (the smallest hfs partition available)
        although the Fedora installer  has been known to insist on 800MB.  This has
        to be in front of the Mac OS partition.  The bootstrap is
        <emphasis>never</emphasis> mounted as a regular partition and should not
        be confused with a <literal>/boot</literal> partition.  Other partitions
        are as normal (at least one rootfs, perhaps swap, perhaps others).</para>
@y
        <para>
        Linux パーティションとしてブートストラップパーティションが必要になります。
        そのサイズは 800 KB という少なさで十分です。
        (hfs パーティションの最低サイズです。)
        ただし Fedora のインストーラーを用いると 800MB が生成されてしまいます。
        このパーティションは Mac OS パーティションよりも前に生成します。
        ブートストラップパーティションは通常のパーティションのようにマウントしては<emphasis>なりません</emphasis>。
        さらに <literal>/boot</literal> パーティションとは混同しないように注意してください。
        その他のパーティションは普通に生成してください。
        (少なくともその一つはルートファイルシステムであり、スワップパーティションやその他のパーティションを生成してください。)
        </para>
@z

@x
        <para>According to the lfs-from-osx hint, the Mac partitioning tools
        can create an apple_bootstrap partition and therefore there is no need
        to use a Linux CD to create the desired partitions from freespace, but
        using a Linux CD to create the partitions is a more widely tested approach.
        </para>
@y
        <para>
        lfs-from-osx というヒントによると、Mac パーティショニングツールを使って apple_bootstrap パーティションを生成することができるそうです。
        そうであればフリー領域に望みのパーティションを作成する作業は Linux CD を用いなくてもできることになります。
        しかし Linux CD を用いた方法は幅広くテストされている手法です。
        </para>
@z

@x
        <para>If you follow this approach, partition 1 will be the apple partition
        map, partition 2 will be the bootstrap at the start of the disk, the
        linux partitions will follow, and then the mac partition(s) - under OSX
        the first mac partition will be number 3, under OS9 it would have a higher
        number and there would be some apple driver partitions.</para>
@y
        <!--
        日本語訳註： matsuand
        パーティション番号のくだり、よく分からず^^;
        -->
        <para>
        その方法で進むのであればパーティション1は apple パーティションマップ、パーティション2はブートストラップ、それ以降に Linux パーティションと Mac パーティションが続くことになります。
        OSX 上では最初の Mac パーティションは番号3であり OS9 上ではそれ以上の番号となります。
        そしてその番号は Apple ドライバーのパーティションかもしれません。
        </para>
@z

@x
      <term><emphasis role="bold">OSX or OF upgrades</emphasis></term>
@y
      <term><emphasis role="bold">OSX または Open Firmware のアップグレード</emphasis></term>
@z

@x
        <para>If the machine is dual-booted with OSX, the mac kernel or the OF
        will probably be upgraded at some point.  This appears to either unbless
        the bootstrap,        or else just point the OF boot device to the mac partition
        - so, the linux system will no longer be bootable.</para>
@y
        <para>
        システム内にデュアルブートにより OSX を導入している場合、時に Mac カーネルや Open Firmware を更新することも発生するでしょう。
        その際にはブートストラップが未初期化 (unbless) の状態になったり、Open Firmware のブートデバイスが Mac パーティションに切り替わったりしてしまうかもしれません。
        そうなると Linux システムが起動できなくなります。
        </para>
@z

@x
        <para>Therefore, you will need to know which partition contains the bootstrap
        so that you can boot it from OF (on an apple keyboard, hold down
        option-command-o-f (that is, alt-apple-o-f) while booting then enter a
        command like:</para>
@y
        <para>
        そこでブートストラップパーティションがどこにあるかを覚えておくことが必要です。
        起動直後に Apple キーボード上にて Option + Command + o + f (Alt + Apple + o + f) を長押しして Open Firmware を起動させ以下のようなコマンドを実行します。
        </para>
@z

@x
        <para>This will allow you to select a linux boot, and from there you
        will have to rerun <command>ybin</command>.</para>
@y
        <para>
        これによって Linux 起動を選べるようになりますので、そこで <command>ybin</command> を再実行する必要があります。
        </para>
@z

@x
        <para>The "OS chooser" menu that yaboot typically loads is stored in the
        OF and will not be available after a Mac kernel or firmware upgrade until
        <command>ybin</command> has been rerun.</para>
@y
        <para>
        yaboot がロードする "OS 選択" メニューは Open Firmware 内に記録されています。
        ですから Mac カーネルやファームウェアがアップグレードされると <command>ybin</command> を再実行しない限り利用できなくなります。
        </para>
@z

@x
      <term><emphasis role="bold">Yaboot's requirements</emphasis></term>
@y
      <term><emphasis role="bold">Yaboot の必要事項</emphasis></term>
@z

@x
        <para>Yaboot is the boot loader for linux, sometimes referred to as
        the second stage loader.  It reads the yaboot.conf file on the bootstrap
        partition to find which linux system(s) should be available, and
        attempts to load the required kernel.</para>
@y
        <para>
        Yaboot は Linux 向けのブートローダーであり第二ステージローダーとして用いられることがあります。
        ブートストラップパーティションから yaboot.conf を読み込んで利用可能な Linux を探し出し、そのカーネルをロードします。
        </para>
@z

@x
        <para>The bootstrap man page warns that the path to the kernel should
        contain no more than one directory for reliability.</para>
@y
        <para>
        ブートスラップの man ページでは、カーネル指定は一つのディレクトリのみとすべきであることを示しています。
        </para>
@z

@x
        <para>Yaboot has to be able to understand the filesystem, so that it
        can find the kernel.  It understands hfs (not useful for linux, it is
        not case-sensitive), ext2 (and therefore it can read ext3), reiser3,
        and xfs.  If you want to use a different type of filesystem for '/'
        you will have to create a separate boot partition with a supported
        filesystem, and use that to hold the kernels.</para>
@y
        <para>
        Yaboot はカーネルを見つけ出すためにも、ファイルシステムの状況が分かっていなければなりません。
        対応するファイルシステムは hfs (Linux 向けではありません、大文字小文字はどちらでも)、ext2 (ext3 も可)、reiser3、xfs です。
        '/' (ルートパーティション) に別タイプのファイルシステムを用いるのであれば、まず対応ファイルシステムにより別のブートパーティションを設けてそこにカーネルを置く必要があります。
        </para>
@z

@x
      <term><emphasis role="bold">Requirements if starting from OSX</emphasis></term>
@y
      <term><emphasis role="bold">OSX から起動する際の必要事項</emphasis></term>
@z

@x
        <para>Older versions of OSX (panther, leopard) can write to ext2
        filesystems using version 1.3 of ext2fsx.  The upgrade to tiger broke
        this, and version 1.4 of ext2fsx only supports reading.  Users of
        current OSX will therefore have to find some other way of creating
        a suitable filesystem and populating it, such as a Live CD or rescue CD.
        </para>
@y
        <para>
        OSX のかつてのバージョン (panther, leopard) は ext2fsx バージョン 1.3 を用いて ext2 ファイルシステムを作り出すことができました。
        tiger へのアップグレードによりこれは出来なくなり ext2fsx のバージョン 1.4 は読み込むことだけがサポートされました。
        したがって現時点の OSX ユーザーは適切にファイルシステムを構築できるように別の方法を用いなければなりません。
        それが例えば Live CD やレスキュー CD を用いる方法です。
        </para>
@z