%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Prerequisites</title>
@y
  <title>必要な知識</title>
@z

@x
  <para>Building a CLFS system is not a simple task. It requires a certain
  level of existing knowledge of Unix system administration in order to
  resolve problems, and correctly execute the commands listed. In particular,
  as an absolute minimum, the reader should already have the ability to use
  the command line (shell) to copy or move files and directories, list
  directory and file contents, and change the current directory. It is also
  expected that the reader has a reasonable knowledge of using and installing
  Linux software. A basic knowledge of the architectures being used in
  the Cross LFS process and the host operating systems in use is also
  required.</para>
@y
  <para>
  CLFS システムの構築作業は決して単純なものではありません。
  ある程度の Unix システム管理の知識が必要です。
  問題を解決したり、説明されているコマンドを正しく実行することが求められます。
  ファイルやディレクトリのコピー、それらの表示確認、カレントディレクトリの変更、といったことは最低でも知っていなければなりません。
  さらに Linux の各種ソフトウェアを使ったりインストールしたりする知識が必要です。
  CLFS の作業においては CPU アーキテクチャーやホストオペレーティングシステムに対する基本的な知識も必要です。
  </para>
@z

@x
  <para>Because the CLFS book assumes <emphasis>at least</emphasis> this basic
  level of skill, the various CLFS support forums are unlikely to be able to
  provide you with much assistance in these areas. Your questions regarding
  such basic knowledge will likely go unanswered, or you will be referred to
  the CLFS essential pre-reading list.</para>
@y
  <para>
  CLFS ブックでは、<emphasis>最低でも</emphasis> そのようなスキルがあることを前提としていますので、数多くの CLFS サポートフォーラムは、ひょっとすると役に立たないかもしれません。
  フォーラムにおいて基本的な知識を尋ねたとしたら、誰も回答してくれないでしょう。
  そうするよりも CLFS に取り掛かる前に以下のような情報をよく読んでください。
  </para>
@z

@x
  <para>Before building a CLFS system, we recommend reading the following
  HOWTOs:</para>
@y
  <para>
  CLFS システムの構築作業に入る前に、以下のハウツーを読むことをお勧めします。
  </para>
@z

@x
      <para remap="verbatim">Software-Building-HOWTO
@y
      <para remap="verbatim">ソフトウェア構築のハウツー (Software-Building-HOWTO)
@z

@x
      <para>This is a comprehensive guide to building and installing
      <quote>generic</quote> Unix software distributions under Linux.</para>
@y
      <para>
      これは Linux 上において<quote>一般的な</quote> Unix ソフトウェアを構築してインストールする方法を総合的に説明しています。
      </para>
@z

@x
      <para remap="verbatim">The Linux Users' Guide
@y
      <para remap="verbatim">Linux ユーザーズガイド (The Linux Users' Guide)
@z

@x
      <para>This guide covers the usage of assorted Linux software.</para>
@y
      <para>
      このガイドは Linux の各種ソフトウェアの利用方法を網羅しています。
      </para>
@z

@x
      <para remap="verbatim">The Essential Pre-Reading Hint
@y
      <para remap="verbatim">基本的な事前ヒント情報 (The Essential Pre-Reading Hint)
@z

@x
      <para>This is a hint written specifically for users new to Linux.
      It includes a list of links to excellent sources of information on a
      wide range of topics. Anyone attempting to install CLFS should have an
      understanding of many of the topics in this hint.</para>
@y
      <para>
      これは Linux 初心者に向けて書かれたヒントです。
      ここには非常に多くの有用なトピックへのリンクがあります。
      CLFS を構築しようとするなら、これらのヒントに示されている内容は出来るだけ多く理解しておくことが必要でしょう。
      </para>
@z