%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Device and Module Handling on a CLFS System</title>
@y
  <title>デバイスとモジュールの扱いについて</title>
@z

@x
    <secondary>usage</secondary>
@y
    <secondary>利用方法</secondary>
@z

@x
  <para>In <xref linkend="chapter-building-system"/>, we installed Udev,
  as one of the components of systemd. Before we go into the details regarding
  how this works, a brief history of previous methods of handling devices is in
  order.</para>
@y
  <para>
  <xref linkend="chapter-building-system"/>にて systemd のコンポーネントの一部として Udev パッケージをインストールしました。
  このパッケージがどのように動作するかの詳細を説明する前に、デバイスを取り扱うかつての方法について順を追って説明していきます。
  </para>
@z

@x
    <title>History</title>
@y
    <title>開発経緯</title>
@z

@x
      <title>Static Device Nodes</title>
@y
      <title>スタティックデバイスノード</title>
@z

@x
      <para>Linux systems in general traditionally use a static device creation
      method, whereby a great many device nodes are created under <filename
      class="directory">/dev</filename> (sometimes literally thousands of
      nodes), regardless of whether the corresponding hardware devices actually
      exist. This is typically done via a <command>MAKEDEV</command> script,
      which contains a number of calls to the <command>mknod</command> program
      with the relevant major and minor device numbers for every possible
      device that might exist in the world.</para>
@y
      <para>
      Linux システムは一般に、スタティックなデバイス生成方法を採用していました。
      この方法では <filename class="directory">/dev</filename> のもとに膨大な量の (場合によっては何千にもおよぶ) デバイスノードが生成されます。
      現実に存在するハードウェアデバイスが存在するかどうかに関わらずです。
      これは <command>MAKEDEV</command> スクリプトを通じて生成されます。
      このスクリプトからは <command>mknod</command> プログラムが呼び出されますが、その呼び出しは、この世に存在するありとあらゆるデバイスのメジャー/マイナー番号を用いて行われます。
      </para>
@z

@x
      <title>Devfs</title>
@y
      <title>Devfs ファイルシステム</title>
@z

@x
      <para>In February 2000, a new filesystem called <systemitem
      class="filesystem">devfs</systemitem>, which dynamically created device
      nodes as devices were found by the kernel, was merged into the
      2.3.46 kernel and was made available during the 2.4 series of stable
      kernels. Although it was present in the kernel source itself, this method
      of creating devices dynamically never received overwhelming support from
      the core kernel developers.</para>
@y
      <para>
      2000年2月に新しいファイルシステム <systemitem
      class="filesystem">devfs</systemitem> がカーネル 2.3.46 に導入され、2.4系の安定版カーネルにて利用できるようになりました。
      このファイルシステムはカーネルのソース内に含まれ実現されていましたが、デバイスを動的に生成するこの手法は、主要なカーネル開発者の十分な支援は得られませんでした。
      </para>
@z

@x
      <para>The main problem with the approach adopted by <systemitem
      class="filesystem">devfs</systemitem> was the way it handled device
      detection, creation, and naming. The latter issue, that of device node
      naming, was perhaps the most critical. It is generally accepted that if
      device names are allowed to be configurable, then the device naming policy
      should be up to a system administrator, not imposed on them by any
      particular developer(s). The <systemitem
      class="filesystem">devfs</systemitem> file system also suffered from race
      conditions that were inherent in its design and could not be fixed without
      a substantial revision to the kernel. It was marked deprecated with the
      release of the 2.6 kernel series, and was removed entirely as of version
      2.6.18.</para>
@y
      <para>
      <systemitem class="filesystem">devfs</systemitem> が採用した手法で問題になるのは、主にデバイスの検出、生成、命名の方法です。
      特にデバイスの命名方法がおそらく最も重大な問題です。
      一般的に言えることとして、デバイス名が変更可能であるならデバイス命名の規則はシステム管理者が考えることであって、特定の開発者に委ねるべきことではありません。
      また <systemitem class="filesystem">devfs</systemitem> にはその設計に起因した競合の問題があるため、根本的にカーネルを修正しなければ解消できる問題ではありません。
      そこでカーネル 2.6 系において保守されることがなかったために非推奨 (deprecated) として位置づけられ、最終的にカーネル 2.6.18 から取り除かれました。
      </para>
@z

@x
      <title>Sysfs</title>
@y
      <title>Sysfs ファイルシステム</title>
@z

@x
      <para>With the development of the unstable 2.5 kernel tree, later released
      as the 2.6 series of stable kernels, a new virtual filesystem called
      <systemitem class="filesystem">sysfs</systemitem> came to be. The job of
      <systemitem class="filesystem">sysfs</systemitem> is to export a view of
      the system's hardware configuration to userspace processes. Drivers that
      have been compiled into the kernel directly register their objects with
      <systemitem class="filesystem">sysfs</systemitem> as they are detected by
      the kernel. For drivers compiled as modules, this registration will happen
      when the module is loaded. Once the <systemitem
      class="filesystem">sysfs</systemitem> filesystem is mounted (on <filename
      class="directory">/sys</filename>), data which the built-in drivers
      registered with <systemitem class="filesystem">sysfs</systemitem> are
      available to userspace processes. With this userspace-visible
      representation, the possibility of seeing a userspace replacement for
      <systemitem class="filesystem">devfs</systemitem> became much more
      realistic.</para>
@y
      <para>
      開発版の 2.5 系カーネルと、後にリリースされた安定版のカーネル 2.6 系を経て、新しい仮想ファイルシステム <systemitem
      class="filesystem">sysfs</systemitem> が登場しました。
      <systemitem class="filesystem">sysfs</systemitem> が実現したのは、システムのハードウェア設定をユーザー空間のプロセスとして表に出したことです。
      カーネルに直接組み込まれて構築されたドライバーの場合は、対象のオブジェクトをカーネルが検出し、そのオブジェクトを <systemitem
      class="filesystem">sysfs</systemitem> に登録します。
      モジュールとしてコンパイルされたドライバーの場合は、その登録がモジュールのロード時に行われます。
      <systemitem class="filesystem">sysfs</systemitem> ファイルシステムが (<filename
      class="directory">/sys</filename> に) マウントされると、ドライバーによって <systemitem
      class="filesystem">sysfs</systemitem> に登録されたデータは、ユーザー空間のプロセスにて利用可能となります。
      ユーザー空間での設定を可視化したことによって <systemitem class="filesystem">devfs</systemitem> が為していたことを、ユーザー空間にて開発することが可能になったわけです。
      </para>
@z

@x
      <title>Udev Implementation</title>
@y
      <title>Udev の実装</title>
@z

@x
      <para>Shortly after the introduction of
      <systemitem class="filesystem">sysfs</systemitem>, work began on a
      program called Udev to advantage of it. The <command>udev</command>
      daemon made calls to <function>mknod()</function> to create device nodes
      in <filename class="directory">/dev</filename> dynamically, based on the
      information from <systemitem class="filesystem">sysfs</systemitem>, in
      <filename class="directory">/sys</filename>. For example,
      <filename>/sys/class/tty/vcs/dev</filename> contains the string
      <quote>7:0</quote>. This string was used by <command>udev</command>
      to create a device node with major number <emphasis>7</emphasis> and
      minor number <emphasis>0</emphasis>.</para>
@y
      <!--
      日本語訳註： matsuand
      daemon made calls... の made はなぜ過去形?
      -->
      <para>
      <systemitem class="filesystem">sysfs</systemitem> の概要を示しましたが、さっそくながら Udev の話に入ります。
      Udev には優位な特徴があります。
      <command>udev</command> デーモンが <function>mknod()</function> を呼び出すことによりファイルシステム <systemitem
      class="filesystem">sysfs</systemitem> の <filename
      class="directory">/sys</filename> ディレクトリにある情報に基づいて <filename
      class="directory">/dev</filename> 内に動的にデバイスノードを生成します。
      例えば <filename>/sys/class/tty/vcs/dev</filename> というファイルには<quote>7:0</quote>という文字列が含まれています。
      この文字列を <command>udev</command> が読み取り、メジャー番号 <emphasis>7</emphasis> 、マイナー番号 <emphasis>0</emphasis> のデバイスノードを生成します。
      </para>
@z

@x
      <para>Linux kernel version 2.6.32 introduced a new virtual file system
      called <systemitem class="filesystem">devtmpfs</systemitem>, an improved
      replacement for <systemitem class="filesystem">devfs</systemitem>. This
      allows device nodes to once again be dynamically created by the kernel,
      without many of the problems of
      <systemitem class="filesystem">devfs</systemitem>. As of version 176,
      Udev no longer creates device nodes itself, instead relying on
      <systemitem class="filesystem">devtmpfs</systemitem> to do so.</para>
@y
      <para>
      Linux カーネル 2.6.32 になって新たに仮想ファイルシステム <systemitem
      class="filesystem">devtmpfs</systemitem> が導入されました。
      これは <systemitem class="filesystem">devfs</systemitem> を改良したものです。
      これによって数々の <systemitem
      class="filesystem">devfs</systemitem> 上での問題は解消され、カーネルによって何度でもデバイスノードを再生成できるようにもなりました。
      Udev 176 以降、Udev はデバイスノード自体は生成しなくなり、<systemitem
      class="filesystem">devtmpfs</systemitem> がそれを行うようになりました。
      </para>
@z

@x
      <title>Systemd and Eudev</title>
@y
      <title>Systemd と Eudev</title>
@z

@x
        <para>In 2010, development began on systemd, an alternate
        <command>init</command> implementation. Starting with Udev 183, Udev's
        source tree was merged with systemd. Several Gentoo
        developers who disagreed with this merge announced a project fork
        called Eudev in December 2012, created by extracting the
        Udev code from systemd. One of the goals of Eudev is to allow for
        easier installation and usage of <command>udevd</command> without
        the need for the rest of systemd.</para>
@y
        <para>
        2010年になると systemd が開発されるようになりました。
        これは <command>init</command> に代わるものです。
        Udev 183 からは、そのソースが systemd にマージされます。
        Gentoo 開発者の中にこのマージに反対する方々がおり、2012年12月にプロジェクトをフォークして Eudev の開発に分かれました。
        そこでは Systemd から Udev のコード部分を抜き出して開発が進められています。
        Eudev の開発目標は <command>udevd</command> のインストールもその利用も簡易なものとすることです。
        そしてそれが Systemd の他の機能部分の助けを得ることなく実現できることです。
        </para>
@z

@x
    <title>Device Node Creation</title>
@y
    <title>デバイスノードの生成</title>
@z

@x
    <para>By default, device nodes created by the kernel in a
    <systemitem class="filesystem">devtmpfs</systemitem> are owned by
    <emphasis>root:root</emphasis> and have <emphasis>600</emphasis>
    permissions. <command>udevd</command> can modify ownership and permissions
    of the nodes under the <filename class="directory">/dev</filename>
    directory, and can also create additional symlinks, based on rules
    specified in the files within the
    <filename class="directory">/etc/udev/rules.d</filename>,
    <filename class="directory">/lib/udev/rules.d</filename>,
    and <filename class="directory">/run/udev/rules.d</filename> directories.
    The names for these files start with a number, to indicate the order in
    which they are run, and they have a <filename>.rules</filename>
    extension (<command>udevd</command> will ignore files with any other
    extension). All of the rules files from these directories are combined into
    a single list, sorted by filename, and run in that order. In the event of
    a conflict, where a rules file with the same name exists in two or more of
    these directories, the rules in <filename class="directory">/etc</filename>
    take the highest priority, followed by rules files in
    <filename class="directory">/run</filename>, and finally
    <filename class="directory">/lib</filename>. Any device for which a rule
    cannot be found will just be ignored by <command>udevd</command>
    and be left at the defaults defined by the kernel, as described above. For
    more details about writing Udev rules, see
    <filename><ulink url="/usr/share/doc/systemd-&systemd-version;/udev.html"/></filename>.</para>
@y
    <para>
    デバイスノードはカーネルにより <systemitem
    class="filesystem">devtmpfs</systemitem> ファイルシステム内に作り出されます。
    デフォルトでデバイスノードの所有者は <emphasis>root:root</emphasis> でありパーミッションは <emphasis>600</emphasis> です。
    <command>udevd</command> は <filename class="directory">/dev</filename> 内のノードについてその所有とパーミッションを変更できます。
    また <filename class="directory">/etc/udev/rules.d</filename>,
    <filename class="directory">/lib/udev/rules.d</filename>,
    <filename class="directory">/run/udev/rules.d</filename> の各ディレクトリ内にあるファイルが示す規則に基づいて、シンボリックリンクを追加することができます。
    この規則を示すファイルの名前は数字で始まります。
    その数値が実行順を表わします。
    そして <filename>.rules</filename> という拡張子を持ちます。
    (Udev はこれ以外の拡張子は無視します。)
    各ディレクトリ内のこの規則ファイルは名前順に並び替えられ一つのリストとして統合されて、その順に実行されます。
    上記ディレクトリのいずれかにて同一名称の規則ファイルが存在した場合は <filename
    class="directory">/etc</filename> にある規則ファイルが最優先に扱われます。
    次に <filename class="directory">/run</filename> にあるファイル、最後に <filename
    class="directory">/lib</filename> にあるファイルが採用されます。
    規則ファイルが見つからなかったデバイスは <command>udevd</command> が無視します。
    そして上に示したようにカーネルにより定義されたデフォルト値のままとなります。
    Udev の規則ファイルの記述方法の詳細については <filename><ulink
    url="/usr/share/doc/systemd-&systemd-version;/udev.html"/></filename> を参照してください。
    </para>
@z

@x
    <title>Module Loading</title>
@y
    <title>モジュールのロード</title>
@z

@x
    <para>Device drivers compiled as modules may have aliases built into them.
    Aliases are visible in the output of the <command>modinfo</command>
    program and are usually related to the bus-specific identifiers of devices
    supported by a module. For example, the <emphasis>snd-fm801</emphasis>
    driver supports PCI devices with vendor ID 0x1319 and device ID 0x0801,
    and has an alias of <quote>pci:v00001319d00000801sv*sd*bc04sc01i*</quote>.
    For most devices, the bus driver exports the alias of the driver that
    would handle the device via <systemitem
    class="filesystem">sysfs</systemitem>. E.g., the
    <filename>/sys/bus/pci/devices/0000:00:0d.0/modalias</filename> file
    might contain the string
    <quote>pci:v00001319d00000801sv00001319sd00001319bc04sc01i00</quote>.
    The default rules provided by Udev will cause <command>udevd</command>
    to call out to <command>/sbin/modprobe</command> with the contents of the
    <envar>MODALIAS</envar> uevent environment variable (that should be the
    same as the contents of the <filename>modalias</filename> file in sysfs),
    thus loading all modules whose aliases match this string after wildcard
    expansion.</para>
@y
    <para>
    モジュールとしてコンパイルされたデバイスドライバーの場合、デバイス名の別名が作り出されています。
    その別名は <command>modinfo</command> プログラムを使えば確認することができます。
    そしてこの別名は、モジュールがサポートするバス固有の識別子に関連づけられます。
    例えば <emphasis>snd-fm801</emphasis> ドライバーは、ベンダーID 0x1319 とデバイスID 0x0801 の PCI ドライバーをサポートします。
    そして<quote>pci:v00001319d00000801sv*sd*bc04sc01i*</quote>というエイリアスがあります。
    たいていのデバイスでは、<systemitem class="filesystem">sysfs</systemitem> を通じてドライバーがデバイスを扱うものであり、ドライバーのエイリアスをバスドライバーが提供します。
    <filename>/sys/bus/pci/devices/0000:00:0d.0/modalias</filename> ファイルならば<quote>pci:v00001319d00000801sv00001319sd00001319bc04sc01i00</quote>という文字列を含んでいるはずです。
    Udev が提供するデフォルトの生成規則によって <command>udevd</command> から <command>/sbin/modprobe</command> が呼び出されることになり、その際には uevent に関する環境変数 <envar>MODALIAS</envar> の設定内容が利用されます。
    (この環境変数の内容は sysfs 内の <filename>modalias</filename> ファイルの内容と同じはずです。)
    そしてワイルドカードが指定されているならそれが展開された上で、エイリアス文字列に合致するモジュールがすべてロードされることになります。
    </para>
@z

@x
    <para>In this example, this means that, in addition to
    <emphasis>snd-fm801</emphasis>, the obsolete (and unwanted)
    <emphasis>forte</emphasis> driver will be loaded if it is
    available. See below for ways in which the loading of unwanted drivers can
    be prevented.</para>
@y
    <para>
    上の例で <emphasis>forte</emphasis> ドライバーがあったとすると、<emphasis>snd-fm801</emphasis> の他にそれもロードされてしまいます。
    これは古いものでありロードされて欲しくないものです。
    不要なドライバーのロードを防ぐ方法については後述しているので参照してください。
    </para>
@z

@x
    <para>The kernel itself is also able to load modules for network
    protocols, filesystems and NLS support on demand.</para>
@y
    <para>
    カーネルは、ネットワークプロトコル、ファイルシステム、NLS サポートといった各種モジュールも、要求に応じてロードすることもできます。
    </para>
@z

@x
    <title>Problems with Loading Modules and Creating Devices</title>
@y
    <title>モジュールロードとデバイス生成の問題</title>
@z

@x
    <para>There are a few possible problems when it comes to automatically
    creating device nodes.</para>
@y
    <para>
    自動的にデバイスが生成される際には、いくつか問題が発生します。
    </para>
@z

@x
      <title>A kernel module is not loaded automatically</title>
@y
      <title>カーネルモジュールが自動的にロードされない問題</title>
@z

@x
      <para>Udev will only load a module if it has a bus-specific alias and the
      bus driver properly exports the necessary aliases to <systemitem
      class="filesystem">sysfs</systemitem>. In other cases, one should
      arrange module loading by other means. With Linux-&linux-version2;, Udev
      is known to load properly-written drivers for INPUT, IDE, PCI, USB, SCSI,
      SERIO and FireWire devices.</para>
@y
      <para>
      Udev がモジュールをロードできるためには、バス固有のエイリアスがあって、バスドライバーが <systemitem
      class="filesystem">sysfs</systemitem> に対して適切なエイリアスを提供していることが必要です。
      そうでない場合は、別の手段を通じてモジュールのロードを仕組まなければなりません。
      Linux-&linux-version2; においての Udev は、INPUT、IDE、PCI、USB、SCSI、SERIO、FireWire の各デバイスに対するドライバーをロードします。
      それらのデバイスドライバーが適切に構築されているからです。
      </para>
@z

@x
      <para>To determine if the device driver you require has the necessary
      support for Udev, run <command>modinfo</command> with the module name as
      the argument.  Now try locating the device directory under
      <filename class="directory">/sys/bus</filename> and check whether there is
      a <filename>modalias</filename> file there.</para>
@y
      <para>
      目的のデバイスドライバーが Udev に対応しているかどうかは、<command>modinfo</command> コマンドに引数としてモジュール名を与えて実行します。
      <filename class="directory">/sys/bus</filename> ディレクトリ配下にあるそのデバイス用のディレクトリを見つけ出して、<filename>modalias</filename> ファイルが存在しているかどうかを見ることで分かります。
      </para>
@z

@x
      <para>If the <filename>modalias</filename> file exists in <systemitem
      class="filesystem">sysfs</systemitem>, the driver supports the device and
      can talk to it directly, but doesn't have the alias, it is a bug in the
      driver. Load the driver without the help from Udev and expect the issue
      to be fixed later.</para>
@y
      <para>
      <systemitem class="filesystem">sysfs</systemitem> に <filename>modalias</filename> ファイルが存在しているなら、そのドライバーはデバイスをサポートし、デバイスとの直接のやり取りが可能であることを表します。
      ただしエイリアスを持っていなければ、それはドライバーのバグです。
      その場合は Udev に頼ることなくドライバーをロードするしかありません。
      そしてそのバグが解消されるのを待つしかありません。
      </para>
@z

@x
      <para>If there is no <filename>modalias</filename> file in the relevant
      directory under <filename class="directory">/sys/bus</filename>, this
      means that the kernel developers have not yet added modalias support to
      this bus type. With Linux-&linux-version2;, this is the
      case with ISA busses. Expect this issue to be fixed in later kernel
      versions.</para>
@y
      <para>
      <filename class="directory">/sys/bus</filename> ディレクトリ配下の対応するディレクトリ内に <filename>modalias</filename> ファイルがなかったら、これはカーネル開発者がそのバス形式に対する modalias のサポートをまだ行っていないことを意味します。
      Linux-&linux-version2; では ISA バスがこれに該当します。
      最新のカーネルにて解消されることを願うしかありません。
      </para>
@z

@x
      <para>Udev is not intended to load <quote>wrapper</quote> drivers such as
      <emphasis>snd-pcm-oss</emphasis> and non-hardware drivers such as
      <emphasis>loop</emphasis> at all.</para>
@y
      <para>
      Udev は <emphasis>snd-pcm-oss</emphasis> のような<quote>ラッパー (wrapper)</quote>ドライバーや <emphasis>loop</emphasis> のような、現実のハードウェアに対するものではないドライバーは、ロードすることができません。
      </para>
@z

@x
      <title>A kernel module is not loaded automatically, and Udev is not
      intended to load it</title>
@y
      <title>
      カーネルモジュールが自動的にロードされず Udev もロードしようとしない問題
      </title>
@z

@x
      <para>If the <quote>wrapper</quote> module only enhances the functionality
      provided by some other module (e.g., <emphasis>snd-pcm-oss</emphasis>
      enhances the functionality of <emphasis>snd-pcm</emphasis> by making the
      sound cards available to OSS applications), configure
      <command>modprobe</command> to load the wrapper after Udev loads the
      wrapped module. To do this, add an <quote>install</quote> line to a file
      in <filename>/etc/modprobe.d</filename>. For example:</para>
@y
      <para>
      <quote>ラッパー (wrapper)</quote>モジュールが単に他のモジュールの機能を拡張するだけのものであるなら (例えば <emphasis>snd-pcm-oss</emphasis> は <emphasis>snd-pcm</emphasis> の機能拡張を行うもので、OSS アプリケーションに対してサウンドカードを利用可能なものにするだけのものであるため) <command>modprobe</command> の設定によってラッパーモジュールを先にロードし、その後でラップされるモジュールがロードされるようにします。
      これは以下のように <filename>/etc/modprobe.d/</filename> ディレクトリ内のファイルにて<quote>install</quote>の記述行を加えることで実現します。
      </para>
@z

@x
      <para>If the module in question is not a wrapper and is useful by itself,
      configure the <command>S05modules</command> bootscript to load this
      module on system boot. To do this, add the module name to the
      <filename>/etc/sysconfig/modules</filename> file on a separate line.
      This works for wrapper modules too, but is suboptimal in that case.</para>
@y
      <para>
      問題のモジュールがラッパーモジュールではなく、単独で利用できるものであれば、 <command>S05modules</command> ブートスクリプトを編集して、システム起動時にこのモジュールがロードされるようにします。
      これは <filename>/etc/sysconfig/modules</filename> ファイルにて、そのモジュール名を単独の行に記述することで実現します。
      この方法はラッパーモジュールに対しても動作しますが、この場合は次善策となります。
      </para>
@z

@x
      <title>Udev loads some unwanted module</title>
@y
      <title>Udev が不必要なモジュールをロードする問題</title>
@z

@x
      <para>Either don't build the module, or blacklist it in
      <filename>/etc/modprobe.d</filename> file as done with the
      <emphasis>forte</emphasis> module in the example below:</para>
@y
      <para>
      不必要なモジュールはこれをビルドしないことにするか、あるいは <filename>/etc/modprobe.d/</filename>にてブラックリスト化します。
      例えば <emphasis>forte</emphasis> モジュールをブラックリストに登録するには以下のようにします。
      </para>
@z

@x
      <para>Blacklisted modules can still be loaded manually with the
      explicit <command>modprobe</command> command.</para>
@y
      <para>
      ブラックリストに登録されたモジュールは <command>modprobe</command> コマンドを使えば手動でロードすることもできます。
      </para>
@z

@x
      <title>Udev makes a wrong symlink</title>
@y
      <title>Udev が誤ったシンボリックリンクを生成する問題</title>
@z

@x
      <para>This usually happens if a rule unexpectedly matches a device. For
      example, a poorly-written rule can match both a SCSI disk (as desired)
      and the corresponding SCSI generic device (incorrectly) by vendor.
      Find the offending rule and make it more specific, with the help of
      <command>udevadm info</command>.</para>
@y
      <para>
      デバイス生成規則が意図したデバイスに合致していないと、この状況が往々にして起こります。
      例えば生成規則の記述が不十分であった場合、SCSI ディスク (本来望んでいるデバイス) と、それに対応づいたものとしてベンダーが提供する SCSI ジェネリックデバイス (これは誤ったデバイス) の両方に生成規則が合致してしまいます。
      記述されている生成規則を探し出して正確に記述してください。
      その際には <command>udevadm info</command> コマンドを使って情報を確認してください。
      </para>
@z

@x
      <title>Udev rule works unreliably</title>
@y
      <title>Udev 規則が不審な動きをする問題</title>
@z

@x
      <para>This may be another manifestation of the previous problem. If not,
      and your rule uses <systemitem class="filesystem">sysfs</systemitem>
      attributes, it may be a kernel timing issue, to be fixed in later kernels.
      For now, you can work around it by creating a rule that waits for the used
      <systemitem class="filesystem">sysfs</systemitem> attribute and appending
      it to the <filename>/etc/udev/rules.d/10-wait_for_sysfs.rules</filename>
      file. Please notify the CLFS Development list if you do so and it
      helps.</para>
@y
      <para>
      この問題は、一つ前に示したものが別の症状となって現れたものかもしれません。
      そのような理由でなく、生成規則が正しく <systemitem
      class="filesystem">sysfs</systemitem> の属性を利用しているのであれば、それはカーネルの処理タイミングに関わる問題であって、カーネルを修正すべきものです。
      今の時点では、該当する <systemitem class="filesystem">sysfs</systemitem> の属性の利用を待ち受けるような生成規則を生成し、<filename>/etc/udev/rules.d/10-wait_for_sysfs.rules</filename> ファイルにそれを追加することで対処できます。
      もしこれを実施してうまくいった場合は CLFS 開発メーリングリストにお知らせください。
      </para>
@z

@x
      <title>Device naming order changes randomly after rebooting</title>
@y
      <title>再起動後にデバイスの命名順がランダムに変わってしまう問題</title>
@z

@x
      <para>This is due to the fact that Udev, by design, handles uevents and
      loads modules in parallel, and thus in an unpredictable order. This will
      never be <quote>fixed</quote>. You should not rely upon the kernel device
      names being stable. Instead, create your own rules that make symlinks with
      stable names based on some stable attributes of the device, such as a
      serial number or the output of various *_id utilities installed by Udev.
      See <xref linkend="ch-config-symlinks"/> and
      <xref linkend="chapter-network"/> for examples.</para>
@y
      <para>
      これは Udev の設計仕様に従って発生するもので、uevent の扱いとモジュールのロードが平行して行われるためです。
      このために命名順が予期できないものになります。
      これを<quote>固定的に</quote>することはできません。
      ですからカーネルがデバイス名を固定的に定めるようなことを求めるのではなく、シンボリックリンクを用いた独自の生成規則を作り出して、そのデバイスの固定的な属性を用いた固定的な名前を用いる方法を取ります。
      固定的な属性とは例えば、Udev によってインストールされるさまざまな *_id という名のユーティリティが出力するシリアル番号などです。
      設定例については <xref linkend="ch-config-symlinks"/>や <xref linkend="chapter-network"/>を参照してください。
      </para>
@z

@x
    <title>Useful Reading</title>
@y
    <title>参考情報</title>
@z

@x
    <para>Additional helpful documentation is available at the following
    sites:</para>
@y
    <para>
    さらに参考になるドキュメントが以下のサイトにあります：
    </para>
@z

@x
        <para remap="verbatim">A Userspace Implementation of <systemitem class="filesystem">devfs</systemitem>
        <ulink url="http://www.kroah.com/linux/talks/ols_2003_udev_paper/Reprint-Kroah-Hartman-OLS2003.pdf"/></para>
@y
        <para remap="verbatim">
        <systemitem class="filesystem">devfs</systemitem> のユーザー空間での実装方法 <ulink
        url="http://www.kroah.com/linux/talks/ols_2003_udev_paper/Reprint-Kroah-Hartman-OLS2003.pdf"/>
        </para>
@z

@x
        <para remap="verbatim">The <systemitem class="filesystem">sysfs</systemitem> Filesystem
        <ulink url="http://www.kernel.org/pub/linux/kernel/people/mochel/doc/papers/ols-2005/mochel.pdf"/></para>
@y
        <para remap="verbatim">
        <systemitem class="filesystem">sysfs</systemitem> ファイルシステム
        <ulink url="http://www.kernel.org/pub/linux/kernel/people/mochel/doc/papers/ols-2005/mochel.pdf"/>
        </para>
@z