%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Creating the ${CLFS}/tools Directory</title>
@y
  <title>${CLFS}/tools ディレクトリの生成</title>
@z

@x
  <para>All programs compiled in <xref linkend="chapter-temp-system"/>
  will be installed under <filename class="directory">${CLFS}/tools</filename>
  to keep them separate from the programs compiled in <xref
  linkend="chapter-building-system"/>. The programs compiled here are
  temporary tools and will not be a part of the final CLFS system. By keeping
  these programs in a separate directory, they can easily be discarded later
  after their use. This also prevents these programs from ending up in the
  host production directories (easy to do by accident in <xref
  linkend="chapter-temp-system"/>).</para>
@y
  <para>
  <xref linkend="chapter-temp-system"/> にてコンパイルするプログラムは、すべて <filename
  class="directory">${CLFS}/tools</filename> ディレクトリ配下にインストールされ、<xref
  linkend="chapter-building-system"/> にてコンパイルされるプログラムとは区別されます。
  ここでコンパイルするプログラムは一時的ツールであって、最終的な CLFS システムを構成するものではありません。
  このようにプログラムを分離したディレクトリに置いておけば、後に必要がなくなった時には簡単に削除できます。
  またホストシステムの実行環境に入り混じってしまうことを避ける意味もあります。
  (<xref linkend="chapter-temp-system"/> の作業でついうっかり、といった失敗がなくなります。)
  </para>
@z

@x
  <para>Create the required directory by running the following as
  <systemitem class="username">root</systemitem>:</para>
@y
  <para>
  必要なディレクトリを生成するために、<systemitem
  class="username">root</systemitem> ユーザーになって以下を実行します。
  </para>
@z

@x
  <para>The next step is to create a <filename class="symlink">/tools</filename>
  symlink on the host system. This will point to the newly-created directory
  on the CLFS partition. Run this command as <systemitem
  class="username">root</systemitem> as well:</para>
@y
  <para>
  次はホストシステム上に、<filename
  class="symlink">/tools</filename> のシンボリックリンクを生成します。
  このリンクは CLFS パーティション上の新たなディレクトリを指し示すことになります。
  先ほどと同じく <systemitem class="username">root</systemitem> ユーザーになって以下を実行します。
  </para>
@z

@x
    <para>The above command is correct. The <command>ln</command> command
    has a few syntactic variations, so be sure to check <command>info
    coreutils ln</command> and <filename>ln(1)</filename> before reporting
    what you may think is an error.</para>
@y
    <para>
    上のコマンドに間違いはありません。
    <command>ln</command> コマンドにはいくつか文法の異なるバージョンがあります。
    間違いがあると思った場合には <command>info
    coreutils ln</command> や <filename>ln(1)</filename> をよく確認してください。
    </para>
@z

@x
  <para>The created symlink enables the toolchain to be compiled so that
  it always refers to <filename class="directory">/tools</filename>,
  meaning that the compiler, assembler, and linker will work. This will
  provide a common place for our temporary tools system.</para>
@y
  <para>
  シンボリックリンクを作成することで、ツールチェーンをコンパイルする準備が整いました。
  これにより常に <filename class="directory">/tools</filename> ディレクトリを参照したツールチェーンが生成でき、コンパイラー、アセンブラー、リンカーが動作するようになります。
  これが一時システムの作業場所となります。
  </para>
@z
