%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <para>The Shadow package contains programs for handling passwords in a
    secure way.</para>
@y
    <para>
    Shadow パッケージはセキュアなパスワード管理を行うプログラムを提供します。
    </para>
@z

@x
    <title>Installation of Shadow</title>
@y
    <title>&InstallationOf1;Shadow &InstallationOf2;</title>
@z

@x
      <para>If you would like to enforce the use of strong passwords,
      refer to <ulink url="&cblfs-root;index.php/Cracklib"/>
      for installing Cracklib prior to building Shadow. After Cracklib is
      installed, execute this <command>sed</command> in Shadow's source
      directory to correct the path to the Cracklib dictionary:</para>
@y
      <para>
      もっと強力なパスワードを利用したい場合は <ulink
      url="&cblfs-root;index.php/Cracklib"/> にて示している Cracklib パッケージを参照してください。
      Cracklib パッケージは Shadow パッケージよりも前にインストールします。
      Cracklib をインストールしたら、Shadow のソースディレクトリに入って以下の <command>sed</command> を実行してください。
      これは Cracklib 辞書へのパスを適切にするものです。
      </para>
@z

@x
      <para>Finally, add <parameter>--with-libcrack</parameter> to the
      <command>configure</command> command below.</para>
@y
      <para>
      そしてこの後に実行する <command>configure</command> コマンドに <parameter>--with-libcrack</parameter> を加えてください。
      </para>
@z

@x
    <para os="b">Disable the installation of the <command>groups</command> and
    <command>nologin</command> programs and their man pages, as better versions
    of these programs are provided by Coreutils and Util-linux:</para>
@y
    <para os="b">
    <command>groups</command> プログラムと <command>nologin</command> プログラム、それらの man ページはインストールしないようにします。
    これはより良い版が Coreutils と Util-linux により提供されているからです。
    </para>
@z

@x
    <para os="d">Prepare Shadow for compilation:</para>
@y
    <para os="d">&PreparePackage1;Shadow &PreparePackage2;</para>
@z

@x
<para os="f">The meaning of the new configure option:</para>
@y
<para os="f">&MeaningOfOption1;configure &MeaningOfOption2;</para>
@z

@x --sysconfdir=/etc
      <listitem><para>Tells Shadow to install its configuration files into
      <filename class="directory">/etc</filename>, rather than
      <filename class="directory">/usr/etc</filename>.</para></listitem>
@y
      <listitem><para>
      Shadow の設定ファイルのインストール先を <filename
      class="directory">/usr/etc</filename> ではなく <filename
      class="directory">/etc</filename> とします。
      </para></listitem>
@z

@x
    <para os="h">Compile the package:</para>
@y
    <para os="h">&CompileThePackage;</para>
@z

@x
    <para os="j">This package does not come with a test suite.</para>
@y
    <para os="j">&NotExistTestsuite;</para>
@z

@x
    <para os="k">Install the package:</para>
@y
    <para os="k">&InstallThePackage;</para>
@z

@x
    <para os="m" id="shadow-login_defs">Instead of using the default
    <emphasis>DES</emphasis> method, use the more secure
    <emphasis>SHA512</emphasis> method of password encryption, which also allows
    passwords longer than 8 characters. It is also necessary to change the
    obsolete <filename class="directory">/var/spool/mail</filename> location
    for user mailboxes that Shadow uses by default to the <filename
    class="directory">/var/mail</filename> location used currently. Use the
    following sed command to make these changes to the appropriate
    configuration file:</para>
@y
    <para os="m" id="shadow-login_defs">
    パスワード暗号化に関して、デフォルトの <emphasis>DES</emphasis> 手法ではなく、より強力な <emphasis>SHA512</emphasis> 手法を用いることにします。
    こうしておくと 8文字以上のパスワード入力が可能となります。
    またメールボックスを収めるディレクトリとして Shadow ではデフォルトで <filename
    class="directory">/var/spool/mail</filename> ディレクトリを利用していますが、これは古いものであるため <filename
    class="directory">/var/mail</filename> ディレクトリに変更します。
    以下の sed コマンドを実行して設定ファイルへの変更を行います。
    </para>
@z

@x
    <para os="t">Move a misplaced program to its proper location:</para>
@y
    <para os="t">
    誤ったディレクトリにあるファイルを移動します。
    </para>
@z

@x
    <para os="v">The <command>login</command> program will write to
    <filename>/var/log/faillog</filename>, to record failed login attempts, and
    <filename>/var/log/lastlog</filename>, to record the date and
    time of the latest successful login for each user. These log files are not
    created automatically if they do not already exist, so we will
    create them now and give them appropriate ownership and permissions:</para>
@y
    <para os="v">
    <command>login</command> プログラムは <filename>/var/log/faillog</filename> が存在する場合に、ログインの失敗を記録します。
    また <filename>/var/log/lastlog</filename> が存在する場合に、各ユーザーがログイン成功した最新の日付時刻をそのファイルに記録します。
    このログファイルは存在していない場合に自動的に生成されません。
    そこでこのファイルをここで生成し適切な所有者とパーミッションを与えます。
    </para>
@z

@x
    <title>Configuring Shadow</title>
@y
    <title>&Configuring1;Shadow &Configuring2;</title>
@z

@x
      <secondary>configuring</secondary>
@y
      <secondary>設定</secondary>
@z

@x
    <para>This package contains utilities to add, modify, and delete users and
    groups; set and change their passwords; and perform other administrative
    tasks. For a full explanation of what <emphasis>password shadowing</emphasis>
    means, see the <filename>doc/HOWTO</filename> file within the unpacked source
    tree. If using Shadow support, keep in mind that programs which need to
    verify passwords (display managers, FTP programs, pop3 daemons, etc.) must
    be Shadow-compliant. That is, they need to be able to work with shadowed
    passwords.</para>
@y
    <para>
    このパッケージには、ユーザーやグループの追加、修正、削除、そのパスワードの設定、変更、その他の管理操作を行うユーティリティが含まれます。
    <emphasis>パスワードのシャドウイング (password shadowing)</emphasis> というものが何を意味するのか、その詳細についてはこのパッケージのソース内にある <filename>doc/HOWTO</filename> を参照してください。
    Shadow によるサポートを利用する場合、パスワード認証を必要とするプログラム (ディスプレイマネージャー、FTP プログラム、POP3、デーモン、など) は Shadow に準拠したものでなければなりません。
    つまりそれらのプログラムが、シャドウ化された (shadowed) パスワードを受け入れて動作しなければならないということです。
    </para>
@z

@x
    <para>To enable shadowed passwords, run the following command:</para>
@y
    <para>
    Shadow によるパスワードの利用を有効にするために、以下のコマンドを実行します。
    </para>
@z

@x
    <para>To enable shadowed group passwords, run:</para>
@y
    <para>
    また Shadow によるグループパスワードを有効にするために、以下を実行します。
    </para>
@z

@x
    <para>To view or change the default settings for new user accounts that
    you create, you can edit <filename>/etc/default/useradd</filename>. See
    <command>man useradd</command> or
    <ulink url="&cblfs-root;index.php/Configuring_for_Adding_Users"/> for more
    information.</para>
@y
    <para>
    新たに生成するユーザーアカウントに対してのデフォルト設定を確認したり変更したりする場合は <filename>/etc/default/useradd</filename> ファイルを使います。
    詳しくは <command>man useradd</command> または <ulink
    url="&cblfs-root;index.php/Configuring_for_Adding_Users"/> を参照してください。
    </para>
@z

@x
    <title>Setting the root password</title>
@y
    <title>root パスワードの設定</title>
@z

@x
    <para>Choose a password for user <systemitem
    class="username">root</systemitem> and set it by running:</para>
@y
    <para>
    以下のコマンドを実行して <systemitem
    class="username">root</systemitem> ユーザーに対するパスワードを設定します。
    </para>
@z

@x
    <title>Contents of Shadow</title>
@y
    <title>&ContentsOf1;Shadow &ContentsOf2;</title>
@z

@x
      <segtitle>Installed programs</segtitle>
      <segtitle>Installed directory</segtitle>
@y
      <segtitle>&InstalledProgram;</segtitle>
      <segtitle>&InstalledDirectory;</segtitle>
@z

@x
        <seg>chage, chfn, chgpasswd, chpasswd, chsh, expiry, faillog, gpasswd,
        groupadd, groupdel, groupmems, groupmod, grpck, grpconv, grpunconv,
        lastlog, login, logoutd, newgrp, newusers, passwd, pwck,
        pwconv, pwunconv, sg (link to newgrp), su, useradd, userdel, usermod,
        vigr (link to vipw), vipw</seg>
        <seg>/etc/default</seg>
@y
        <seg>chage, chfn, chgpasswd, chpasswd, chsh, expiry, faillog, gpasswd,
        groupadd, groupdel, groupmems, groupmod, grpck, grpconv, grpunconv,
        lastlog, login, logoutd, newgrp, newusers, passwd, pwck,
        pwconv, pwunconv, sg (&LinkTo1;newgrp &LinkTo2;), su, useradd, userdel, usermod,
        vigr (&LinkTo1;vipw &LinkTo2;), vipw</seg>
        <seg>/etc/default</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x chage
          <para>Used to change the maximum number of days between obligatory
          password changes</para>
@y
          <para>
          ユーザーのパスワード変更を行うべき期間を変更します。
          </para>
@z

@x chfn
          <para>Used to change a user's full name and other information</para>
@y
          <para>
          ユーザーのフルネームや他の情報を変更します。
          </para>
@z

@x chgpasswd
          <para>Used to update group passwords in batch mode</para>
@y
          <para>
          グループのパスワードをバッチモードにて更新します。
          </para>
@z

@x chpasswd
          <para>Used to update the passwords of an entire series of user
          accounts</para>
@y
          <para>
          複数ユーザーのパスワードを更新します。
          </para>
@z

@x chsh
          <para>Used to change a user's default login shell</para>
@y
          <para>
          ユーザーのデフォルトのログインシェルを変更します。
          </para>
@z

@x expiry
          <para>Checks and enforces the current password expiration policy</para>
@y
          <para>
          現時点でのパスワード失効に関する設定をチェックし更新します。
          </para>
@z

@x faillog
          <para>Is used to examine the log of login failures, to set a maximum
          number of failures before an account is blocked, or to reset the
          failure count</para>
@y
          <para>
          ログイン失敗のログを調査します。
          ログインの失敗を繰り返すことでアカウントがロックされる際の、最大の失敗回数を設定します。
          またその失敗回数をリセットします。
          </para>
@z

@x gpasswd
          <para>Is used to add and delete members and administrators to
          groups</para>
@y
          <para>
          グループに対してメンバーや管理者を追加、削除します。
          </para>
@z

@x groupadd
          <para>Creates a group with the given name</para>
@y
          <para>
          指定した名前でグループを生成します。
          </para>
@z

@x groupdel
          <para>Deletes the group with the given name</para>
@y
          <para>
          指定された名前のグループを削除します。
          </para>
@z

@x groupmems
          <para>Allows a user to administer his/her own group membership list
          without the requirement of superuser privileges</para>
@y
          <para>
          スーパーユーザー権限を持たなくても、自分自身のグループのメンバーリストを管理可能とします。
          </para>
@z

@x groupmod
          <para>Is used to modify the given group's name or GID</para>
@y
          <para>
          指定されたグループの名前や GID を修正します。
          </para>
@z

@x grpck
          <para>Verifies the integrity of the group files
          <filename>/etc/group</filename> and
          <filename>/etc/gshadow</filename></para>
@y
          <para>
          グループファイル <filename>/etc/group</filename> と <filename>/etc/gshadow</filename> の整合性を確認します。
          </para>
@z

@x grpconv
          <para>Creates or updates the shadow group file from the normal
          group file</para>
@y
          <para>
          通常のグループファイルから Shadow グループファイルを生成、更新します。
          </para>
@z

@x grpunconv
          <para>Updates <filename>/etc/group</filename> from
          <filename>/etc/gshadow</filename> and then deletes the latter</para>
@y
          <para>
          <filename>/etc/gshadow</filename> ファイルを元に <filename>/etc/group</filename> ファイルを更新し <filename>/etc/gshadow</filename> ファイルを削除します。
          </para>
@z

@x lastlog
          <para>Reports the most recent login of all users or of a
          given user</para>
@y
          <para>
          全ユーザーの中での最新ログインの情報、または指定ユーザーの最新ログインの情報を表示します。
          </para>
@z

@x login
          <para>Is used by the system to let users sign on</para>
@y
          <para>
          ユーザーのログインを行います。
          </para>
@z

@x logoutd
          <para>Is a daemon used to enforce restrictions on log-on time
          and ports</para>
@y
          <para>
          ログオン時間とポートに対する制限を実施するためのデーモン。
          </para>
@z

@x newgrp
          <para>Is used to change the current GID during a login session</para>
@y
          <para>
          ログインセッション中に現在の GID を変更します。
          </para>
@z

@x newusers
          <para>Is used to create or update an entire series of user
          accounts</para>
@y
          <para>
          複数ユーザーのアカウント情報を生成または更新します。
          </para>
@z

@x passwd
          <para>Is used to change the password for a user or group account</para>
@y
          <para>
          ユーザーアカウントまたはグループアカウントに対するパスワードを変更します。
          </para>
@z

@x pwck
          <para>Verifies the integrity of the password files
          <filename>/etc/passwd</filename> and
          <filename>/etc/shadow</filename></para>
@y
          <para>
          パスワードファイル <filename>/etc/passwd</filename> と <filename>/etc/shadow</filename> の整合性を確認します。
          </para>
@z

@x pwconv
          <para>Creates or updates the shadow password file from the normal
          password file</para>
@y
          <para>
          通常のパスワードファイルを元に shadow パスワードファイルを生成、更新します。
          </para>
@z

@x pwunconv
          <para>Updates <filename>/etc/passwd</filename> from
          <filename>/etc/shadow</filename> and then deletes the latter</para>
@y
          <para>
          <filename>/etc/shadow</filename> ファイルを元に <filename>/etc/passwd</filename> ファイルを更新し <filename>/etc/shadow</filename> を削除します。
          </para>
@z

@x sg
          <para>Executes a given command while the user's GID
          is set to that of the given group</para>
@y
          <para>
          ユーザーの GID を指定されたグループにセットした上で、指定されたコマンドを実行します。
          </para>
@z

@x su
          <para>Runs a shell with substitute user and group IDs</para>
@y
          <para>
          ユーザー ID とグループ ID を変更してシェルを実行します。
          </para>
@z

@x useradd
          <para>Creates a new user with the given name, or updates the default
          new-user information</para>
@y
          <para>
          指定した名前で新たなユーザーを生成します。
          あるいは新規ユーザーのデフォルトの情報を更新します。
          </para>
@z

@x userdel
          <para>Deletes the given user account</para>
@y
          <para>
          指定されたユーザーアカウントを削除します。
          </para>
@z

@x usermod
          <para>Is used to modify the given user's login name, User
          Identification (UID), shell, initial group, home directory, etc.</para>
@y
          <para>
          指定されたユーザーのログイン名、UID  (User Identification)、利用シェル、初期グループ、ホームディレクトリなどを変更します。
          </para>
@z

@x vigr
          <para>Edits the <filename>/etc/group</filename> or
          <filename>/etc/gshadow</filename> files</para>
@y
          <para>
          <filename>/etc/group</filename> ファイルあるいは <filename>/etc/gshadow</filename> ファイルを編集します。
          </para>
@z

@x vipw
          <para>Edits the <filename>/etc/passwd</filename> or
          <filename>/etc/shadow</filename> files</para>
@y
          <para>
          <filename>/etc/passwd</filename> ファイルあるいは <filename>/etc/shadow</filename> ファイルを編集します。
          </para>
@z