%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <title>Installation of Yaboot</title>
@y
    <title>&InstallationOf1;Yaboot &InstallationOf2;</title>
@z

@x
    <para>Yaboot defaults to build as 32bit, so we need to pass appropriate
    options to both the compiler and the linker.  To prevent the build from
    failing due to compiler warnings, the -Werror flag is removed.  The
    Makefile already overrides any CC and ignores LDFLAGS in favour of
    its own variables, so we need to use the following seds for a
    successful compile and install.</para>
@y
    <para>
    Yaboot はデフォルトで 32ビットモジュールをビルドします。
    そこでコンパイラーとリンカーに対しては適切なオプションを指定する必要があります。
    コンパイル時の警告によってビルドに失敗することから -Werror フラグは取り除きます。
    Makefile 
The
    Makefile already overrides any CC and ignores LDFLAGS in favour of
    its own variables, so we need to use the following seds for a
    successful compile and install
    </para>
@z

@x
      <title>The meaning of the sed parameters:</title>
@y
      <title>&MeaningOfParameter1;sed &MeaningOfParameter2;</title>
@z

@x "s/m32/m64/g"
          <para>Replaces -m32 with -m64 to force <command>gcc</command> to
          create 64-bit code when compiling yaboot.</para>
@y
          <para>
          -m32 を -m64 に変更することで yaboot のコンパイルにおいて <command>gcc</command> が 64ビットコードを生成するようにします。
          </para>
@z

@x "s/-Werror//"
          <para>This deletes the -Werror flag from the Makefile.</para>
@y
          <para>
          Makefile から -Werror フラグを削除します。
          </para>
@z

@x "s/elf32ppclinux/elf64ppc/"
          <para>This replaces the 32 bit emulation with a 64 bit emulation
          flag to force <command>ld</command> to use a suitable 64-bit
          emulation picked from the output of <command>'ld -V'</command>.</para>
@y
          <para>
          32ビットエミュレーションを 64ビットエミュレーションに書き換えます。
          これにより <command>ld</command> コマンドが <command>'ld -V'</command> の出力結果に基づいて 64ビットエミュレーションを利用するようにします。
          </para>
@z

@x
      <para>The install of yaboot can fail if you miss any of the
      patches or seds. <command>ld</command> will issue warnings,
      but the install will appear to complete successfully. That
      would result in an unbootable system, so you need to log the
      output to check it.</para>
@y
      <para>
      yaboot のインストールを成功させるためには、上記のパッチ、sed コマンドは必ず行わなければなりません。
      どれかをやり残した状況でも <command>ld</command> は警告エラーを出すだけで、インストールは正常に終了したかのように見えるかもしれません。
      ただそういう状況はシステムを起動させることはできません。
      ですからログ出力の結果は必ず確認してください。
      </para>
@z

@x
    <para os='g'>To ensure that the install was successful, run the following
    command:</para>
@y
    <para os='g'>
    インストールが成功したかどうかは以下のコマンドにより確認します。
    </para>
@z

@x
    <para os='i'>If the command gave you <emphasis>any</emphasis> output
    (... is incompatible with powerpc:common output) the build of yaboot is
    broken and you will have to correct your error(s) and repeat it.</para>
@y
    <para os='i'>
    このコマンド実行により ... is incompatible with powerpc:common output といった出力が<emphasis>一つ</emphasis> でもあれば、それは yaboot のビルドに失敗していることを意味します。
    その場合はビルドエラーを修正し再度インストールしてください。
    </para>
@z