%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Configuring the Linux Console</title>
@y
  <title>Linux コンソールの設定</title>
@z

@x
  <secondary>configuring</secondary></indexterm>
@y
  <secondary>設定</secondary></indexterm>
@z

@x
  <para>This section discusses how to configure the
  <command>systemd-vconsole-setup</command> system service which configures
  the virtual console font and console keymap.
@y
  <para>
  この節ではシステムサービス <command>systemd-vconsole-setup</command> の設定方法について説明します。
  このサービスは仮想コンソールフォントとコンソールキーマップを設定します。
@z

@x
  The <command>systemd-vconsole-setup</command> service reads <filename>
  /etc/vconsole.conf</filename> for configuration information. Decide which
  keymap and screen font will be used. Various language-specific HOWTO's can
  help. with this (see
  <ulink url="http://www.tldp.org/HOWTO/HOWTO-INDEX/other-lang.html"/>. Examine
  <command>localectl list-keymaps</command> output for a list of valid console
  keymaps. Look in
  <filename class="directory">/usr/share/consolefonts</filename> for valid
  screen fonts.</para>
@y
  <command>systemd-vconsole-setup</command> サービスは、<filename>/etc/vconsole.conf</filename> ファイルにて示される設定情報を読み込みます。
  キーマップやスクリーンフォントには何を用いるのかを定めてください。
  各言語に対する HOWTO も確認してください。<ulink
  url="http://www.tldp.org/HOWTO/HOWTO-INDEX/other-lang.html"/> が参考になるでしょう。
  <command>localectl list-keymaps</command> を実行すると、設定可能なコンソールキーマップを確認できます。
  また <filename class="directory">/usr/share/consolefonts</filename> ディレクトリを見れば、設定可能なスクリーンフォントを確認できます。
  </para>
@z

@x
  <para>The <filename>/etc/vconsole.conf</filename> file should contain lines
  of the form: VARIABLE="value". The following variables are recognized:</para>
@y
  <para>
  <filename>/etc/vconsole.conf</filename> ファイルの各行は VARIABLE="value" といった書式により構成されます。
  VARIABLE には以下の変数を利用します。
  </para>
@z

@x KEYMAP
        <para>This variable specifies the key mapping table for the keyboard. If
        unset, it defaults to <literal>us</literal>.</para>
@y
        <para>
        この変数はキーボードに対するキーマッピングテーブルを指定します。
        これが定められていない場合はデフォルトで <literal>us</literal> が設定されます。
        </para>
@z

@x KEYMAP_TOGGLE
        <para>This variable can be used to configure a second toggle keymap and
        is unset by default.</para>
@y
        <para>
        この変数は二番目のトグルキーマップを設定します。
        デフォルトでは本変数は設定されません。
        </para>
@z

@x FONT
        <para>This variable specifies the font used by the virtual
        console.</para>
@y
        <para>
        この変数は仮想コンソールにて用いられるフォントを指定します。
        </para>
@z

@x FONT_MAP
        <para>This variable specifies the console map to be used.</para>
@y
        <para>
        この変数はコンソールマップを指定します。
        </para>
@z

@x FONT_UNIMAP
        <para>This variable specifies the unicode font map.</para>
@y
        <para>
        この変数は unicode フォントマップを指定します。
        </para>
@z

@x
  <para>An example for a German keyboard and console is given below:</para>
@y
  <para>
  ドイツのキーボードおよびコンソールの設定例は以下です。
  </para>
@z

@x
  <para>You can change KEYMAP value at runtime by using the
  <command>localectl</command> utility:</para>
@y
  <para>
  <command>localectl</command> ユーティリティーを用いれば、システム稼動中に KEYMAP 変数を変更することができます。
  </para>
@z

@x
  <note><para>Please note that <command>localectl</command> command can
  be used  only on a system booted with systemd.</para></note>
@y
  <note><para>
  <command>localectl</command> コマンドはあくまで systemd により起動されたシステムにおいて利用できる点に注意してください。
  </para></note>
@z

@x
  <para>You can also use <command>localectl</command> utility with the
  corresponding parameters to change X11 keyboard layout, model, variant
  and options:</para>
@y
  <para>
  <command>localectl</command> ユーティリティーはまた、X11 キーボードレイアウト、モデル、ヴァリアント、オプションをそれぞれ対応する変数により設定することができます。
  </para>
@z

@x
  <para>To list possible values for <command>localectl set-x11-keymap</command>
  parameters, run <command>localectl</command> with parameters listed below:
  </para>
@y
  <para>
  <command>localectl set-x11-keymap</command> に対して設定可能な値の一覧は、以下の変数を使って <command>localectl</command> を実行して得ることができます。
  </para>
@z

@x list-x11-keymap-models
        <para>Show known X11 keyboard mapping models.</para>
@y
        <para>
        X11 キーボードマッピングモデルを表示します。
        </para>
@z

@x list-x11-keymap-layouts
        <para>Show known X11 keyboard mapping layouts.</para>
@y
        <para>
        X11 キーボードマッピングレイアウトを表示します。
        </para>
@z

@x list-x11-keymap-variants
        <para>Show known X11 keyboard mapping variants.</para>
@y
        <para>
        X11 キーボードマッピングヴァリアントを表示します。
        </para>
@z

@x list-x11-keymap-options
        <para>Show known X11 keyboard mapping options.</para>
@y
        <para>
        X11 キーボードマッピングオプションを表示します。
        </para>
@z

@x
  <note><para>Using any of the parameters listed above requires
  <ulink url="http://cblfs.clfs.org/index.php/Xorg7/Data">
  XKeyboard Client</ulink> package from CBLFS.</para></note>
@y
  <note><para>
  上に示す変数を利用するにあたっては CBLFS ブックに説明する <ulink url="http://cblfs.clfs.org/index.php/Xorg7/Data">
  XKeyboard Client</ulink> パッケージが必要です。
  </para></note>
@z