%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Changing Ownership</title>
@y
  <title>所有者の変更</title>
@z

@x
    <para os="a">Currently, the <filename class="directory">/tools</filename>
    and <filename class="directory">/cross-tools</filename> directories
    are owned by the user <emphasis>clfs</emphasis>, a user that
    exists only on the host system. Although <filename
    class="directory">/tools</filename> and <filename
    class="directory">/cross-tools</filename> can be deleted once the CLFS
    system has been finished, they can be retained to build
    additional CLFS systems. If the <filename class="directory">/tools</filename>
    and <filename class="directory">/cross-tools</filename> directories are
    kept as is, the files are owned by a user ID without a corresponding
    account. This is dangerous because a user account created later could
    get this same user ID and would own these directories and all the files
    therein, thus exposing those files to possible malicious manipulation.</para>
@y
    <para os="a">
    <filename class="directory">/tools</filename> ディレクトリと <filename
    class="directory">/cross-tools</filename> の所有者は今は <emphasis>clfs</emphasis> ユーザーであり、これはホストシステム上にのみ存在するユーザーです。
    CLFS システムの構築を終えたら <filename
    class="directory">/tools</filename> ディレクトリと <filename
    class="directory">/cross-tools</filename> ディレクトリは削除することができます。
    一方でこれを残しておけば別の CLFS システム作りに利用することもできます。
    ただしこの <filename class="directory">/tools</filename> ディレクトリと <filename
    class="directory">/cross-tools</filename> をこのままにしておくということは、そこにあるファイル群が、存在しないユーザーによって所有される形を生み出すことになります。
    これは危険なことです。
    後にユーザーアカウントが生成され同一のユーザーIDを持ったとすると これらのディレクトリの所有者となってしまい、そこにあるファイルすべてを所有することになって、悪意のある操作に利用されてしまいます。
    </para>
@z

@x
    <para os="b">One possible fix for this issue might be to add the
    <systemitem class="username">clfs</systemitem> user to the new CLFS system
    later when creating the <filename>/etc/passwd</filename> file, taking care
    to assign it the same user and group IDs as on the host system. Alternatively,
    assign the contents of the <filename class="directory">/tools</filename>
    and <filename class="directory">/cross-tools</filename> directories to
    user <systemitem class="username">root</systemitem> by running the
    following commands:</para>
@y
    <para os="b">
    この問題を解消するには、新たな CLFS システム 上に <filename>/etc/passwd</filename> を生成した後にそのシステム上のユーザーとして <systemitem
    class="username">clfs</systemitem> ユーザーを作ります。
    このときには同一のユーザーID、グループIDとなるように作ることが必要です。
    別の方法もあります。
    <filename class="directory">/tools</filename> ディレクトリと <filename
    class="directory">/cross-tools</filename> ディレクトリの所有者を <systemitem
    class="username">root</systemitem> ユーザーにすることです。
    以下のコマンドによりこれを実現します。
    </para>
@z

@x
    <para os="d">The commands use <parameter>0:0</parameter> instead of
    <parameter>root:root</parameter>, because <command>chown</command>
    is unable to resolve the name <quote>root</quote> until the
    <filename>passwd</filename> file has been created.</para>
@y
    <para os="d">
    このコマンドでは <parameter>root:root</parameter> を指定せずに <parameter>0:0</parameter> としています。
    これは <command>chown</command> コマンドが今は <quote>root</quote> というユーザー名を認識できないからであり、それができるのは <filename>passwd</filename> ファイルを作った後であるからです。
    </para>
@z