%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Linux-&linux-version2; Headers</title>
@y
  <title>Linux-&linux-version2; ヘッダー</title>
@z

@x
    <primary sortas="a-Linux Headers">Linux Headers</primary>
@y
    <primary sortas="a-Linux Headers">Linux ヘッダー</primary>
@z

@x
    <para>The Linux Kernel contains a <command>make</command> target that
    installs <quote>sanitized</quote> kernel headers.</para>
@y
    <para>
    Linux カーネルには <quote>健全化された (sanitized)</quote>カーネルヘッダーをインストールするための <command>make</command> ターゲットがあります。
    </para>
@z

@x
    <title>Installation of Linux Headers</title>
@y
    <title>&InstallationOf1;Linux ヘッダー&InstallationOf2;</title>
@z

@x
      <para>For this step you will need to unpack the kernel tarball
      (<filename>linux-&linux-version;.tar.xz</filename>) and
      <command>cd</command> into its source
      directory before entering the commands on this page.</para>
@y
      <para>
      カーネルの tarball (<filename>linux-&linux-version;.tar.xz</filename>) を伸張 (解凍) し、ソースディレクトリに <command>cd</command> で移動します。
      その後に本ページに示す各コマンドを実行していきます。
      </para>
@z

@x
    <para os="b">Install the kernel header files:</para>
@y
    <para os="b">
    カーネルのヘッダーファイルをインストールします。
    </para>
@z

@x
      <title>The meaning of the make commands:</title>
@y
      <title>&MeaningOfCommand1;make &MeaningOfCommand2;</title>
@z

@x
          <para>Ensures that the kernel source dir is clean.</para>
@y
          <para>
          カーネルソースディレクトリをクリーンなものにします。
          </para>
@z

@x
          <para>Sanitizes the raw kernel headers so that they can be used
          by userspace programs.</para>
@y
          <para>
          ユーザー空間のプログラムが利用できるように、生のカーネルヘッダーを健全化 (sanitizing) します。
          </para>
@z

@x
          <para>This will install the kernel headers into
          <filename class="directory">/usr/include</filename>.</para>
@y
          <para>
          カーネルヘッダーのインストール先を <filename class="directory">/usr/include</filename> とします。
          </para>
@z

@x
          <para>Removes a number of unneeded debugging files that were installed.</para>
@y
          <para>
          インストールされたファイルのうち、不要なデバッグファイルを削除します。
          </para>
@z

@x
    <title>Contents of Linux Headers</title>
@y
    <title>&ContentsOf1;Linux ヘッダー&ContentsOf2;</title>
@z

@x
      <segtitle>Installed headers</segtitle>
      <segtitle>Installed directories</segtitle>
@y
      <segtitle>&InstalledHeader;</segtitle>
      <segtitle>&InstalledDirectory;</segtitle>
@z

@x
        <seg>/usr/include/{asm,asm-generic,drm,linux,misc,mtd,rdma,scsi,sound,video,xen}/*.h</seg>
        <seg>/usr/include/asm, /usr/include/asm-generic, /usr/include/drm,
        /usr/include/linux, /usr/include/misc, /usr/include/mtd, /usr/include/rdma,
        /usr/include/scsi, /usr/include/sound, /usr/include/uapi,
        /usr/include/video, /usr/include/xen</seg>
@y
        <seg>/usr/include/{asm,asm-generic,drm,linux,misc,mtd,rdma,scsi,sound,video,xen}/*.h</seg>
        <seg>/usr/include/asm, /usr/include/asm-generic, /usr/include/drm,
        /usr/include/linux, /usr/include/misc, /usr/include/mtd, /usr/include/rdma,
        /usr/include/scsi, /usr/include/sound, /usr/include/uapi,
        /usr/include/video, /usr/include/xen</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x
          <para>The Linux API headers</para>
@y
          <para>Linux API ヘッダー</para>
@z