%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Introduction</title>
@y
  <title>はじめに</title>
@z

@x
  <para>This chapter includes a list of packages that need to be downloaded
  for building a basic Linux system. The listed version numbers correspond
  to versions of the software that are known to work, and this book is based
  on their use. We highly recommend not using newer versions because the
  build commands for one version may not work with a newer version. The
  newest package versions may also have problems that require work-arounds.
  These work-arounds will be developed and stabilized in the development
  version of the book.</para>
@y
  <para>
  この章では基本的な Linux システム構築のためにダウンロードするべきパッケージの一覧を示します。
  各パッケージのバージョンは動作が確認されているものを示しており、本書ではこれに基づいて説明します。
  ここに示すバージョンよりも新しいものは使わないようお勧めします。
  あるバージョンでビルドしたコマンドが、新しいバージョンでも動作する保証はないからです。
  最新のパッケージの場合、何かの対処を要するかもしれません。
  そのような対処方法は本書の開発版において開発され安定化が図られるかもしれません。
  </para>
@z

@x
  <para>Download locations may not always be accessible. If a download
  location has changed since this book was published, Google (<ulink
  url="http://www.google.com/"/>) provides a useful search engine for
  most packages. If this search is unsuccessful, try one of the
  alternative means of downloading discussed at <ulink
  url="&packages-root;"/>.</para>
@y
  <para>
  ダウンロードサイトは常にアクセス可能であるとは限りません。
  本書が提供された後にダウンロードする場所が変更になっていたら Google (<ulink
  url="http://www.google.com/"/>) を使って検索してみてください。
  たいていのパッケージを見つけ出すことが出来るはずです。
  それでも見つけられなかったら <ulink
  url="&packages-root;"/> に示されている方法に従って入手してください。
  </para>
@z

@x
  <para>Create a directory called
  <filename class="directory">${CLFS}/sources</filename> and use it to store
  your sources and patches. All packages should be compiled there as well.
  Using any other location for compiling may have unexpected results.</para>
@y
  <para>
  <filename class="directory">${CLFS}/sources</filename> というディレクトリを生成しソースやパッチの保存場所とし、そこでビルドを行う作業ディレクトリとします。
  他の場所でコンパイル作業をする場合は予期しないことが起きるかもしれませんから注意してください。
  </para>
@z

@x
  <para>To create this directory, execute, as user <systemitem
  class="username">root</systemitem>, the following command before
  starting the download session:</para>
@y
  <para>
  ダウンロードを行う前にまずはそのようなディレクトリを生成します。
  <systemitem
  class="username">root</systemitem> ユーザーとなって以下のコマンドを実行します。
  </para>
@z

@x
  <para>Make this directory writable and sticky. When a directory is
  marked <quote>sticky</quote>, that means that even if multiple users have
  write permission on that directory, any file within that directory can only be
  deleted or modified by its owner. The following command, run as
  <systemitem class="username">root</systemitem>, will enable the
  write and sticky modes:</para>
@y
  <para>
  このディレクトリには書き込み権限とスティッキーを与えます。
  ディレクトリに "スティッキー (sticky)" を与えるということは、複数ユーザーに対して書き込み権限が与えられても、削除については所有者しか実行出来ないようにすることです。
  <systemitem class="username">root</systemitem> ユーザーになり以下のコマンドを実行して書き込み権限とスティッキーを定めます。
  </para>
@z

@x
  <para>You can download all needed packages and patches into this directory
either by using the links on the following pages in this section, or by passing
the <ulink url="../dl.list">download list</ulink> to <command>wget</command>:</para>
@y
  <para>
  必要となるパッケージとパッチはこれ以降の説明ページに示されたリンクを使ってダウンロードすることができます。
  あるいは <command>wget</command> コマンドにて <ulink url="../dl.list">ダウンロードリスト</ulink> を用いて入手することもできます。
  </para>
@z

@x
  <para>Verification of downloaded packages can be done by downloading the
following MD5 or SHA1 checksum lists:</para>
@y
  <para>
  ダウンロードしたパッケージ類の検証には、以下の MD5 あるいは SHA1 によるチェックサムリストをダウンロードして実行します。
  </para>
@z