%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Static Networking Configuration</title>
@y
  <title>スタティックなネットワーク設定</title>
@z

@x
    <title>Creating the Static Network Interface Configuration Files</title>
@y
    <title>スタティックネットワークインターフェイス向け設定ファイルの生成</title>
@z

@x
    <para>Which interfaces are brought up and down by the network script
    depends on the files and directories in the <filename
    class="directory">/etc/sysconfig/network-devices</filename> hierarchy.
    This directory should contain a sub-directory for each interface to be
    configured, such as <filename>ifconfig.xyz</filename>, where
    <quote>xyz</quote> is a network interface name. Inside this directory
    would be files defining the attributes to this interface, such as its IP
    address(es), subnet masks, and so forth.</para>
@y
    <para>
    どのネットワークインターフェースが起動したり停止したりするかは <filename
    class="directory">/etc/sysconfig/network-devices</filename> ディレクトリ配下のファイルの指定によります。
    このディレクトリには、設定を行ないたい各ネットワークインターフェースに対するファイル <filename>ifconfig.xyz</filename> を準備します。
    この<quote>xyz</quote>はネットワークカードインターフェース名 (例えば eth0 など) です。
    このファイルにはネットワークインターフェースの属性、つまり IP アドレスやサブネットマスクなどを定義します。
    </para>
@z

@x
    <para>The following command creates a sample <filename>ipv4</filename>
    file for the <emphasis>eth0</emphasis> device:</para>
@y
    <para>
    以下のコマンドは <emphasis>eth0</emphasis> デバイスに対する <filename>ipv4</filename> ファイルのサンプルを生成するものです。
    </para>
@z

@x
    <para os="var-ob">The values of these variables must be changed in every file to match
    the proper setup. If the <envar>ONBOOT</envar> variable is set to
    <quote>yes</quote> the network script will bring up the Network Interface
    Card (NIC) during booting of the system. If set to anything but
    <quote>yes</quote> the NIC will be ignored by the network script and not
    be brought up.</para>
@y
    <para os="var-ob">
    各変数の値は、このような設定ファイルの個々において適切なものに書き換えてください。
    <envar>ONBOOT</envar> 変数を<quote>yes</quote>に設定した場合、システム起動時にネットワークスクリプトがネットワークインターフェースカード (network
    interface card; NIC) を起動します。
    <quote>yes</quote>以外に設定すると、ネットワークスクリプトからの NIC の起動がなくなり、NIC は自動では起動しなくなります。
    </para>
@z

@x
    <para os="var-s">The <envar>SERVICE</envar> variable defines the method used for
    obtaining the IP address. The CLFS-Bootscripts package has a modular IP
    assignment format, and creating additional files in the <filename
    class="directory">/etc/sysconfig/network-devices/services</filename>
    directory allows other IP assignment methods.</para>
@y
    <para os="var-s">
    変数 <envar>SERVICE</envar> は IP アドレスの取得方式を定義します。
    CLFS Bootscripts パッケージにはモジュール化した IP アドレス割り当てフォーマットがあります。
    <filename class="directory">/etc/sysconfig/network-devices/services</filename> ディレクトリ内に設定ファイルを置くことで、別の IP アドレス割り当て方式を採用することもできます。
    </para>
@z

@x
    <para>The <envar>GATEWAY</envar> variable should contain the default
    gateway IP address, if one is present. If not, then comment out the
    variable entirely.</para>
@y
    <para>
    変数 <envar>GATEWAY</envar> はデフォルトゲートウェイが存在する場合に、その IP アドレスを設定します。
    存在しない場合はこの変数設定全体をコメントにしてください。
    </para>
@z

@x
    <para>The <envar>PREFIX</envar> variable needs to contain the number of
    bits used in the subnet. Each octet in an IP address is 8 bits. If the
    subnet's netmask is 255.255.255.0, then it is using the first three octets
    (24 bits) to specify the network number. If the netmask is 255.255.255.240,
    it would be using the first 28 bits.  Prefixes longer than 24 bits are
    commonly used by DSL and cable-based Internet Service Providers (ISPs).
    In this example (PREFIX=24), the netmask is 255.255.255.0. Adjust the
    <envar>PREFIX</envar> variable according to your specific subnet.</para>
@y
    <para>
    変数 <envar>PREFIX</envar> はサブネットマスクにて用いられるビット数を指定します。
    IP アドレスの各オクテット (octet) は 8 ビットで構成されます。
    例えばサブネットマスクが 255.255.255.0 である場合、ネットワーク番号 (network number) を特定するには最初の三つのオクテット (24ビット) が用いられることを意味します。
    もし 255.255.255.240 であるなら、最初の 28 ビットということになります。
    24 ビットを超えるプレフィックスは、通常は DSL やケーブルを用いたインターネットサービスプロバイダー (Internet Service Provider; ISP) がよく利用しています。
    上の例 (PREFIX=24) では、サブネットマスクは 255.255.255.0 となります。
    <envar>PREFIX</envar> 変数の値は、ネットワーク環境に応じて変更してください。
    </para>
@z

@x
    <para>To configure another DHCP Interface, Follow <xref linkend="conf-dhcpcd"/>.</para>
@y
    <para>
    これ以外に DHCP インターフェースを設定する場合は <xref linkend="conf-dhcpcd"/> に進んでください。
    </para>
@z