%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Typography</title>
@y
  <title>本書の表記</title>
@z

@x
  <para>To make things easier to follow, there are a few typographical
  conventions used throughout this book. This section contains some
  examples of the typographical format found throughout Cross-Compiled
  Linux From Scratch.</para>
@y
  <para>
  本書では、特定の表記を用いて分かりやすく説明を行っていきます。
  ここではクロスコンパイル Linux From Scratch ブックを通じて利用する表記例を示します。
  </para>
@z

@x
  <para>This form of text is designed to be typed exactly as seen unless
  otherwise noted in the surrounding text. It is also used in the
  explanation sections to identify which of the commands is being
  referenced.</para>
@y
  <para>
  この表記は特に説明がない限りは、そのまま入力するテキストを示しています。
  またコマンドの説明を行うために用いる場合もあります。
  </para>
@z

@x
  <para>This form of text (fixed-width text) shows screen output,
  probably as the result of commands issued.  This format is also used
  to show filenames, such as <filename>/etc/ld.so.conf</filename>.</para>
@y
  <para>
  上の表記は固定幅フォントで示されており、たいていはコマンド入力の結果として出力される端末メッセージを示しています。
  あるいは <filename>/etc/ld.so.conf</filename> といったファイル名を示すのに利用する場合もあります。
  </para>
@z

@x
  <para>This form of text is used for several purposes in the book.
  Its main purpose is to emphasize important points or items.</para>
@y
  <para>
  上の表記はさまざまな意図で用いています。
  特に重要な説明内容やポイントを表します。
  </para>
@z

@x
  <para>This format is used for hyperlinks, both within the CLFS
  community and to external pages. It includes HOWTOs, download locations,
  and websites.</para>
@y
  <para>
  この表記は CLFS コミュニティ内や外部サイトへのハイパーリンクを示します。
  そこには<quote>ハウツー</quote>やダウンロードサイトなどが含まれます。
  </para>
@z

@x
  <para>This format is used when creating configuration files. The first
  command tells the system to create the file
  <filename>${CLFS}/etc/group</filename> from whatever is typed on the
  following lines until the sequence end of file (EOF) is encountered.
  Therefore, this entire section is generally typed as seen.</para>
@y
  <para>
  上の表記は設定ファイル類を生成する際に示します。
  １行目のコマンドは <filename>${CLFS}/etc/group</filename> というファイルを生成することを指示しています。
  そのファイルへは2行目以降 EOF が記述されるまでのテキストが出力されます。
  したがってこの表記は通常そのままタイプ入力します。
  </para>
@z

@x
  <para>This format is used to encapsulate text that is not to be typed
  as seen or copied-and-pasted.</para>
@y
  <para>
  上の表記は入力するテキストを仮に表現したものです。
  これをそのまま入力するものではないため、コピー、ペースト操作で貼り付けないでください。
  </para>
@z

@x
  <para>This format is used to refer to a specific manual page (hereinafter
  referred to simply as a <quote>man</quote> page). The number inside
  parentheses indicates a specific section inside of <command>man</command>.
  For example, <command>passwd</command> has two man pages. Per CLFS
  installation instructions, those two man pages will be located at
  <filename>/usr/share/man/man1/passwd.1</filename> and
  <filename>/usr/share/man/man5/passwd.5</filename>. Both man pages have
  different information in them. When the book uses
  <filename>passwd(5)</filename> it is specifically referring to
  <filename>/usr/share/man/man5/passwd.5</filename>.
  <command>man passwd</command> will print the first man page it finds
  that matches <quote>passwd</quote>, which will be
  <filename>/usr/share/man/man1/passwd.1</filename>. For this example,
  you will need to run <command>man 5 passwd</command> in order to read
  the specific page being referred to. It should be noted that most man
  pages do not have duplicate page names in different sections. Therefore,
  <command>man <replaceable>[program name]</replaceable></command> is
  generally sufficient.</para>
@y
  <para>
  上の表記はマニュアルページ (<command>man</command> ページ) を参照するものです。
  カッコ内の数字は <command>man</command> の内部で定められている特定のセクションを表しています。
  例えば <command>passwd</command> コマンドには2つのマニュアルページがあります。
  LFS のインストールに従った場合、2つのマニュアルページは <filename>/usr/share/man/man1/passwd.1</filename> と <filename>/usr/share/man/man5/passwd.5</filename> に配置されます。
  この2つの <command>man</command> ページは内容が異なります。
  <filename>passwd(5)</filename> という表記は <filename>/usr/share/man/man5/passwd.5</filename> を参照することを意味します。
  <command>man passwd</command> という入力に対しては<quote>passwd</quote>という語に合致する最初のマニュアルページが表示されるものであり <filename>/usr/share/man/man1/passwd.1</filename> が表示されることになります。
  特定のマニュアルページを見たい場合は <command>man 5 passwd</command> といった入力を行う必要があります。
  マニュアルページが複数あるケースはまれですので、普通は <command>man</command><replaceable>[プログラム名]</replaceable> と入力するだけで十分です。
  </para>
@z