%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>How does Systemd work?</title>
@y
  <title>Systemd がどのようにして動作するか</title>
@z

@x
  <secondary>usage</secondary></indexterm>
@y
  <secondary>利用方法</secondary></indexterm>
@z

@x
    <para>Please disregard this page until it is complete and verified.</para>
@y
    <para>
    このページはシステム構築、動作確認を終えるまでは無視して先に進んでください。
    </para>
@z

@x
    <title>Introduction to Systemd</title>
@y
    <title>Systemd とは</title>
@z

@x
    <para>Systemd is a system management daemon designed exclusively for the
    Linux kernel API. In the Linux startup process, it is the first process to
    execute in user land; therefore, it is also the parent process of all child
    processes in user land.</para>
@y
    <para>
    Systemd はシステムを管理するデーモンであり Linux カーネル API 専用に設計されています。
    Linux の起動中、ユーザーランド (user land) 内において最初に実行されるプロセスです。
    つまりユーザーランド内で実行される子プロセスすべての親プロセスでもあるわけです。
    </para>
@z

@x
    <para>Systemd's initialization instructions for each daemon are recorded in
    a declarative configuration file rather than a shell script. For
    inter-process communication, systemd makes Unix domain sockets and D-Bus
    available to the running daemons. Because systemd tracks processes using
    Linux cgroups instead of process identifiers (PIDs), daemons cannot "escape"
    systemd; not even by double-forking. Systemd is also capable of aggressive
    parallelization.</para>
@y
    <para>
    Systemd の各デーモンの初期化はシェルスクリプトという形ではなく設定を宣言することによりファイルに保存されます。
    プロセス間通信は稼動デーモンに対して Unix ドメインソケットや D-Bus を利用可能とします。
    Systemd によるプロセスの監視はプロセス識別子 (process identifiers; PID) でなく Linux の cgroups を用いて行われます。
    したがってデーモンは systemd から "逃れる" ことはできません。
    たとえダブルフォーク (double-fork) によるものであってもです。
    Systemd は積極的に並行処理を実現する機能もあります。
    </para>
@z

@x
    <para>Among systemd's auxiliary features are a cron-like job scheduler
    called systemd Calendar Timers, and an event logging subsystem called
    journal. The system administrator may choose whether to log system events
    with systemd or syslog. Systemd's logfile is a binary file. The state of
    systemd itself can be preserved in a snapshot for future recall.</para>
@y
    <para>
    Systemd のその他の機能として cron ライクなスケジューラー機能があります。
    これは Systemd のカレンダータイマーと呼ばれます。
    またジャーナルと呼ばれるイベントログサブシステムもあります。
    システム管理者はシステムイベントのログ監視を行うにあたり Systemd と Syslog のいずれかを選ぶことができます。
    Systemd のログファイルはバイナリファイルになります。
    Systemd 自体の状態はスナップショットとして保存可能であり退避と回復を行うことができます。
    </para>
@z

@x
    <para>Systemd provides a replacement for sysvinit, pm-utils, inetd, acpid,
    syslog, watchdog, cron and atd, and obsoletes ConsoleKit.</para>
@y
    <para>
    Systemd は sysvinit, pm-utils, inetd, acpid, syslog, watchdog, cron, atd, すでに古いものとなった ConsoleKit,
    これらすべてにとって代わる機能を提供します。
    </para>
@z

@x
    <title>Systemctl</title>
@y
    <title>Systemctl</title>
@z

@x
    <para><command>systemctl</command> is the main command used to introspect
     and control systemd.</para>
@y
    <para>
    <command>systemctl</command> は systemd を制御するメインのコマンドです。
    </para>
@z

@x
        <term>List running units:</term>
        <listitem>
          <para><command>systemctl</command> or <command>systemctl list-units</command></para>
@y
        <term>起動ユニットの一覧表示:</term>
        <listitem>
          <para><command>systemctl</command> または <command>systemctl list-units</command></para>
@z

@x
        <term>List failed units:</term>
        <listitem>
          <para><command>systemctl --failed</command></para>
@y
        <term>起動に失敗したユニットの一覧表示:</term>
        <listitem>
          <para><command>systemctl --failed</command></para>
@z

@x
        <term>List available unit files:</term>
        <listitem>
          <para><command>systemctl list-unit-files</command></para>
@y
        <term>利用可能なユニットファイルの一覧表示:</term>
        <listitem>
          <para><command>systemctl list-unit-files</command></para>
@z

@x
        <term>Activate a unit immediately:</term>
        <listitem>
          <para><command>systemctl start</command> <replaceable>unit</replaceable></para>
@y
        <term>ユニット実行:</term>
        <listitem>
          <para><command>systemctl start</command> <replaceable>unit</replaceable></para>
@z

@x
        <term>Stop a unit immediately:</term>
        <listitem>
          <para><command>systemctl stop </command><replaceable>unit</replaceable></para>
@y
        <term>ユニット停止:</term>
        <listitem>
          <para><command>systemctl stop </command><replaceable>unit</replaceable></para>
@z

@x
        <term>Restart a unit:</term>
        <listitem>
          <para><command>systemctl restart </command><replaceable>unit</replaceable></para>
@y
        <term>ユニット再起動:</term>
        <listitem>
          <para><command>systemctl restart </command><replaceable>unit</replaceable></para>
@z

@x
        <term>Reload unit configuration:</term>
        <listitem>
          <para><command>systemctl reload </command><replaceable>unit</replaceable></para>
@y
        <term>ユニット設定の再読み込み:</term>
        <listitem>
          <para><command>systemctl reload </command><replaceable>unit</replaceable></para>
@z

@x
        <term>Show status of a unit:</term>
        <listitem>
          <para><command>systemctl status </command><replaceable>unit</replaceable></para>
@y
        <term>ユニットのステータス表示:</term>
        <listitem>
          <para><command>systemctl status </command><replaceable>unit</replaceable></para>
@z

@x
        <term>Check if a unit is enabled or disabled:</term>
        <listitem>
          <para><command>systemctl is-enabled </command><replaceable>unit</replaceable></para>
@y
        <term>ユニットの有効無効の確認:</term>
        <listitem>
          <para><command>systemctl is-enabled </command><replaceable>unit</replaceable></para>
@z

@x
        <term>Enable a unit to start during boot:</term>
        <listitem>
          <para><command>systemctl enable </command><replaceable>unit</replaceable></para>
@y
        <term>ユニットのブート時起動の有効化:</term>
        <listitem>
          <para><command>systemctl enable </command><replaceable>unit</replaceable></para>
@z

@x
        <term>Disable a unit to not start during boot:</term>
        <listitem>
          <para><command>systemctl disable </command><replaceable>unit</replaceable></para>
@y
        <term>ユニットのブート時起動の無効化:</term>
        <listitem>
          <para><command>systemctl disable </command><replaceable>unit</replaceable></para>
@z

@x
        <term>Reload systemd and scan for new or changed units:</term>
        <listitem>
          <para><command>systemctl daemon-reload</command></para>
@y
        <term>systemd 再読み込み、および新たなあるいは修正されたユニットのスキャン:</term>
        <listitem>
          <para><command>systemctl daemon-reload</command></para>
@z

@x
    <para>For more information regarding systemd, please refer to the systemd
    and related man-pages and
    <ulink url="https://fedoraproject.org/wiki/Systemd">Systemd at
    FedoraProject</ulink> for documentation, examples, features, and other
    information.</para>
@y
    <para>
    より詳細については systemd 関連の man ページ、あるいは <ulink
    url="https://fedoraproject.org/wiki/Systemd">Systemd at
    FedoraProject</ulink> を参照して、機能説明や利用例などを確認してください。
    </para>
@z