%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <para>The Linux package contains the Linux kernel.</para>
@y
    <para>
    Linux パッケージは Linux カーネルを提供します。
    </para>
@z

@x
    <title>Installation of the kernel</title>
@y
    <title>&InstallationOf1;カーネル&InstallationOf2;</title>
@z

@x
    <para os="a">Building the kernel involves a few steps&mdash;configuration,
    compilation, and installation. Read the <filename>README</filename>
    file in the kernel source tree for alternative methods to the way this
    book configures the kernel.</para>
@y
    <para os="a">
    カーネルの構築は、カーネルの設定、コンパイル、インストールの順に行っていきます。
    本書が行っているカーネル設定の方法以外については、カーネルソースツリー内にある <filename>README</filename> ファイルを参照してください。
    </para>
@z

@x
    <para os="p1">Apply the latest Linux sublevel patch:</para>
@y
    <para os="p1">
    最新のサブレベルのパッチを適用します。
    </para>
@z

@x
    <para os="b">Prepare for compilation by running the following command:</para>
@y
    <para os="b">
    コンパイルするための準備として以下のコマンドを実行します。
    </para>
@z

@x
    <para os="d">This ensures that the kernel tree is absolutely clean. The
    kernel team recommends that this command be issued prior to each
    kernel compilation. Do not rely on the source tree being clean after
    un-tarring.</para>
@y
    <para os="d">
    これによりカーネルソースが完全にクリーンなものになります。
    カーネル開発チームは、カーネルコンパイルするなら、そのたびにこれを実行することを推奨しています。
    tar コマンドにより伸張しただけのソースではクリーンなものにはなりません。
    </para>
@z

@x
    <note os="kc"><para>A good starting place for setting up the kernel
    configuration is to run <command>make defconfig</command>. This will set the    base configuration to a good state that takes your current system
    architecture into account.</para>
@y
    <note os="kc"><para>
    カーネル設定を行うにあたって、分かりやすいやり方として <command>make defconfig</command> を実行する方法があります。
    これを実行することで基本的な設定がなされ、現在のシステム構成が考慮された、より良い設定が得られるかもしれません。
    </para>
@z

@x
    <para>Be sure to configure the following options as
    shown, or the system might not work correctly or boot at all.
    Refer to <filename>/usr/share/doc/systemd-&systemd-version;/README</filename>:</para>
@y
    <para>
    以下のオプションについての有効無効を確認してください。
    不適切である場合にはシステムが正常動作しなかったり起動できなかったりするかもしれません。
    詳しくは <filename>/usr/share/doc/systemd-&systemd-version;/README</filename> を参照してください。
    </para>
@z

@x
    <note os="kd"><para>While "The IPv6 Protocol" is not strictly required, it
    is highly recommended by the Systemd developers. "EFI Variable support" and
    "EFI GUID Partition support" are for UEFI systems. "Collect scheduler
    debugging info" and "Collect scheduler statistics" is for systemd-bootchart.
    </para></note>
@y
    <note os="kd"><para>
    "The IPv6 Protocol" については厳密には不要としても良いものですが、システム開発者は強く推奨しているものです。
    "EFI Variable support" と "EFI GUID Partition support" は UEFI システムに必要です。
    "Collect scheduler debugging info" と "Collect scheduler statistics" は systemd-bootchart に必要です。
    </para></note>
@z

@x
    <para os="h">Configure the kernel via a menu-driven interface.
    CBLFS has some information regarding particular kernel configuration
    requirements of packages outside of CLFS at <ulink
    url="&cblfs-root;"/>:</para>
@y
    <para os="h">
    メニュー形式のインターフェースによりカーネルを設定します。
    CBLFS には CLFS では取り扱わないパッケージに関して、どのようなカーネル設定が必要かを説明しています。
    <ulink url="&cblfs-root;"/> を参照してください。
    </para>
@z

@x
    <para os="j">Alternatively, <command>make oldconfig</command> may be more
    appropriate in some situations. See the <filename>README</filename>
    file for more information.</para>
@y
    <para os="j">
    上のコマンドではなく、状況によっては <command>make oldconfig</command> を実行することが適当な場合もあります。
    詳細についてはカーネルソース内の <filename>README</filename> ファイルを参照してください。
    </para>
@z

@x
    <para os="k">If desired, skip kernel configuration by copying the kernel
    config file, <filename>.config</filename>, from the host system
    (assuming it is available) to the root directory of the unpacked kernel
    sources. However, we do not recommend this option. It is often better
    to explore all the configuration menus and create the kernel configuration
    from scratch.</para>
@y
    <para os="k">
    カーネル設定は行わずに、ホストシステムにあるカーネル設定ファイル <filename>.config</filename> をコピーして利用することもできます。
    そのファイルが存在すればの話です。
    その場合は <filename class="directory">linux-&linux-version;</filename> ディレクトリにそのファイルをコピーしてください。
    もっともこのやり方はお勧めしません。
    設定項目をメニューから探し出して、カーネル設定を一から行っていくことが望ましいことです。
    </para>
@z

@x
    <para os="m">Compile the kernel image and modules:</para>
@y
    <para os="m">
    カーネルイメージとモジュールをコンパイルします。
    </para>
@z

@x
    <para os="o">If using kernel modules, a configuration file in
    <filename class="directory">/etc/modprobe.d</filename> file may be needed.
    Information pertaining to modules and kernel configuration is
    located in the kernel documentation in the <filename
    class="directory">Documentation</filename> directory of the kernel
    sources tree. Also, <filename>modprobe.d(5)</filename> may
    be of interest.</para>
@y
    <para os="o">
    カーネルモジュールを利用する場合 <filename class="directory">/etc/modprobe.d</filename> ディレクトリ内での設定を必要とします。
    モジュールやカーネル設定に関する情報はカーネルソースの <filename
    class="directory">Documentation</filename> ディレクトリにあるカーネルドキュメントを参照してください。
    また <filename>modprobe.d(5)</filename> も有用です。
    </para>
@z

@x
    <para os="s">Install the modules, if the kernel configuration uses
    them:</para>
@y
    <para os="s">
    カーネル設定にてモジュールを利用している場合はこれをインストールします。
    </para>
@z

@x
    <para os="s2">Install the firmware, if the kernel configuration uses
    them:</para>
@y
    <para os="s2">
    カーネル設定にてファームウェアを利用している場合はこれをインストールします。
    </para>
@z

@x
    <para os="u">After kernel compilation is complete, additional steps are
    required to complete the installation. Some files need to be copied to
    the <filename class="directory">/boot</filename> directory.</para>
@y
    <para os="u">
    カーネルのコンパイルが終わったら、インストールの完了に向けてあと少し作業を行います。
    <filename class="directory">/boot</filename> ディレクトリにいくつかのファイルをコピーします。
    </para>
@z

@x
    <para os="v">Issue the following command to install the kernel:</para>
@y
    <para os="v">
    以下のコマンドを実行してカーネルをインストールします。
    </para>
@z

@x
    <para os="w"><filename>System.map</filename> is a symbol file for the kernel.
    It maps the function entry points of every function in the kernel API,
    as well as the addresses of the kernel data structures for the running
    kernel. Issue the following command to install the map file:</para>
@y
    <para os="w">
    <filename>System.map</filename> はカーネルに対するシンボルファイルです。
    このファイルはカーネル API の各関数のエントリポイントをマッピングしています。
    同様に実行中のカーネルのデータ構成のアドレスを保持します。
    マップファイルをインストールするには以下を実行します。
    </para>
@z

@x
    <para os="x">The kernel configuration file <filename>.config</filename>
    produced by the <command>make menuconfig</command> step above contains
    all the configuration selections for the kernel that was just compiled.
    It is a good idea to keep this file for future reference:</para>
@y
    <para os="x">
    カーネル設定ファイル <filename>.config</filename> は、上で実行した <command>make menuconfig</command> によって生成されます。
    このファイル内には、今コンパイルしたカーネルの設定項目の情報がすべて保持されています。
    将来このファイルを参照する必要が出てくるかもしれないため、このファイルを保存しておきます。
    </para>
@z

@x
    <para os="y">It is important to note that the files in the kernel source
    directory are not owned by <systemitem class="username">root</systemitem>.
    Whenever a package is unpacked as user <systemitem
    class="username">root</systemitem> (like we do inside the final-system
    build environment), the files have the user and group IDs of whatever
    they were on the packager's computer. This is usually not a problem
    for any other package to be installed because the source tree is
    removed after the installation. However, the Linux source tree is
    often retained for a long time. Because of this, there is a chance
    that whatever user ID the packager used will be assigned to somebody
    on the machine. That person would then have write access to the kernel
    source.</para>
@y
    <para os="y">
    カーネルのソースディレクトリは所有者が <systemitem class="username">root</systemitem> ユーザーになっていません。
    我々は最終システムのビルド環境内の <systemitem
    class="username">root</systemitem> ユーザーとなってパッケージを展開してきましたが、展開されたファイル類はパッケージ開発者が用いていたユーザー ID、グループ ID が適用されています。
    このことは普通はあまり問題になりません。
    というのもパッケージをインストールした後のソースファイルは、たいていは削除するからです。
    一方 Linux のソースファイルは、削除せずに保持しておくことがよく行われます。
    このことがあるため開発者の用いたユーザーIDが、インストールしたマシン内の誰かの ID に割り当たった状態となりえます。
    その人はカーネルソースを自由に書き換えてしまう権限を持つことになるわけです。
    </para>
@z

@x
    <para os="y1">If the kernel source tree is going to retained, run
    <command>chown -R 0:0</command> on the <filename
    class="directory">linux-&linux-version;</filename> directory to
    ensure all files are owned by user <systemitem
    class="username">root</systemitem>.</para>
@y
    <para os="y1">
    カーネルのソースファイルを保持しておくつもりなら <filename
    class="directory">linux-&linux-version;</filename> ディレクトリにおいて <command>chown -R 0:0</command> を実行しておいてください。
    これによりそのディレクトリの所有者は <systemitem
    class="username">root</systemitem> ユーザーとなります。
    </para>
@z

@x
      <para>Some kernel documentation recommends creating a symlink from
      <filename class="symlink">/usr/src/linux</filename> pointing to the
      kernel source directory. This is specific to kernels prior to the
      2.6 series and <emphasis>must not</emphasis> be created on a CLFS
      system as it can cause problems for packages you may wish to build
      once your base CLFS system is complete.</para>
@y
      <para>
      カーネルを説明する書の中には、カーネルのソースディレクトリに対してシンボリックリンク <filename
      class="symlink">/usr/src/linux</filename> の生成を勧めているものがあります。
      これはカーネル 2.6 系以前におけるものであり CLFS システム上では生成<emphasis>してはなりません </emphasis>。
      ベースとなる CLFS システムを構築し、そこに新たなパッケージを追加していこうとした際に、そのことが問題となるからです。
      </para>
@z

@x
      <para>Also, the headers in the system's <filename
      class="directory">include</filename> directory should
      <emphasis>always</emphasis> be the ones against which Glibc was
      compiled and should <emphasis>never</emphasis> be replaced by headers
      from a different kernel version.</para>
@y
      <para>
      さらに <filename
      class="directory">include</filename> ディレクトリにあるヘッダーファイルは、<emphasis>必ず</emphasis> Glibc のコンパイル時のものでなければなりません。
      つまり<emphasis>絶対に</emphasis> 他のバージョンのカーネルのものに置き換えてはなりません。
      </para>
@z

@x
    <title>Contents of Linux</title>
@y
    <title>&ContentsOf1;Linux &ContentsOf2;</title>
@z

@x
      <segtitle>Installed files</segtitle>
      <segtitle>Installed directory</segtitle>
@y
      <segtitle>&InstalledFile;</segtitle>
      <segtitle>&InstalledDirectory;</segtitle>
@z

@x
        <seg>config-[linux-version], clfskernel-[linux-version],
        and System.map-[linux-version]</seg>
        <seg>/lib/modules</seg>
@y
        <seg>config-[linux-version], clfskernel-[linux-version],
        and System.map-[linux-version]</seg>
        <seg>/lib/modules</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x config-[linux-version]
          <para>Contains all the configuration selections for the kernel</para>
@y
          <para>
          カーネルの設定をすべて含みます。
          </para>
@z

@x clfskernel-[linux-version]
          <para>The engine of the Linux system. When turning on the
          computer, the kernel is the first part of the operating system
          that gets loaded. It detects and initializes all components of
          the computer's hardware, then makes these components available
          as a tree of files to the software and turns a single CPU into
          a multitasking machine capable of running scores of programs
          seemingly at the same time.</para>
@y
          <para>
          Linux システムのエンジンです。
          コンピューターを起動した際には、オペレーティングシステム内にて最初にロードされるものです。
          カーネルはコンピューターのハードウェアを構成するあらゆるコンポーネントを検知して初期化します。
          そしてそれらのコンポーネントをツリー階層のファイルとして、ソフトウェアが利用できるようにします。
          ただひとつの CPU からマルチタスクを処理するマシンとして、あたかも多数のプログラムが同時稼動しているように仕向けます。
          </para>
@z

@x System.map-[linux-version]
          <para>A list of addresses and symbols; it maps the entry points
          and addresses of all the functions and data structures in the
          kernel</para>
@y
          <para>
          アドレスとシンボルのリストです。
          カーネル内のすべての関数とデータ構成のエントリポイントおよびアドレスを示します。
          </para>
@z