%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <para>The Glibc package contains the main C library. This library provides
    the basic routines for allocating memory, searching directories, opening and
    closing files, reading and writing files, string handling, pattern matching,
    arithmetic, and so on.</para>
@y
    <para>
    Glibc パッケージは主要な C ライブラリを提供します。
    このライブラリは基本的な処理ルーチンを含むもので、メモリ割り当て、ディレクトリ走査、ファイルのオープン、クローズや入出力、文字列操作、パターンマッチング、算術処理、等々があります。
    </para>
@z

@x
    <title>Installation of Glibc</title>
@y
    <title>&InstallationOf1;Glibc &InstallationOf2;</title>
@z

@x
      <para>Some packages outside of CLFS suggest installing GNU libiconv in
      order to translate data from one encoding to another. The project's
      home page (<ulink url="http://www.gnu.org/software/libiconv/"/>) says
      <quote>This library provides an <function>iconv()</function>
      implementation, for use on systems which don't have one, or whose
      implementation cannot convert from/to Unicode.</quote> Glibc provides
      an <function>iconv()</function> implementation and can convert from/to
      Unicode, therefore libiconv is not required on a CLFS system.</para>
@y
      <para>
      CLFS が取り扱っていないパッケージの中には GNU libiconv の導入を推奨しているものがあります。
      これは文字データのエンコーディングを変換する機能を持ちます。
      プロジェクトのホームページ (<ulink url="http://www.gnu.org/software/libiconv/"/>) には以下のような説明があります。
      <quote>このライブラリは <function>iconv()</function> 関数を提供します。
      この関数を持たないシステムや、Unicode を取り扱うことができないシステムにて、この関数を利用することができます。</quote>
      Glibc が <function>iconv()</function> 関数を用意しており Unicode の変換を実現しているため CLFS では libiconv は用いないことにします。
      </para>
@z

@x
    <para os="l1">At the end of the installation, the build system will run
    a sanity test to make sure everything installed properly. This script
    performs its tests by attempting to compile test programs against certain
    libraries. However it does not specify the path to
    <filename class="libraryfile">ld.so</filename>, and our toolchain
    is still configured to use the one in
    <filename class="directory">/tools</filename>. The following set of
    commands will force the script to use the complete path of the new
    <filename class="libraryfile">ld.so</filename> that was just installed:</para>
@y
    <para os="l1">
    インストール作業の最後には健全性テスト (sanity test) を実行し、すべてが適切にインストールされているかを確認します。
    このスクリプトは所定のライブラリを用いてテストプログラムをコンパイルします。
    しかしこのとき <filename
    class="libraryfile">ld.so</filename> へのパスが指定されないため、ツールチェーンの一部が <filename
    class="directory">/tools</filename> にあるまま利用されてしまいます。
    以下の一連のコマンドを実行することで、インストールしたばかりの新しい <filename
    class="libraryfile">ld.so</filename> を利用するように変更します。
    </para>
@z

@x
    <para os="b">The Glibc build system is self-contained and will install
    perfectly, even though the compiler specs file and linker are still
    pointing at <filename class="directory">/tools</filename>. The specs
    and linker cannot be adjusted before the Glibc install because the
    Glibc Autoconf tests would give false results and defeat the goal
    of achieving a clean build.</para>
@y
    <para os="b">
    Glibc ビルドシステムは自らによってビルドされるものであり、コンパイラースペックファイルがたとえ <filename
    class="directory">/tools</filename> を指し示していたままであっても完璧にビルドされます。
    スペックやリンカーは Glibc のインストール後でないと調整できません。
    これは Glibc の Autoconf テストが失敗するからであり、クリーンビルドを成功させるという目標が達成できないためです。
    </para>
@z

@x
    <para os="e">The Glibc documentation recommends building Glibc outside of     the source directory in a dedicated build directory:</para>
@y
    <para os="e">
    Glibc のドキュメントではソースディレクトリ以外の専用のビルドディレクトリを作成することが推奨されています。
    </para>
@z

@x
    <para os="g">Prepare Glibc for compilation:</para>
@y
    <para os="g">&PreparePackage1;Glibc &PreparePackage2;</para>
@z

@x
      <title>The meaning of the new configure option:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x --libexecdir=/usr/lib/glibc
          <para>This changes the location for hard links to the
          <command>getconf</command> utility from their default of <filename
          class="directory">/usr/libexec</filename> to <filename
          class="directory">/usr/lib/glibc</filename>.</para>
@y
          <para>
          <command>getconf</command> ユーティリティーへのハードリンクのインストールディレクトリを、デフォルトの <filename
          class="directory">/usr/libexec</filename> でなく <filename
          class="directory">/usr/lib/glibc</filename> に変更します。
          </para>
@z

@x
    <para os="j">Compile the package:</para>
@y
    <para os="j">&CompileThePackage;</para>
@z

@x
      <para>Due to Glibc's critical role in a properly functioning system,
      the CLFS developers strongly recommend running the testsuite.</para>
@y
      <para>
      Glibc にはシステムを適切に動作させるための重要な役割があります。
      CLFS 開発者はテストスイートを実行することを強く勧めます。
      </para>
@z

@x
    <para os="m">Use the following commands to run the test suite and output
    any test failures:</para>
@y
    <para os="m">
    以下のコマンドによりテストスイートを実行します。
    テストに失敗すると画面出力されます。
    </para>
@z

@x
    <para os="o">The Glibc test suite is highly dependent on certain functions of
    the host system, in particular the kernel. The <emphasis>posix/annexc</emphasis> and
    <emphasis>conform/run-conformtest</emphasis> tests normally fail
    and you should see <literal>Error 1 (ignored)</literal> in the output. Apart
    from this, the Glibc test suite is always expected to pass. However, in certain
    circumstances, some failures are unavoidable. If a test fails because of a missing
    program (or missing symbolic link), or a segfault, you will see an error code
    greater than 127 and the details will be in the log. More commonly, tests will
    fail with <literal>Error 2</literal> - for these, the contents of the corresponding
    <filename>.out</filename> file, e.g. <filename>posix/annexc.out</filename> may be
    informative. Here is a list of the most common issues:</para>
@y
    <para os="o">
    Glibc のテストスイートはホストシステムの特定の機能、特にカーネルに大きく依存しています。
    <emphasis>posix/annexc</emphasis> と <emphasis>conform/run-conformtest</emphasis> はおそらく失敗し <literal>Error 1 (ignored)</literal> と出力されます。
    これを除くと Glibc のテストスイートは成功するのが通常です。
    しかし特定の環境下において失敗するものがあり回避できません。
    テストが失敗する理由としてプログラムが存在していなかったり (シンボリックリンクがなかったり) セグメンテーションフォールトが発生したりする場合はログファイルを見ると分かります。
    ログファイルには 128 以上のエラーコードとエラー詳細が出力されています。
    さらに <literal>Error 2</literal> のエラーが発生する場合は <filename>.out</filename> ファイルの内容、例えば <filename>posix/annexc.out</filename> に詳しい情報が示されているはずです。
    発生しがちな問題を以下に示します。
    </para>
@z

@x
        <para>The <emphasis>nptl/tst-clock2</emphasis>,
        <emphasis>nptl/tst-attr3</emphasis>,
        <emphasis>tst/tst-cputimer1</emphasis>, and
        <emphasis>rt/tst-cpuclock2</emphasis>
        tests have been known to fail.  The
        reason is not completely understood, but indications are that minor
        timing issues can trigger these failures.</para>
@y
        <para>
        <emphasis>nptl/tst-clock2</emphasis>,
        <emphasis>nptl/tst-attr3</emphasis>,
        <emphasis>tst/tst-cputimer1</emphasis>,
        <emphasis>rt/tst-cpuclock2</emphasis> のテストは失敗することが知られています。
        失敗の理由は明確ではありません。
        ただ処理速度が原因してそれらが発生すると思われます。
        </para>
@z

@x
        <para>The <emphasis>math</emphasis> tests sometimes fail.
        Certain optimization settings are known to be a
        factor here.</para>
@y
        <para>
        <emphasis>math</emphasis> テストにて失敗するものがあります。
        特定の最適化設定が原因であると思われます。
        </para>
@z

@x
        <para>If you have mounted the CLFS partition with the
        <parameter>noatime</parameter> option, the <emphasis>atime</emphasis> test
        will fail. As mentioned in <xref linkend="ch-partitioning-mounting"/>,
        do not use the <parameter>noatime</parameter> option while building
        CLFS.</para>
@y
        <para>
        CLFS パーティションを <parameter>noatime</parameter> オプションを用いてマウントしている場合 <emphasis>atime</emphasis> テストが失敗します。
        <xref linkend="ch-partitioning-mounting"/> で説明しているように、CLFS のビルド中は <parameter>noatime</parameter> オプションを使わないようにしてください。
        </para>
@z

@x
        <para>When running on older and slower hardware, some tests
        can fail because of test timeouts being exceeded.
        Modifying the make check command to set a TIMEOUTFACTOR is reported to
        help eliminate these errors (e.g. <command>TIMEOUTFACTOR=16
        make -k check</command>).</para>
@y
        <para>
        旧式のハードウェアや性能の低いハードウェア、あるいは負荷の高いシステムにおいてテストを行うと、処理時間をオーバーしてタイムアウトが発生しテストが失敗します。
        make check コマンドにて TIMEOUTFACTOR をセットするものに修正すれば、それらのエラーは回避できると報告されています。
        (例： <command>TIMEOUTFACTOR=16 make -k check</command>)
        </para>
@z

@x
        <para>posix/tst-getaddrinfo4 will always fail due to not having a network
        connection when the test is run.</para>
@y
        <para>
        posix/tst-getaddrinfo4 は、テスト実行時にネットワークに接続されていないため失敗します。
        </para>
@z

@x
    <para os="q">Though it is a harmless message, the install stage of Glibc will
    complain about the absence of <filename>/etc/ld.so.conf</filename>.
    Prevent this warning with:</para>
@y
    <para os="q">
    支障が出る話ではありませんが Glibc のインストール時には <filename>/etc/ld.so.conf</filename> ファイルが存在していないとして警告メッセージが出力されます。
    これをなくすために以下を実行します。
    </para>
@z

@x
    <para os="s">Install the package, and remove unneeded files from
    <filename class="directory">/usr/include/rpcsvc</filename>:</para>
@y
    <para os="s">
    パッケージをインストールします。
    また <filename class="directory">/usr/include/rpcsvc</filename> にある不要なファイルを削除します。
    </para>
@z

@x
    <para os="u">Install the configuration file and runtime directory for
    <command>nscd</command>:</para>
@y
    <para os="u">
    設定ファイルをインストールします。
    また <command>nscd</command> の実行時に利用されるディレクトリを生成します。
    </para>
@z

@x
    <para os="w">Install the systemd support files for <command>nscd</command>:</para>
@y
    <para os="w">
    <command>nscd</command> に対する systemd サポートファイルをインストールします。
    </para>
@z

@x
    <title>Internationalization</title>
@y
    <title>国際化</title>
@z

@x
    <para>The locales that can make the system respond in a different
    language were not installed by the above command. Install them
    with:</para>
@y
    <para>
    システムを各種の言語に対応させるためのロケールは、今までのコマンドではインストールされません。
    以下によりこれをインストールします。
    </para>
@z

@x
    <para>To save time, an alternative to running the previous command (which
    generates and installs every locale listed in the
    <filename>glibc-&glibc-version;/localedata/SUPPORTED</filename> file) is
    to install only those locales that are wanted and needed. This can be
    achieved by using the <command>localedef</command> command. Information on
    this command is located in the <filename>INSTALL</filename> file in the
    Glibc source. However, there are a number of locales that are essential in
    order for the tests of future packages to pass, in particular, the
    <emphasis>libstdc++</emphasis> tests from GCC. The following instructions,
    instead of the <parameter>install-locales</parameter> target used above,
    will install the minimum set of locales necessary for the tests to run
    successfully:</para>
@y
    <para>
    上のコマンドは <filename>glibc-&glibc-version;/localedata/SUPPORTED</filename> ファイルに示された全ロケールを生成しインストールします。
    そうするのではなく時間節約のために必要なロケールのみをインストールすることもできます。
    <command>localedef</command> コマンドを利用します。
    このコマンドの利用方法は Glibc ソース内の <filename>INSTALL</filename> ファイルに示されています。
    もっとも今後のパッケージビルド時のテストにおいては数多くのロケールを生成しておかないとテストが成功しません。
    特に GCC の <emphasis>libstdc++</emphasis> テストなどです。
    上で示した <parameter>install-locales</parameter> ターゲットによるビルドではなく以下に示すコマンドを実行すれば、
    テストを成功させるために必要となる最低限のロケールをインストールすることができます。
    </para>
@z

@x
    <para>Some locales installed by the <command>make
    localedata/install-locales</command> command above are not properly
    supported by some applications that are in CLFS and CBLFS. Because
    of the various problems that arise due to application programmers making
    assumptions that break in such locales, CLFS should not be used in locales
    that utilize multibyte character sets (including UTF-8) or right-to-left
    writing order.  Numerous unofficial and unstable patches are required to
    fix these problems, and it has been decided by the CLFS developers not to
    support such complex locales at this time. This applies to the ja_JP and
    fa_IR locales as well&mdash;they have been installed only for GCC and
    Gettext tests to pass, and the <command>watch</command> program (part of
    the Procps-ng package) does not work properly in them. Various attempts to
    circumvent these restrictions are documented in internationalization-related
    hints.</para>
@y
    <para>
    上の <command>make
    localedata/install-locales</command> コマンドによってインストールされるロケールの中には CLFS や CBLFS の取り扱うアプリケーションが適切にサポートできないものがあります。
    これはさまざまなアプリケーションの開発者がロケールに対して間違った扱いをしているために起きます。
    したがって CLFS ではマルチバイトキャラクターセット (UTF-8 など) や、左から右へ記述する言語ロケールは使用するべきではありません。
    この問題を解決するにはパッチを適用しなければならず、多くの非公式なもの不安定なものを用いることになります。
    CLFS 開発者は今のところ、こういった複雑なロケールのサポートは見送ることにしています。
    サポートしないと言えば ja_JP や fa_IR といったロケールも同様です。
    このロケールは GCC と Gettext のテストを成功させるためにインストールしました。
    ただし <command>watch</command> プログラム (Procps-ng パッケージ) はそのロケールにおいては適切に動作しません。
    こういった複雑な状況を何とか解決しようと、国際化関連のヒントとしてまとめられています。
    </para>
@z

@x
    <title>Configuring Glibc</title>
@y
    <title>&Configuring1;Glibc &Configuring2;</title>
@z

@x
    <para>The <filename>/etc/nsswitch.conf</filename> file needs to be created
    because, although Glibc provides defaults when this file is missing or
    corrupt, the Glibc defaults do not work well in a networked environment.
    The time zone also needs to be configured.</para>
@y
    <para>
    <filename>/etc/nsswitch.conf</filename> ファイルを作成しておく必要があります。
    Glibc はこのファイルがなかったり壊れていたりしてもデフォルト値を採用します。
    しかしそのデフォルト値ではネットワーク環境下にて Glibc が正しく動作しません。
    タイムゾーンデータも設定おく必要があります。
    </para>
@z

@x
    <para>Create a new file <filename>/etc/nsswitch.conf</filename> by running
    the following:</para>
@y
    <para>
    以下のコマンドを実行して <filename>/etc/nsswitch.conf</filename> ファイルを生成します。
    </para>
@z

@x
    <para>Install timezone data:</para>
@y
    <para>
    タイムゾーンデータをインストールします。
    </para>
@z

@x
      <title>The meaning of the zic commands:</title>
@y
      <title>&MeaningOfCommand1;zic &MeaningOfCommand2;</title>
@z

@x zic -L /dev/null ...
          <para>This creates posix timezones, without any leap seconds.  It is
          conventional to put these in both
          <filename class="directory">zoneinfo</filename> and
          <filename class="directory">zoneinfo/posix</filename>. It is
          necessary to put the POSIX timezones in
          <filename class="directory">zoneinfo</filename>, otherwise various
          test-suites will report errors. On an embedded system, where space is
          tight and you do not intend to ever update the timezones, you could save
          1.9MB by not using the <filename class="directory">posix</filename>
          directory, but some applications or test-suites might give less good
          results</para>
@y
          <para>
          うるう秒を含まない posix タイムゾーンデータを生成します。
          これらは <filename class="directory">zoneinfo</filename> や <filename
          class="directory">zoneinfo/posix</filename> に収容するものとして適切なものです。
          <filename class="directory">zoneinfo</filename> へは POSIX 準拠のタイムゾーンデータを含めることが必要であり、こうしておかないと数々のテストスイートにてエラーが発生してしまいます。
          組み込みシステムなどでは容量の制約が厳しいため、タイムゾーンデータはあまり更新したくない場合があり、<filename
          class="directory">posix</filename> ディレクトリを設けなければ 1.9 MB もの容量を節約できます。
          ただしアプリケーションやテストスイートによっては、エラーが発生するかもしれません。
          </para>
@z

@x zic -L leapseconds ...
          <para>This creates right timezones, including leap seconds. On an
          embedded system, where space is tight and you do not intend to
          ever update the timezones, or care about the correct time, you could
          save 1.9MB by omitting the <filename class="directory">right</filename>
          directory.</para>
@y
          <para>
          うるう秒を含んだ正しいタイムゾーンデータを生成します。
          組み込みシステムなどでは容量の制約が厳しいため、タイムゾーンデータはあまり更新したくない場合や、さほど気にかけない場合もあります。
          <filename class="directory">right</filename> ディレクトリを省略することにすれば 1.9MB の容量を節約することができます。
          </para>
@z

@x zic ... -p ...
          <para>This creates the <filename>posixrules</filename> file. We use
          New York because POSIX requires the daylight savings time rules
          to be in accordance with US rules.</para>
@y
          <para>
          <filename>posixrules</filename> ファイルを生成します。
          ここでは New York を用います。
          POSIX では、日中の保存時刻として US ルールに従うことを規程しているためです。
          </para>
@z

@x
    <para>To determine the local time zone, run the following script:</para>
@y
    <para>
    ローカルのタイムゾーンを確認するには以下のスクリプトを実行します。
    </para>
@z

@x
    <para>After answering a few questions about the location, the script will
    output the name of the time zone (e.g., <emphasis>EST5EDT</emphasis> or
    <emphasis>Canada/Eastern</emphasis>). Then create the
    <filename>/etc/localtime</filename> file by running:</para>
@y
    <para>
    地域情報を設定するためにいくつか尋ねられるのでそれに答えます。
    このスクリプトはタイムゾーン名を表示します。
    (例えば <emphasis>EST5EDT</emphasis>、<emphasis>Canada/Eastern</emphasis> などです。)
    以下のコマンドにより <filename>/etc/localtime</filename> ファイルを生成します。
    </para>
@z

@x
    <para>Replace <replaceable>[xxx]</replaceable> with the name of the time zone
    that <command>tzselect</command> provided (e.g., Canada/Eastern).</para>
@y
    <para>
    <replaceable>[xxx]</replaceable> の部分は <command>tzselect</command> により得られたタイムゾーンの名前 (例えば Canada/Eastern など) に置き換えてください。
    </para>
@z

@x
    <title>Configuring The Dynamic Loader</title>
@y
    <title>&Configuring1;ダイナミックローダー&Configuring2;</title>
@z

@x
    <para os="ld-a">By default, the dynamic loader (<filename
    class="libraryfile">/lib/ld-linux.so.2</filename>) searches through
    <filename class="directory">/lib</filename> and <filename
    class="directory">/usr/lib</filename> for dynamic libraries that are
    needed by programs as they are run. However, if there are libraries in
    directories other than <filename class="directory">/lib</filename> and
    <filename class="directory">/usr/lib</filename>, these need to be
    added to the <filename>/etc/ld.so.conf</filename> file in order
    for the dynamic loader to find them. Two directories that are commonly
    known to contain additional libraries are <filename
    class="directory">/usr/local/lib</filename> and <filename
    class="directory">/opt/lib</filename>, so add those directories to the
    dynamic loader's search path.</para>
@y
    <para os="ld-a">
    ダイナミックリンカー (<filename
    class="libraryfile">/lib/ld-linux.so.2</filename>) がダイナミックライブラリを検索するデフォルトのディレクトリは <filename
    class="directory">/lib</filename> ディレクトリと <filename
    class="directory">/usr/lib</filename> ディレクトリです。
    各種プログラムが実行される際にはここから検索されたダイナミックライブラリがリンクされます。
    もし <filename class="directory">/lib</filename> や <filename
    class="directory">/usr/lib</filename> 以外のディレクトリにライブラリファイルがあるなら <filename>/etc/ld.so.conf</filename> ファイルに記述を追加して、ダイナミックローダーが探し出せるようにしておくことが必要です。
    追加のライブラリが配置されるディレクトリとしては <filename
    class="directory">/usr/local/lib</filename> ディレクトリと <filename
    class="directory">/opt/lib</filename> ディレクトリという二つがよく利用されます。
    ダイナミックローダーの検索パスとしてこのようなディレクトリを追加します。
    </para>
@z

@x
    <para os="ld-b">Create a new file <filename>/etc/ld.so.conf</filename> by running the
    following:</para>
@y
    <para os="ld-b">
    以下のコマンドを実行して <filename>/etc/ld.so.conf</filename> ファイルを新たに生成します。
    </para>
@z

@x
    <title>Contents of Glibc</title>
@y
    <title>&ContentsOf1;Glibc &ContentsOf2;</title>
@z

@x
      <segtitle>Installed programs</segtitle>
      <segtitle>Installed libraries</segtitle>
      <segtitle>Installed directories</segtitle>
@y
      <segtitle>&InstalledProgram;</segtitle>
      <segtitle>&InstalledLibrary;</segtitle>
      <segtitle>&InstalledDirectory;</segtitle>
@z

@x
        <seg>catchsegv, gencat, getconf, getent, iconv, iconvconfig, ldconfig,
        ldd, lddlibc4, locale, localedef, makedb, mtrace, nscd,
        pcprofiledump, pldd, rpcgen, sln, sotruss, sprof, tzselect, xtrace,
        zdump, zic</seg>
        <seg>ld.so, libBrokenLocale.[a,so], libSegFault.so, libanl.[a,so],
        libc.[a,so], libc_nonshared.a, libcidn.[a,so], libcrypt.[a,so],
        libdl.[a,so], libg.a, libieee.a, libm.[a,so], libmcheck.a,
        libmemusage.so, libnsl.a, libnss_compat.so, libnss_dns.so,
        libnss_files.so, libnss_hesiod.so, libnss_nis.so, libnss_nisplus.so,
        libpcprofile.so, libpthread.[a,so], libpthread_nonshared.a,
        libresolv.[a,so], librpcsvc.a, librt.[a,so], libthread_db.so,
        libutil.[a,so]</seg>
        <seg>/usr/include/arpa, /usr/include/bits, /usr/include/gnu,
        /usr/include/net, /usr/include/netash, /usr/include/netatalk,
        /usr/include/netax25, /usr/include/neteconet, /usr/include/netinet,
        /usr/include/netipx, /usr/include/netiucv, /usr/include/netpacket,
        /usr/include/netrom, /usr/include/netrose, /usr/include/nfs,
        /usr/include/protocols, /usr/include/rpc, /usr/include/rpcsvc,
        /usr/include/scsi, /usr/include/sys, /usr/lib/audit, /usr/lib/gconv,
        /usr/lib/glibc, /usr/lib/locale, /usr/share/i18n, /usr/share/zoneinfo,
        /var/cache/ldconfig, /var/cache/nscd</seg>
@y
        <seg>catchsegv, gencat, getconf, getent, iconv, iconvconfig, ldconfig,
        ldd, lddlibc4, locale, localedef, makedb, mtrace, nscd,
        pcprofiledump, pldd, rpcgen, sln, sotruss, sprof, tzselect, xtrace,
        zdump, zic</seg>
        <seg>ld.so, libBrokenLocale.[a,so], libSegFault.so, libanl.[a,so],
        libc.[a,so], libc_nonshared.a, libcidn.[a,so], libcrypt.[a,so],
        libdl.[a,so], libg.a, libieee.a, libm.[a,so], libmcheck.a,
        libmemusage.so, libnsl.a, libnss_compat.so, libnss_dns.so,
        libnss_files.so, libnss_hesiod.so, libnss_nis.so, libnss_nisplus.so,
        libpcprofile.so, libpthread.[a,so], libpthread_nonshared.a,
        libresolv.[a,so], librpcsvc.a, librt.[a,so], libthread_db.so,
        libutil.[a,so]</seg>
        <seg>/usr/include/arpa, /usr/include/bits, /usr/include/gnu,
        /usr/include/net, /usr/include/netash, /usr/include/netatalk,
        /usr/include/netax25, /usr/include/neteconet, /usr/include/netinet,
        /usr/include/netipx, /usr/include/netiucv, /usr/include/netpacket,
        /usr/include/netrom, /usr/include/netrose, /usr/include/nfs,
        /usr/include/protocols, /usr/include/rpc, /usr/include/rpcsvc,
        /usr/include/scsi, /usr/include/sys, /usr/lib/audit, /usr/lib/gconv,
        /usr/lib/glibc, /usr/lib/locale, /usr/share/i18n, /usr/share/zoneinfo,
        /var/cache/ldconfig, /var/cache/nscd</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x catchsegv
          <para>Can be used to create a stack trace when a program
          terminates with a segmentation fault</para>
@y
          <para>
          プログラムがセグメンテーションフォールトにより停止した時に、スタックトレースを生成するために利用します。
          </para>
@z

@x gencat
          <para>Generates message catalogues</para>
@y
          <para>
          メッセージカタログを生成します。
          </para>
@z

@x getconf
          <para>Displays the system configuration values for file system specific
          variables</para>
@y
          <para>
          ファイルシステムに固有の変数に設定された値を表示します。
          </para>
@z

@x getent
          <para>Gets entries from an administrative database</para>
@y
          <para>
          管理データベースから設定項目を取得します。
          </para>
@z

@x iconv
          <para>Performs character set conversion</para>
@y
          <para>
          キャラクターセットを変換します。
          </para>
@z

@x iconvconfig
          <para>Creates fastloading <command>iconv</command> module configuration
          files</para>
@y
          <para>
          高速ロードができる <command>iconv</command> モジュール設定ファイルを生成します。
          </para>
@z

@x ldconfig
          <para>Configures the dynamic linker runtime bindings</para>
@y
          <para>
          ダイナミックリンカーの実行時バインディングを設定します。
          </para>
@z

@x ldd
          <para>Reports which shared libraries are required
          by each given program or shared library</para>
@y
          <para>
          指定したプログラムまたは共有ライブラリが必要としている共有ライブラリを表示します。
          </para>
@z

@x lddlibc4
          <para>Assists <command>ldd</command> with object files</para>
@y
          <para>
          オブジェクトファイルを使って <command>ldd</command> コマンドを補助します。[訳註：意味不明]
          </para>
@z

@x locale
          <para>Tells the compiler to enable or disable the use of POSIX locales
          for built-in operations</para>
@y
          <para>
          組み込み操作に対して POSIX ロケール利用の有効無効をコンパイラーに提供します。
          </para>
@z

@x localedef
          <para>Compiles locale specifications</para>
@y
          <para>
          ロケールの設定をコンパイルします。
          </para>
@z

@x makedb
          <para>Creates a simple database from textual input</para>
@y
          <para>
          テキストを入力として単純なデータベースを生成します。
          </para>
@z

@x mtrace
          <para>Reads and interprets a memory trace file and
          displays a summary in human-readable format</para>
@y
          <para>
          メモリトレースファイル (memory trace file) を読み込んで解釈します。
          そして可読可能な書式で出力します。
          </para>
@z

@x nscd
          <para>A daemon that provides a cache for the most common name
          service requests</para>
@y
          <para>
          一般的なネームサービスへの変更要求のキャッシュを提供するデーモン。
          </para>
@z

@x pcprofiledump
          <para>Dumps information generated by PC profiling</para>
@y
          <para>
          PC プロファイリングにより生成された情報をダンプします。
          </para>
@z

@x pldd
          <para>Lists dynamic shared objects used by running processes</para>
@y
          <para>
          稼動中のプロセスにて利用されている動的共有オブジェクト (dynamic shared objects) を一覧出力します。
          </para>
@z

@x rpcgen
          <para>Generates C code to implement the Remote Procecure Call (RPC)
          protocol</para>
@y
          <para>
          リモートプロシジャーコール (Remote Procedure Call; RPC) を実装するための C 言語コードを生成します。
          </para>
@z

@x sln
          <para>A statically linked program that creates symbolic links</para>
@y
          <para>
          スタティックリンクによりシンボリックリンクを生成します。
          </para>
@z

@x sotruss
          <para>Traces shared library procedure calls of a specified command</para>
@y
          <para>
          指定されたコマンドの共有ライブラリ内のプロシジャーコールをトレースします。
          </para>
@z

@x sprof
          <para>Reads and displays shared object profiling data</para>
@y
          <para>
          共有オブジェクトのプロファイリングデータを読み込んで表示します。
          </para>
@z

@x tzselect
          <para>Asks the user about the location of the
          system and reports the corresponding time zone description</para>
@y
          <para>
          ユーザーに対してシステムの設置地域を問合せ、対応するタイムゾーンの記述を表示します。
          </para>
@z

@x xtrace
          <para>Traces the execution of a program by
          printing the currently executed function</para>
@y
          <para>
          プログラム内にて現在実行されている関数を表示することで、そのプログラムの実行状況を追跡します。
          </para>
@z

@x zdump
          <para>The time zone dumper</para>
@y
          <para>
          タイムゾーンをダンプします。
          </para>
@z

@x zic
          <para>The time zone compiler</para>
@y
          <para>
          タイムゾーンコンパイラー。
          </para>
@z

@x ld.so
          <para>The helper program for shared library executables</para>
@y
          <para>
          共有ライブラリのためのヘルパープログラム。
          </para>
@z

@x libBrokenLocale
          <para>Used by programs, such as Mozilla, to solve broken locales</para>
@y
          <para>
          Mozilla などのように、壊れたロケールに対処するプログラムにより利用されます。
          </para>
@z

@x libSegFault
          <para>The segmentation fault signal handler</para>
@y
          <para>
          セグメンテーションフォールトのシグナルハンドラー。
          </para>
@z

@x libanl
          <para>An asynchronous name lookup library</para>
@y
          <para>
          非同期の名前解決 (asynchronous name lookup) ライブラリ。
          </para>
@z

@x libc
          <para>The main C library</para>
@y
          <para>
          主要な C ライブラリ。
          </para>
@z

@x libcidn
          <para>Used internally by Glibc for handling internationalized domain
          names in the <function>getaddrinfo()</function> function</para>
@y
          <para>
          Glibc が内部的に利用するもので <function>getaddrinfo()</function> 関数によって国際化ドメイン名 (internationalized domain names) を取り扱います。
          </para>
@z

@x libcrypt
          <para>The cryptography library</para>
@y
          <para>
          暗号化ライブラリ。
          </para>
@z

@x libdl
          <para>The dynamic linking interface library</para>
@y
          <para>
          ダイナミックリンクのインターフェースライブラリ。
          </para>
@z

@x libg
          <para>A runtime library for <command>g++</command></para>
@y
          <para>
          <command>g++</command> に対するランタイムライブラリ。
          </para>
@z

@x libieee
          <para>The Institute of Electrical and Electronic Engineers (IEEE)
          floating point library</para>
@y
          <para>
          IEEE (the Institute of Electrical and Electronic Engineers) の浮動小数点ライブラリ。
          </para>
@z

@x libm
          <para>The mathematical library</para>
@y
          <para>
          数学ライブラリ。
          </para>
@z

@x libmcheck
          <para>Contains code run at boot</para>
@y
          <para>
          起動時のコード実行を提供します。
          </para>
@z

@x libmemusage
          <para>Used by <command>memusage</command> (included in Glibc, but
          not built in a base CLFS system as it has additional dependencies)
          to help collect information about the memory usage of a program</para>
@y
          <para>
          <command>memusage</command> コマンドが利用するもので、プログラムのメモリ使用に関する情報を収集します。
          (<command>memusage</command> コマンドは Glibc に含まれますが、CLFS システム内ではビルドせず、これをビルドするにはさらに依存パッケージを必要とします。)
          </para>
@z

@x libnsl
          <para>The network services library</para>
@y
          <para>
          ネットワークサービスライブラリ。
          </para>
@z

@x libnss
          <para>The Name Service Switch libraries, containing functions for
          resolving host names, user names, group names, aliases, services,
          protocols, etc.</para>
@y
          <para>
          NSS (Name Service Switch) ライブラリ。
          ホスト、ユーザー名、エイリアス、サービス、プロトコルなどの名前解決を行う関数を提供します。
          </para>
@z

@x libpcprofile
          <para>Contains profiling functions used to track the amount of CPU
          time spent in specific source code lines</para>
@y
          <para>
          指定されたソースコード行の処理に費やした総 CPU 時間を計測するためのプロファイリング関数を提供します。
          </para>
@z

@x libpthread
          <para>The POSIX threads library</para>
@y
          <para>
          POSIX スレッドライブラリ。
          </para>
@z

@x libresolv
          <para>Contains functions for creating, sending, and interpreting
          packets to the Internet domain name servers</para>
@y
          <para>
          インターネットドメインネームサーバーに対しての、パケットの生成、送信、解析を行う関数を提供します。
          </para>
@z

@x librpcsvc
          <para>Contains functions providing miscellaneous RPC services</para>
@y
          <para>
          さまざまな RPC サービスを実現する関数を提供します。
          </para>
@z

@x librt
          <para>Contains functions providing most of the interfaces specified by
          the POSIX.1b Realtime Extension</para>
@y
          <para>
          POSIX.1b リアルタイム拡張 (Realtime Extension) にて既定されているインターフェースをほぼ網羅した関数を提供します。
          </para>
@z

@x libthread_db
          <para>Contains functions useful for
          building debuggers for multi-threaded programs</para>
@y
          <para>
          マルチスレッドプログラム用のデバッガーを構築するための有用な関数を提供します。
          </para>
@z

@x libutil
          <para>Contains code for <quote>standard</quote> functions used in
          many different Unix utilities</para>
@y
          <para>
          数多くの Unix ユーティリティにて利用される<quote>標準</quote>関数を提供します。
          </para>
@z