%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Introduction</title>
@y
  <title>はじめに</title>
@z

@x
  <para>This chapter shows how to compile and install a minimal Linux
  system. This system will contain just enough tools to start
  constructing the final CLFS system in <xref
  linkend="chapter-building-system"/> and allow a working environment
  with more user convenience than a minimum environment would.</para>
@y
  <para>
  この章では最小限の Linux システムを構築していく方法を示します。
  このシステムは最終的に<xref
  linkend="chapter-building-system"/>にて CLFS を構築するためのもので、そのために必要なツール類をすべて含んでいます。
  最小限とは言いつつも、取り扱いやすい実行環境を提供します。
  </para>
@z

@x
  <para>The tools in this chapter are cross-compiled using the toolchain in
  <filename class="directory">/cross-tools</filename> and will be installed under the
  <filename class="directory">${CLFS}/tools</filename> directory to keep
  them separate from the files installed in <xref
  linkend="chapter-building-system"/> and the host production directories.
  Since the packages compiled here are temporary, we do not want them to
  pollute the soon-to-be CLFS system.</para>
@y
  <para>
  この章におけるツール類はクロスコンパイルされたものであり、<filename
  class="directory">/cross-tools</filename> にインストールされたツールチェーンを利用します。
  またそれらは <filename class="directory">${CLFS}/tools</filename> ディレクトリにインストールされます。
  これらのツール類は <xref
  linkend="chapter-building-system"/> にインストールされるものや、元からホスト環境にあるものとは区分けされます。
  ここで構築するパッケージ類はあくまで一時的なものであるため、この後に構築する CLFS システムを汚さないように、このようにします。
  </para>
@z

@x
  <para>Check one last time that the <envar>CLFS</envar> environment
  variable is set up properly:</para>
@y
  <para>
  もう一度、環境変数 <envar>CLFS</envar> が正しく設定されているかを確認します。
  </para>
@z

@x
  <para>Make sure the output shows the path to the CLFS partition's mount
  point, which is <filename class="directory">/mnt/clfs</filename>, using
  our example.</para>
@y
  <para>
  上の出力結果が CLFS パーティションのマウントポイントであることを確認してください。
  本書に示す例に従っている場合は <filename class="directory">/mnt/clfs</filename> が表示されるはずです。
  </para>
@z

@x
  <para>During this section of the build you will see several WARNING
  messages like the ones below. It is safe to ignore these messages.</para>
@y
  <para>
  本章でのビルド作業においては、以下に示すような警告 (WARNING) が何度か出力されるかもしれません。
  この出力は無視して構いません。
  </para>
@z