/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util.collections.multi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.webbeans.util.collections.ConcurrentList;
import org.jboss.webbeans.util.collections.ForwardingConcurrentMap;
import org.jboss.webbeans.util.collections.multi.ConcurrentListMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentListHashMultiMap<K, V>
extends ForwardingConcurrentMap<K, ConcurrentList<V>>
implements ConcurrentListMultiMap<K, V> {
    private final ConcurrentList<V> EMPTY_LIST = ConcurrentList.emptyList();
    private ConcurrentHashMap<K, ConcurrentList<V>> delegate = new ConcurrentHashMap();

    @Override
    protected ConcurrentMap<K, ConcurrentList<V>> delegate() {
        return this.delegate;
    }

    @Override
    public void deepPutAll(Map<? extends K, ? extends ConcurrentList<V>> map) {
        for (Map.Entry<K, ConcurrentList<V>> entry : map.entrySet()) {
            this.put(entry.getKey(), new ConcurrentList(entry.getValue()));
        }
    }

    @Override
    public ConcurrentList<V> get(Object key) {
        ConcurrentList<V> values = (ConcurrentList<V>)super.get(key);
        return values != null ? values : this.EMPTY_LIST;
    }

    @Override
    public void put(K key, V value) {
        this.delegate.putIfAbsent(key, new ConcurrentList());
        ((CopyOnWriteArrayList)this.get(key)).add(value);
    }
}

