/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.xml.checker.beanchildren.ext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.DefinitionException;
import org.dom4j.Element;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.xml.ParseXmlHelper;
import org.jboss.webbeans.xml.XmlEnvironment;
import org.jboss.webbeans.xml.checker.beanchildren.ext.AbstractBeanChildrenChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBeanChildrenChecker
extends AbstractBeanChildrenChecker {
    public SimpleBeanChildrenChecker(XmlEnvironment environment, Map<String, Set<String>> packagesMap) {
        super(environment, packagesMap);
    }

    @Override
    protected void checkForDecoratorChild(Element beanElement) {
        if (ParseXmlHelper.findElementsInEeNamespace(beanElement, "Interceptor").size() > 1) {
            throw new DefinitionException("A simple bean element <" + beanElement.getName() + "> has more than one direct child <" + "Interceptor" + ">");
        }
    }

    @Override
    protected void checkForInterceptorChild(Element beanElement) {
        if (ParseXmlHelper.findElementsInEeNamespace(beanElement, "Decorator").size() > 1) {
            throw new DefinitionException("A simple bean element <" + beanElement.getName() + "> has more than one direct child <" + "Decorator" + ">");
        }
    }

    @Override
    protected void checkChildForInterceptorType(Element beanChildElement) {
        if (this.haveBeanInterceptorDeclaration) {
            throw new DefinitionException("There is second element of interceptor type <" + beanChildElement.getName() + "> in bean '" + beanChildElement.getParent().getName() + "'");
        }
        this.haveBeanInterceptorDeclaration = true;
    }

    @Override
    protected void checkChildForDecoratorType(Element beanChildElement) {
        if (this.haveBeanDecoratorDeclaration) {
            throw new DefinitionException("There is second element of decorator type <" + beanChildElement.getName() + "> in bean '" + beanChildElement.getParent().getName() + "'");
        }
        this.haveBeanDecoratorDeclaration = true;
    }

    @Override
    protected void checkForConstructor(Element beanElement, AnnotatedClass<?> beanClass) {
        if (this.constructorParameters.size() == 0) {
            return;
        }
        ArrayList matchableConstructors = new ArrayList();
        for (AnnotatedConstructor<?> constructor : beanClass.getConstructors()) {
            List<AnnotatedParameter<?>> parameters = constructor.getParameters();
            if (parameters.size() != this.constructorParameters.size()) continue;
            boolean isMacthable = true;
            for (int i = 0; i < parameters.size(); ++i) {
                if (parameters.get(i).isAssignableFrom((AnnotatedItem)this.constructorParameters.get(i))) continue;
                isMacthable = false;
                break;
            }
            if (!isMacthable) continue;
            matchableConstructors.add(constructor);
        }
        if (matchableConstructors.size() == 0) {
            throw new DefinitionException("There is no constructor of the simple bean '" + beanElement.getName() + "' with the same number and types of parameters as declared");
        }
        if (matchableConstructors.size() > 1) {
            throw new DefinitionException("There is more than one constructor of the simple bean '" + beanElement.getName() + "' with the same number and types of parameters as declared");
        }
    }

    @Override
    protected void checkRIBean(Element beanElement, AnnotatedClass<?> beanClass) {
        throw new DefinitionException("It is impossible determine some kind of resource in not Resource Bean");
    }
}

