/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.xml.registrator.bean.ext;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.inject.Current;
import javax.inject.DeploymentType;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.dom4j.Element;
import org.jboss.webbeans.bean.ee.PersistenceContextBean;
import org.jboss.webbeans.bean.ee.PersistenceUnitBean;
import org.jboss.webbeans.bean.ee.RemoteEjbBean;
import org.jboss.webbeans.bean.ee.ResourceBean;
import org.jboss.webbeans.bean.ee.WebServiceBean;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.persistence.spi.JpaServices;
import org.jboss.webbeans.resources.spi.ResourceServices;
import org.jboss.webbeans.util.reflection.AnnotationImpl;
import org.jboss.webbeans.ws.spi.WebServices;
import org.jboss.webbeans.xml.ParseXmlHelper;
import org.jboss.webbeans.xml.checker.beanchildren.BeanChildrenChecker;
import org.jboss.webbeans.xml.registrator.bean.ext.NotSimpleBeanElementRegistrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceElementRegistrator
extends NotSimpleBeanElementRegistrator {
    public ResourceElementRegistrator(BeanChildrenChecker childrenChecker) {
        super(childrenChecker);
    }

    @Override
    public boolean accept(Element beanElement, AnnotatedClass<?> beanClass) {
        if (ParseXmlHelper.isJavaEeNamespace(beanElement) && (beanElement.getName().equalsIgnoreCase("Topic") || beanElement.getName().equalsIgnoreCase("Queue"))) {
            return false;
        }
        Iterator elIterator = beanElement.elementIterator();
        while (elIterator.hasNext()) {
            Element child = (Element)elIterator.next();
            if (!ParseXmlHelper.isJavaEeNamespace(child) || !child.getName().equalsIgnoreCase("Resource") && !child.getName().equalsIgnoreCase("PersistenceContext") && !child.getName().equalsIgnoreCase("PersistenceUnit") && !child.getName().equalsIgnoreCase("EJB") && !child.getName().equalsIgnoreCase("WebServiceRef")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void register(Element beanElement, AnnotatedClass<?> beanClass) {
        List<Element> resourceElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "Resource");
        if (resourceElements.size() > 0) {
            this.registerResourceBean(resourceElements.get(0), beanClass);
            return;
        }
        List<Element> persContextElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "PersistenceContext");
        if (persContextElements.size() > 0) {
            this.registerPersContextBean(persContextElements.get(0), beanClass);
            return;
        }
        List<Element> persUnitElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "PersistenceUnit");
        if (persUnitElements.size() > 0) {
            this.registerPersUnitBean(persUnitElements.get(0), beanClass);
            return;
        }
        List<Element> ejbElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "EJB");
        if (ejbElements.size() > 0) {
            this.registerEjbBean(ejbElements.get(0), beanClass);
            return;
        }
        List<Element> webServiceRefElements = ParseXmlHelper.findElementsInEeNamespace(beanElement, "WebServiceRef");
        if (webServiceRefElements.size() > 0) {
            this.registerWebServiceRefBean(webServiceRefElements.get(0), beanClass);
            return;
        }
    }

    private void registerResourceBean(Element resourceElement, AnnotatedClass<?> beanClass) {
        Class<? extends Annotation> deploymentType = this.obtainDeploymentType(resourceElement.getParent());
        Set<Annotation> bindings = this.obtainBindings(resourceElement.getParent());
        Class type = beanClass.getRawType();
        String jndiName = this.obtainElementValue(resourceElement, "name");
        String mappedName = this.obtainElementValue(resourceElement, "mappedName");
        ResourceBean bean = new ResourceBean(this.environment.getManager(), deploymentType, bindings, type, jndiName, mappedName);
        if (this.environment.getServices().contains(ResourceServices.class)) {
            this.environment.getResourceBeans().add(bean);
        }
    }

    private void registerPersContextBean(Element persContextElement, AnnotatedClass<?> beanClass) {
        Class<? extends Annotation> deploymentType = this.obtainDeploymentType(persContextElement.getParent());
        Set<Annotation> bindings = this.obtainBindings(persContextElement.getParent());
        String unitName = this.obtainElementValue(persContextElement, "unitName");
        PersistenceContextBean bean = new PersistenceContextBean(this.environment.getManager(), deploymentType, bindings, unitName);
        if (this.environment.getServices().contains(JpaServices.class)) {
            this.environment.getResourceBeans().add(bean);
        }
    }

    private void registerPersUnitBean(Element persUnitElement, AnnotatedClass<?> beanClass) {
        Class<? extends Annotation> deploymentType = this.obtainDeploymentType(persUnitElement.getParent());
        Set<Annotation> bindings = this.obtainBindings(persUnitElement.getParent());
        String unitName = this.obtainElementValue(persUnitElement, "unitName");
        PersistenceUnitBean bean = new PersistenceUnitBean(this.environment.getManager(), deploymentType, bindings, unitName);
        if (this.environment.getServices().contains(JpaServices.class)) {
            this.environment.getResourceBeans().add(bean);
        }
    }

    private void registerEjbBean(Element ejbElement, AnnotatedClass<?> beanClass) {
        Class<? extends Annotation> deploymentType = this.obtainDeploymentType(ejbElement.getParent());
        Set<Annotation> bindings = this.obtainBindings(ejbElement.getParent());
        Class type = beanClass.getRawType();
        String jndiName = this.obtainElementValue(ejbElement, "name");
        String mappedName = this.obtainElementValue(ejbElement, "mappedName");
        String ejbLink = this.obtainElementValue(ejbElement, "ejbLink");
        RemoteEjbBean bean = new RemoteEjbBean(this.environment.getManager(), deploymentType, bindings, type, jndiName, mappedName, ejbLink);
        if (this.environment.getServices().contains(EjbServices.class)) {
            this.environment.getResourceBeans().add(bean);
        }
    }

    private void registerWebServiceRefBean(Element webServiceRefElement, AnnotatedClass<?> beanClass) {
        Class<? extends Annotation> deploymentType = this.obtainDeploymentType(webServiceRefElement.getParent());
        Set<Annotation> bindings = this.obtainBindings(webServiceRefElement.getParent());
        Class type = beanClass.getRawType();
        String jndiName = this.obtainElementValue(webServiceRefElement, "name");
        String mappedName = this.obtainElementValue(webServiceRefElement, "mappedName");
        String wsdlLocation = this.obtainElementValue(webServiceRefElement, "wsdlLocation");
        WebServiceBean bean = new WebServiceBean(this.environment.getManager(), deploymentType, bindings, type, jndiName, mappedName, wsdlLocation);
        if (this.environment.getServices().contains(WebServices.class)) {
            this.environment.getResourceBeans().add(bean);
        }
    }

    private Class<? extends Annotation> obtainDeploymentType(Element beanElement) {
        Iterator elIterator = beanElement.elementIterator();
        while (elIterator.hasNext()) {
            Element childElement = (Element)elIterator.next();
            AnnotatedClass<Object> childClass = ParseXmlHelper.loadElementClass(childElement, Object.class, this.environment, this.packagesMap);
            if (!childClass.getRawType().isAnnotation() || !childClass.isAnnotationPresent(DeploymentType.class)) continue;
            return ParseXmlHelper.loadAnnotationClass(childElement, Annotation.class, this.environment, this.packagesMap);
        }
        return null;
    }

    private Set<Annotation> obtainBindings(Element beanElement) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        Iterator elIterator = beanElement.elementIterator();
        while (elIterator.hasNext()) {
            Element childElement = (Element)elIterator.next();
            AnnotatedClass<Object> childClass = ParseXmlHelper.loadElementClass(childElement, Object.class, this.environment, this.packagesMap);
            if (!childClass.getRawType().isAnnotation() || childClass.isAnnotationPresent(DeploymentType.class) || childClass.getRawType().equals(Resource.class) || childClass.getRawType().equals(PersistenceContext.class) || childClass.getRawType().equals(PersistenceUnit.class) || childClass.getRawType().equals(EJB.class) || childClass.getRawType().equals(WebServiceRef.class)) continue;
            Class annotationClass = childClass.getRawType();
            Method[] annotationMethods = annotationClass.getDeclaredMethods();
            AnnotationImpl annotation = new AnnotationImpl(annotationClass, annotationMethods);
            result.add(annotation);
        }
        if (result.size() == 0) {
            Class<Current> annotationClass = Current.class;
            Method[] annotationMethods = annotationClass.getDeclaredMethods();
            AnnotationImpl<Current> annotation = new AnnotationImpl<Current>(annotationClass, annotationMethods);
            result.add(annotation);
        }
        return result;
    }

    private String obtainElementValue(Element elementParent, String elementName) {
        List<Element> elements = ParseXmlHelper.findElementsInEeNamespace(elementParent, elementName);
        if (elements.size() > 0) {
            Element element = elements.get(0);
            return element.getData().toString();
        }
        return null;
    }
}

