/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.sco.simple;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.NullsNotAllowedException;
import org.datanucleus.sco.SCOList;
import org.datanucleus.sco.SCOListIterator;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class List
extends AbstractList
implements SCOList,
Cloneable,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected StateManager ownerSM;
    protected String fieldName;
    protected int fieldNumber;
    protected boolean allowNulls;
    protected ArrayList delegate;

    public List(StateManager ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = true;
        if (ownerSM != null) {
            this.fieldNumber = ownerSM.getClassMetaData().getMetaDataForMember(fieldName).getAbsoluteFieldNumber();
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        this.delegate = c != null ? new ArrayList(c) : new ArrayList();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, this.allowNulls, false)));
        }
    }

    public void initialise() {
        this.delegate = new ArrayList();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, this.allowNulls, false)));
        }
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void flush() {
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.ownerSM = null;
            this.fieldName = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.fieldNumber);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        ArrayList detached = new ArrayList();
        SCOUtils.detachCopyForCollection(this.ownerSM, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        ArrayList attachedElements = new ArrayList(c.size());
        SCOUtils.attachCopyForCollection(this.ownerSM, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.updateListWithListElements(this, attachedElements);
    }

    public Object clone() {
        return this.delegate.clone();
    }

    public synchronized boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public Object get(int index) {
        return this.delegate.get(index);
    }

    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    public int indexOf(Object element) {
        return this.delegate.indexOf(element);
    }

    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int lastIndexOf(Object element) {
        return this.delegate.lastIndexOf(element);
    }

    public synchronized Iterator iterator() {
        return new SCOListIterator(this, this.ownerSM, this.delegate, null, true, -1);
    }

    public ListIterator listIterator() {
        return new SCOListIterator(this, this.ownerSM, this.delegate, null, true, -1);
    }

    public ListIterator listIterator(int index) {
        return new SCOListIterator(this, this.ownerSM, this.delegate, null, true, index);
    }

    public synchronized int size() {
        return this.delegate.size();
    }

    public synchronized java.util.List subList(int from, int to) {
        return this.delegate.subList(from, to);
    }

    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public synchronized boolean add(Object element) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        boolean success = this.delegate.add(element);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public void add(int index, Object element) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        this.delegate.add(index, element);
        this.makeDirty();
    }

    public boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public boolean addAll(int index, Collection elements) {
        boolean success = this.delegate.addAll(index, elements);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized void clear() {
        this.delegate.clear();
        this.makeDirty();
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public Object remove(int index) {
        Object obj = this.delegate.remove(index);
        this.makeDirty();
        return obj;
    }

    public boolean removeAll(Collection elements) {
        boolean success = this.delegate.removeAll(elements);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public Object set(int index, Object element, boolean allowDependentField) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        Object obj = this.delegate.set(index, element);
        this.makeDirty();
        return obj;
    }

    public Object set(int index, Object element) {
        return this.set(index, element, true);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new ArrayList(this.delegate);
    }
}

