/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkupResourceData {
    private static final Logger log = LoggerFactory.getLogger((Class)MarkupResourceData.class);
    public static final MarkupResourceData NO_MARKUP_RESOURCE_DATA = new MarkupResourceData();
    private MarkupResourceStream resource;
    private Markup baseMarkup;
    private String xmlDeclaration;
    private String encoding;
    private String wicketNamespace;
    private String wicketId;

    MarkupResourceData() {
        this.setWicketNamespace("wicket");
    }

    public String toString() {
        if (this.resource != null) {
            return this.resource.toString();
        }
        return "(unknown resource)";
    }

    public MarkupResourceStream getResource() {
        return this.resource;
    }

    public String getXmlDeclaration() {
        return this.xmlDeclaration;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getWicketNamespace() {
        return this.wicketNamespace;
    }

    public final String getWicketId() {
        return this.wicketId;
    }

    final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final void setWicketNamespace(String wicketNamespace) {
        this.wicketNamespace = wicketNamespace;
        this.wicketId = wicketNamespace + ":id";
        if (!"wicket".equals(wicketNamespace)) {
            log.info("You are using a non-standard component name: " + wicketNamespace);
        }
    }

    final void setXmlDeclaration(String xmlDeclaration) {
        this.xmlDeclaration = xmlDeclaration;
    }

    final void setResource(MarkupResourceStream resource) {
        this.resource = resource;
    }

    public MarkupResourceData getBaseMarkupResourceData() {
        if (this.baseMarkup == null) {
            return null;
        }
        return this.baseMarkup.getMarkupResourceData();
    }

    public void setBaseMarkup(Markup baseMarkup) {
        this.baseMarkup = baseMarkup;
    }

    public Markup getBaseMarkup() {
        return this.baseMarkup;
    }
}

