/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.util.lang.Packages;

public class PackageResourceGuard
implements IPackageResourceGuard {
    private Set blockedExtensions = new HashSet(4);

    public PackageResourceGuard() {
        this.blockedExtensions.add("properties");
        this.blockedExtensions.add("class");
        this.blockedExtensions.add("java");
    }

    public boolean accept(Class scope, String path) {
        String absolutePath = Packages.absolutePath(scope, path);
        return this.acceptAbsolutePath(absolutePath);
    }

    protected boolean acceptAbsolutePath(String path) {
        int ixExtension = path.lastIndexOf(46);
        int len = path.length();
        String ext = ixExtension <= 0 || ixExtension == len || path.lastIndexOf(47) + 1 == ixExtension ? null : path.substring(ixExtension + 1).toLowerCase();
        if ("html".equals(ext) && this.getClass().getClassLoader().getResource(path.replaceAll(".html", ".class")) != null) {
            return false;
        }
        return this.acceptExtension(ext);
    }

    protected boolean acceptExtension(String extension) {
        return !this.blockedExtensions.contains(extension);
    }

    protected final Set getBlockedExtensions() {
        return this.blockedExtensions;
    }

    protected final void setBlockedExtensions(Set blockedExtensions) {
        this.blockedExtensions = blockedExtensions;
    }
}

